 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the animate
   >>>>		       animate display widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 05, 1992 15:00
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AnimateP_h_
#define _xvisual_AnimateP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/ImageP.h>
#include <xvisual/Animate.h>


    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwAnimateWidgetClass
{
    XtPointer  extension;
} XvwAnimateWidgetClassPart;


typedef struct _XvwAnimateWidgetClassRec
{
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XvwManagerWidgetClassPart	manager_class;
    XvwGraphicsWidgetClassPart	graphics_class;
    XvwColorWidgetClassPart	color_class;
    XvwImageWidgetClassPart	image_class;
    XvwAnimateWidgetClassPart	animate_class;
} XvwAnimateWidgetClassRec;


typedef struct
{
    double  update_time;
    int     mode;
    int     control;
    int     direction;
    Boolean continous;
    XtIntervalId time_id;   /* Time interval Id for the XtTimeout */
    xvobject framenum;
    XtCallbackList update_callback;
} XvwAnimatePart;


typedef struct _XvwAnimateWidgetRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XvwManagerPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
    XvwImagePart	image;
    XvwAnimatePart	animate;
} XvwAnimateWidgetRec;


typedef struct  _XvwAnimateWidgetClassRec  *XvwAnimateWidgetClass;
typedef struct  _XvwAnimateWidgetRec       *XvwAnimateWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwAnimateWidget
 */
extern  XvwAnimateWidgetClassRec	xvwAnimateWidgetClassRec;


#endif /* _xvisual_AnimateP_h_ */
/* Don't add after this point */
