 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: all #defines, structures, and global
   >>>>		       definitions used by the xvgraphics
   >>>>		       library
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvgraphics_xvgraphics_h_
#define _xvgraphics_xvgraphics_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 * Value definitions for General Graphics Attributes
 */

/*
 *  Defines for the line widths.
 */
#define KLINE_NONE           0
#define KLINE_EXTRA_FINE     1
#define KLINE_FINE           2
#define KLINE_MEDIUM_FINE    3
#define KLINE_MEDIUM         4
#define KLINE_MEDIUM_WIDE    5
#define KLINE_WIDE           6
#define KLINE_EXTRA_WIDE     7

/*
 *  Defines for the line types.
 */
#define KLINE_SOLID          1
#define KLINE_DOTTED         2
#define KLINE_DOT_DASH       3
#define KLINE_SHORT_DASH     4
#define KLINE_LONG_DASH      5
#define KLINE_ODD_DASH       6
#define KLINE_GRID_DOTTED    7

/*
 *  Defines for the marker types.
 */
#define KMARKER_NONE            0
#define KMARKER_ARC             1
#define KMARKER_BOW_TIE         2
#define KMARKER_BOX             3
#define KMARKER_CARET           4
#define KMARKER_CIRCLE          5
#define KMARKER_CROSS           6
#define KMARKER_DAGGER          7
#define KMARKER_DIAMOND         8
#define KMARKER_DOT             9
#define KMARKER_HEXAGON         10
#define KMARKER_POINT           11
#define KMARKER_SQUARE          12
#define KMARKER_TRIANGLE        13
#define KMARKER_V               14
#define KMARKER_X               15



/* Dimensions */

#define KGRAPHICS_2D		2
#define KGRAPHICS_3D		3

/* 3D Projection Models */

#define KGRAPHICS_PERSPECTIVE   1
#define KGRAPHICS_ORTHOGRAPHIC  2
#define KGRAPHICS_CAVALIER      3
#define KGRAPHICS_CABINET       4

/* 3D Scaling Types */

#define KGRAPHICS_LINEAR 	1 
#define KGRAPHICS_LOG10  	2  
#define KGRAPHICS_LN     	3

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 * general utility matrix structures used by all routines
 */

#ifndef Real
typedef	 double	Real;
#endif

#ifndef Index
typedef	 unsigned long Index;
#endif

typedef  Real	Matrix[4][4];
typedef  Real	Matrix_2D[3][3];

/*
 * general utility vector structures used by all routines:
 * note: the difference between a "vector" here and the 
 * identical "coord" structure that follows is that a 
 * "vector" has a direction associated with it, while a 
 * "coord" implies a mathematical point.
 */
typedef  struct
{ 
   Real x, y, z;
}  Vector;


/*
 * general utility point coordinate  structures used by all routines
 * note: the difference between a "coord" here and the 
 * identical "vector" structure above is that a 
 * "coord" implies a mathematical point, while
 * "vector" has a direction associated with it. 
 */
typedef  struct
{
   Real  x, y, z;
   Index d;
}  Coord;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* X11.c */
int X3D_set_X11 PROTO((int, Display *, Drawable, Widget));

/* bezier.c */
void X3D_draw_bezier PROTO((int, Coord *, int, int, XColor *));
void X3D_blend_patch PROTO((Coord, Coord, Coord, Coord, register Real, Coord *));
void X3D_bezier_surface PROTO((int, Coord *, int, int, Real *, XColor *, int, Coord, Coord));

/* check.c */
int X3D_check_graphics PROTO((int));

/* color.c */
int X3D_allocate_named_color PROTO((Display *, char *, XColor *, int));
int X3D_allocate_named_colors PROTO((Display *, char **, XColor *, int, int));
int X3D_allocate_predefined_colors PROTO((Display *, XColor *, int, int));

/* contour.c */
void X3D_draw_contour PROTO((int, Coord *, int, int, Real *, XColor *, int, int, int));
Real *X3D_get_contour_levels PROTO((Real, Real, Real, int));

/* convert_2D.c */
int X2D_convert_point_wc_to_dc PROTO((int, Coord, Real *, Real *));
int X2D_convert_point_dc_to_wc PROTO((int, Real, Real, Coord *));

/* convert_3D.c */
int X3D_convert_point_wc_to_dc PROTO((int, Coord, Real *, Real *));
int X3D_convert_point_wc_to_ndc PROTO((int, Coord, Coord *));

/* coord_2D.c */
void X2D_translate_coords PROTO((Real, Real, Coord *, int));
void X2D_scale_coords PROTO((Real, Real, Coord *, int));
void X2D_rotate_coords PROTO((Real, Coord, Coord *, int));

/* coord_3D.c */
void X3D_translate_coords PROTO((Real, Real, Real, Coord *, int));
void X3D_scale_coords PROTO((Real, Real, Real, Coord *, int));
void X3D_rotate_coords PROTO((Real, Real, Real, Coord, Coord *, int));

/* draw_2D.c */
void X2D_draw_polyline PROTO((int, Coord *, int, XColor *));
void X2D_draw_discrete PROTO((int, Coord *, int, XColor *));
void X2D_draw_bargraph PROTO((int, Coord *, int, XColor *));
void X2D_draw_histogram PROTO((int, Coord *, int, Coord, Coord, int, XColor *));
void X2D_draw_polymarker PROTO((int, Coord *, int, int, XColor *));
void X2D_draw_colormarker PROTO((int, Coord *, int, int, XColor *, int, XColor *));
void X2D_draw_linemarker PROTO((int, Coord *, int, int, XColor *));
void X2D_draw_polygon PROTO((int, Coord *, int, XColor *));
void X2D_draw_segments PROTO((int, Coord *, int, XColor *));
void X2D_draw_line PROTO((int, Coord, Coord, XColor *));
void X2D_draw_marker PROTO((int, Coord, int, XColor *));
void X2D_draw_rectangle PROTO((int, Coord, Real, Real, XColor *));
void X2D_draw_circle PROTO((int, Coord, Real, XColor *));
void X2D_draw_colorline PROTO((int, Coord *, int, Real *, XColor *, int));
void X2D_fill_rectangle PROTO((int, Coord, Real, Real, XColor *, XColor *));
void X2D_fill_circle PROTO((int, Coord, Real, XColor *, XColor *));

/* draw_3D.c */
void X3D_draw_polyline PROTO((int, Coord *, int, XColor *));
void X3D_draw_lineplot PROTO((int, Coord *, int, int, XColor *));
void X3D_draw_wireframe PROTO((int, Coord *, int, int, XColor *));
void X3D_draw_impulse PROTO((int, Coord *, int, XColor *));
void X3D_draw_polymarker PROTO((int, Coord *, int, int, XColor *));
void X3D_draw_colormarker PROTO((int, Coord *, int, int, XColor *, int, XColor *));
void X3D_draw_polygon PROTO((int, Coord *, int, XColor *, XColor *));
void X3D_draw_segments PROTO((int, Coord *, int, XColor *));
void X3D_draw_line PROTO((int, Coord, Coord, XColor *));
void X3D_draw_rectangle PROTO((int, Coord, Real, Real, Real, XColor *));
void X3D_draw_mesh PROTO((int, Coord *, int, int, XColor *, XColor *));
void X3D_draw_horizon PROTO((int, Coord *, int, int, XColor *, XColor *, Coord, Coord));
void X3D_draw_colormesh PROTO((int, Coord *, int, int, Real *, XColor *, int, int, XColor *, Coord, Coord));
void X3D_draw_colorline PROTO((int, Coord *, int, Real *, XColor *, int, int));

/* font_3D.c */
void X3D_set_font PROTO((int, char *));

/* get_2D.c */
int X2D_get_window PROTO((int, int *, int *, unsigned int *, unsigned int *));
int X2D_get_viewport PROTO((int, Coord *, Coord *));
int X2D_get_wc_min_max PROTO((int, Coord *, Coord *));

/* get_3D.c */
int X3D_get_projection PROTO((int, int *));
int X3D_get_viewpoint PROTO((int, Real *, Real *, Real *, Real *));
int X3D_get_focus PROTO((int, Coord *));
int X3D_get_camera PROTO((int, Coord *, Coord *));
int X3D_get_view_distance PROTO((int, Real *));
int X3D_get_window PROTO((int, int *, int *, unsigned int *, unsigned int *));
int X3D_get_viewport PROTO((int, Coord *, Coord *));
int X3D_get_wc_min_max PROTO((int, Coord *, Coord *));
char **X3D_get_fonts PROTO((int *));
int X3D_get_win_type PROTO((int, int *));

/* graphics.c */
int X3D_close_device PROTO((int));
int X3D_inquire_device PROTO((int));

/* graphics_2D.c */
int X2D_set_window PROTO((int, int, int, unsigned int, unsigned int));
int X2D_set_viewport PROTO((int, Coord, Coord));
int X2D_set_wc_min_max PROTO((int, Coord, Coord));
int X2D_set_wc_scale PROTO((int, int, int));
int X2D_set_clipping PROTO((int, int));

/* graphics_3D.c */
int X3D_init_graphics PROTO((int, int));
int X3D_set_projection PROTO((int, int));
int X3D_close_graphics PROTO((int));
int X3D_set_viewpoint PROTO((int, Real, Real, Real, Real));
int X3D_set_focus PROTO((int, Coord));
int X3D_set_camera PROTO((int, Coord, Coord));
int X3D_set_view_distance PROTO((int, Real));
int X3D_set_window PROTO((int, int, int, unsigned int, unsigned int));
int X3D_set_viewport PROTO((int, Coord, Coord));
int X3D_set_wc_min_max PROTO((int, Coord, Coord));
int X3D_set_wc_scale PROTO((int, int, int, int));
int X3D_set_line_type PROTO((int, int));
int X3D_set_line_width PROTO((int, int));
int X3D_set_draw PROTO((int, XColor *));
int X3D_set_fill PROTO((int, XColor *));
int X3D_set_clipping PROTO((int, int, int));
int X3D_set_resize_view PROTO((int, int));

/* matrix_2D.c */
void X2D_matrix_set_translate PROTO((Real, Real, Matrix_2D));
void X2D_matrix_set_scale PROTO((Real, Real, Matrix_2D));
void X2D_matrix_set_rotate PROTO((Real, Matrix_2D));
int X2D_matrix_set_inverse PROTO((Matrix_2D, Matrix_2D));

/* matrix_3D.c */
void X3D_matrix_set_translate PROTO((Real, Real, Real, Matrix));
void X3D_matrix_set_scale PROTO((Real, Real, Real, Matrix));
void X3D_matrix_set_rotate PROTO((Real, Real, Real, Matrix));

/* surface.c */
void X3D_shade_constant PROTO((int, Coord *, int, int, Real *, XColor *, int, int, Coord, Coord, int));
void X3D_shade_ghouraud PROTO((int, Coord *, int, int, Real *, XColor *, int, int, Coord, Coord, int));
void X3D_shade_phong PROTO((int, Coord *, int, int, Real *, XColor *, int, int, Coord, Coord, int));

/* text_2D.c */
void X2D_draw_text PROTO((int, Coord, Vector, Real, Real, char *, int, XColor *));
void X2D_clear_text PROTO((int, Coord, Vector, Real, Real, int, XColor *));

/* text_3D.c */
void X3D_set_text PROTO((int, int, Real, Real));
void X3D_draw_text PROTO((int, Coord, Vector, Real, Real, Real, char *, int, XColor *));
void X3D_clear_text PROTO((int, Coord, Vector, Real, Real, int, XColor *));

/* utils_2D.c */
void X2D_add_coords PROTO((Coord *, Coord *, Coord *));
void X2D_subtract_coords PROTO((Coord *, Coord *, Coord *));
void X2D_multiply_coords PROTO((Coord *, Coord *, Coord *));
void X2D_divide_coords PROTO((Coord *, Coord *, Coord *));
int X2D_normalize PROTO((Coord *));
Real X2D_dot_product PROTO((Coord *, Coord *));
Real X2D_distance PROTO((Coord *, Coord *));
Real X2D_cartesian_to_spherical PROTO((Real, Real));
void X2D_spherical_to_cartesian PROTO((Real, Real, Real *, Real *));
void X2D_perpendicular PROTO((Coord *, Coord *));

/* utils_3D.c */
void X3D_add_coords PROTO((Coord *, Coord *, Coord *));
void X3D_subtract_coords PROTO((Coord *, Coord *, Coord *));
void X3D_multiply_coords PROTO((Coord *, Coord *, Coord *));
void X3D_divide_coords PROTO((Coord *, Coord *, Coord *));
void X3D_normalize PROTO((Coord *));
void X3D_cross_product PROTO((Coord *, Coord *, Coord *));
Real X3D_dot_product PROTO((Coord *, Coord *));
Real X3D_distance PROTO((Coord *, Coord *));
void X3D_cartesian_to_spherical PROTO((Coord *, Coord *, Real, Real *, Real *, Real *));
void X3D_spherical_to_cartesian PROTO((Real, Real, int, Real, Real *, Coord *, Coord *));
void X3D_perpendicular PROTO((Coord, Coord, Real, Coord *));

/* window_2D.c */
int X2D_clear_area PROTO((int, Coord, Coord));
int X2D_clear_window PROTO((int));
int X2D_raise_window PROTO((int));

/* window_3D.c */
int X3D_clear_area PROTO((int, Coord, Coord));
int X3D_clear_window PROTO((int));
int X3D_raise_window PROTO((int));

#endif /* _xvgraphics_xvgraphics_h_ */
/* Don't add after this point */
