#include <xvinclude.h>


/*
 *   This example program puts up 5 pairs of labels & buttons.
 *   It adds very simple callbacks to the buttons.
 */
#define BUTTON_NUM 5

static void button_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	int      *button_id;
	char     temp[KLENGTH];
	xvobject manager;
	xvobject button;
	xvobject label;
	xvobject horiz_offset;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "back");

	/*
	 * create 5 pairs of buttons & labels, each button appearing
	 * under its label.  Using horiz_offset allows us to create the
	 * pairs in a line.
	 */
	horiz_offset = NULL;
	for (i = 0; i < BUTTON_NUM; i++)
	{
	   ksprintf(temp, "label%d", i+1);
	   label  = xvw_create_label(manager, "label");
	   xvw_set_attributes(label,
		      XVW_LABEL,        temp,          /* numbered label  */
		      XVW_RIGHT_OF,     horiz_offset,  /* line of buttons */
		      XVW_BELOW,        NULL,          /* top row         */
		      XVW_CHAR_WIDTH,   10.0,          /* 10 chars wide   */
		      XVW_CHAR_HEIGHT,  2.0,           /* 2 char  high    */
		      XVW_BORDER_WIDTH, 0,             /* no border       */
		      NULL);

	   ksprintf(temp, "button%d", i+1);
	   button = xvw_create_button(manager, "button");
	   xvw_set_attributes(button,
		      XVW_LABEL,        temp,          /* numbered label  */
		      XVW_RIGHT_OF,     horiz_offset,  /* line of labels  */
		      XVW_BELOW,        label,         /* below the label */
		      XVW_CHAR_WIDTH,   10.0,          /* 10 chars wide   */
		      XVW_CHAR_HEIGHT,  2.0,           /* 2 char high     */
		      XVW_BORDER_WIDTH, 1,             /* thin border     */
		      NULL);

	   button_id = (int *) kmalloc(sizeof(int));
	   *button_id = 100+i;
	   xvw_add_callback(button, XVW_BUTTON_SELECT, button_cb, button_id);

	   horiz_offset = label;
	}

	/* display & run program */
	xvf_run_form();
}

static void button_cb (
    xvobject object,
    kaddr    client_data, /* not used */
    kaddr    call_data)   /* not used */
{
	char *label;

	/*
	 * sent in a pointer to an integer as client_data;
	 * have to retrieve it by using an appropriate cast
	 */
	int  *number = (int *) client_data;

	/*
	 *  see what the label of the button is
	 */
	xvw_get_attribute(object, XVW_LABEL, &label);

	/*
	 *  print out button label, with ID number
	 */
	kfprintf(kstderr, "Button click on %s, ID number %d\n", 
	        label, *number);
}
