#include <xvinclude.h>

/*
 * This example demonstrates the two uses of xvu_run_list_wait().
 *
 *  First, a list is popped up from which the user must choose one
 *  of the items provided.  An info object is popped up indicating
 *  the choice.  If "cancel" is chosen, the default provided is
 *  considered the "choice".
 *
 *  Second, a list is popped up from which the user may pick an item,
 *  or provide their own in the text parameter box provided.  An info
 *  object is popped up indicating their choice.  If "cancel" is chosen,
 *  the default provided is considered the "choice".
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
        int default_index, user_defined;
        xvw_list_struct *list_return;
 
        static char *prompt1 = "Pick a fruit";
        static char *prompt2 = "Pick a veggie, or provide your own";
        static char *label  = "Available";
        static char *fruit[]   = { "Apples", "Oranges", "Bananas", "Peaches",
                                   "Limes", "Lemons", "Papayas", "Mangoes" };
        static char *veggies[] = { "Carrot", "Celery", "Cucumber", "Tomato",
                                   "Onion",  "Radish", "Cabbage", "Corn" };
                                 
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(1);
	}

	/*
	 *  pop up the first list widget; this one does NOT allow
         *  the user to provide their own choice.
	 */
	default_index = 3;
	user_defined = FALSE;
        list_return = xvu_run_list_wait(fruit, knumber(fruit), prompt1, 
				        label, default_index, user_defined);
	/* print choice */
        kfprintf(kstderr, "Choice made was: '%s' (%d)\n", 
	      list_return->string, list_return->list_index);

	/*
         *  pop up the second list widget; this one DOES allow
         *  the user to provide their own choice.
         */
        default_index = 1;
        user_defined = TRUE;
        list_return = xvu_run_list_wait(veggies, knumber(veggies), prompt2, 
				        label, default_index, user_defined);
        /* print choice */
        kfprintf(kstderr, "Choice made was: '%s' (%d)\n", 
               list_return->string, list_return->list_index);
 
	kexit(KEXIT_SUCCESS);
}
