#include <xvinclude.h>

/*
 *  This example creates a browser object and installs on it a callback
 *  which will print the file that was selected by the user.
 */
static void browser_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject browser;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	browser = xvw_create_browser(NULL, "browser");
	xvw_add_callback(browser, XVW_BROWSER_CALLBACK, browser_cb, NULL);

	/* that's all! */
	xvf_run_form();
}

static void browser_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char *filename = *((char **) call_data);

	if (filename == NULL)
	   kinfo(KFORCE, "No filename selected");
	else kinfo(KFORCE, "The filename selected was '%s'", filename);
} 
