#include <xvinclude.h>

/*
 * This example creates a set of pixmap objects, laying them out in rows
 * by using a rowcol object as the parent.  The pixmap object,
 * as opposed to a label displaying a pixmap, is slightly faster and designed 
 * specifically for the display of pixmaps.  Note that the pixmaps displayed
 * are *really* of different sizes; it's not a bug that the hex and the
 * esher grid are smaller than the others. 
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	xvobject rowcol;
	xvobject pixmap;

 static char *filenames[] = {"backgrounds:hex_grid",
                             "backgrounds:brown_marble",
                             "backgrounds:black_marble",
                             "backgrounds:esher_grid",
                             "backgrounds:purple_marble",
                             "backgrounds:gravel_marble",
                             "backgrounds:purple_maze",
                             "backgrounds:wood_pulp",
                             "backgrounds:bw_marble"};

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  create a RowCol object to serve as the backplane,
         *  so that pixmaps can be laid out automatically, without
         *  using relative or absolute layout.  Want 3 pixmaps in a row.
	 */
	rowcol = xvw_create_rowcol(NULL, "rowcol pixmap");
	xvw_set_attributes(rowcol,
			   XVW_MINIMUM_WIDTH,  500,
                           XVW_MINIMUM_HEIGHT, 500,
                           NULL);

	for (i = 0; i < knumber(filenames); i++)
	{
	     /*
	      *  Create the pixmap objects and set the file defining
              *  each pixmap to be displayed.
	      */
	    pixmap = xvw_create_pixmap(rowcol, "pixmap");
	    xvw_set_attribute(pixmap, XVW_PIXMAP_FILENAME, filenames[i]);
	}

	/* display & run the program */
	xvf_run_form();
}
