#include <xvinclude.h>

/*
 *  This example creates a warn object to display a warninig message.
 *
 *  IMPORTANT NOTE: in general, the warn object should *not* be created
 *                  directly;  use of kwarn() is the conventional way to
 *                  create messages in Khoros, so that there is standard
 *                  formatting enforced.  this example is really only for
 *                  academic purposes.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject warn;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the warn object. Note that since the parent is NULL, a
	 *  toplevel window will be created and the warn object placed
	 *  inside.   Set the label, the warning message, the button label.
	 */
	warn = xvw_create_warn(NULL, "Warning Message");
	xvw_set_attributes(warn,
		XVW_WARN_LABEL,   "Beeeep!  Beeeep!  Beeep!",
		XVW_WARN_MESSAGE, "You better watch out...",
		NULL);

	/* display & run the program */
	xvf_run_form();
}
