#include <xvinclude.h>

/*
 *  This example creates a canvas object;  it then creates two label
 *  widgets on the canvas; one at the top, one at the bottom.
 *
 *  It also creates a button on the canvas that you may use to change
 *  the background pixmap of the canvas. (Mostly to show off all the
 *  cool background pixmaps available).
 */
static void change_background PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int gridsize = 20;
	xvobject canvas, label, button;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the canvas.  Note that since the parent is NULL, a
	 *  toplevel window will be created and the canvas placed inside.
         *  Set the canvas to be 512x512 (pixels) with a grid size of 20.
	 */
	canvas = xvw_create_canvas(NULL, "canvas");
	xvw_set_attributes(canvas,
		XVW_CANVAS_GRIDSIZE, gridsize,
		XVW_WIDTH,  512,
		XVW_HEIGHT, 512,
		NULL);

	/* put a label near the top of the canvas */
	label = xvw_create_label(canvas, "label1");
	xvw_set_attributes(label,
		           XVW_LABEL,    "This is a sample label",
		           XVW_CHAR_XPOS, 10.0,
		           XVW_CHAR_YPOS, 10.0,
		           NULL);
	
	/*
	 *  put a button to the right of the label;
         *  install callback so user can change background
	 */
	button = xvw_create_button(canvas, "button");
	xvw_set_attributes(button,
			   XVW_LABEL,    "Change background",
                           XVW_CHAR_XPOS, 40.0,
                           XVW_CHAR_YPOS, 10.0,
			   NULL);

	xvw_add_callback(button, XVW_BUTTON_SELECT, change_background, canvas);

	/* put another label way down the canvas as well.  */
	label = xvw_create_label(canvas, "label1");
	xvw_set_attributes(label,
		XVW_LABEL, "This is a sample label",
		XVW_CHAR_XPOS, 10.0,
		XVW_CHAR_YPOS, 40.0,
		XVW_CHAR_WIDTH, (float) kstrlen("This is a sample label"),
		NULL);

	/* and we're off! */
	xvf_run_form();
}

static void change_background(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	int      indx;
 static int      count = 0;
	xvobject canvas = (xvobject) client_data;

 static char *filenames[] = {"backgrounds:hex_grid",
			     "backgrounds:brown_marble",
			     "backgrounds:black_marble",
			     "backgrounds:esher_grid",
			     "backgrounds:purple_marble",
			     "backgrounds:gravel_marble",
			     "backgrounds:purple_maze",
			     "backgrounds:wood_pulp",
			     "backgrounds:bw_marble"};
	
	indx = count % knumber(filenames);
	xvw_set_attribute(canvas, XVW_BACKGROUND_PIXMAPFILE, filenames[indx]);

	count++;
}
