#include <xvinclude.h>

/*
 *  This program restores a workspace of glyphs.  You may provide
 *  a workspace to be restored, as in:
 *
 *  % example $SAMPLEDATA/examples/workspaces/simple_arith.wk
 *
 *  By default, the color arithmetic workspace is restored
 *  (workspaces:ColorArith1)
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject workspace;
	char  *filename = "workspaces:ColorArith1";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	if (argc > 1)
	   filename = argv[1];

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "unable to open display");
	   kexit(1);
	}

	/*
	 *  Create the workspace.  Note that since the parent is NULL, a
	 *  toplevel window will be created and the workspace display placed
	 *  inside.  The XVW_WORKSPACE_RESTORE attribute is used to specify 
         *  the workspace file to be restored.
	 */
	workspace = xvw_create_workspace(NULL, "workspace");
	xvw_set_attributes(workspace,
		XVW_WIDTH,             750,
		XVW_HEIGHT,            750,
		XVW_WORKSPACE_RESTORE, filename,
		NULL);

	/* display & run the program */
	xvf_run_form();
}
