#include <xvinclude.h>

/*
 *  This is a simple canvas program that creates three glyphs
 *  according to the GUI's defined in the "images.pane", "putimage.pane",
 *  and "kadd.pane" UIS files in this directory.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int gridsize = 10;
	xvobject canvas, glyph;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the image display.  Note since the parent is NULL a
	 *  toplevel window will be created and the image display placed
	 *  inside.  The xvw_set_attribute() call is used to specify the
	 *  image file to be displayed.
	 */
	canvas = xvw_create_canvas(NULL, "canvas");
	xvw_set_attributes(canvas,
		XVW_CANVAS_GRIDSIZE, gridsize,
		XVW_WIDTH,  512,
		XVW_HEIGHT, 512,
		NULL);

	glyph = xvw_create_glyph(canvas, "glyph0");
	xvw_set_attributes(glyph,
		XVW_XPOSITION, 100,
		XVW_YPOSITION, 100,
		XVW_GLYPH_FORMFILE, "images.pane",
		XVW_NODE_NAME, "images",
		NULL);
	glyph = xvw_create_glyph(canvas, "glyph1");
	xvw_set_attributes(glyph,
		XVW_XPOSITION, 200,
		XVW_YPOSITION, 100,
		XVW_GLYPH_FORMFILE, "putimage.pane",
		XVW_NODE_NAME, "putimage",
		NULL);
	glyph = xvw_create_glyph(canvas, "glyph2");
	xvw_set_attributes(glyph,
		XVW_XPOSITION, 200,
		XVW_YPOSITION, 200,
		XVW_GLYPH_FORMFILE, "kadd.pane",
		XVW_NODE_NAME, "kadd",
		NULL);

	/* display & run */
	xvf_run_form();
}
