#include <xvinclude.h>

/*
 *  Similar to 03.layout/, this example uses 4 buttons each on the
 *  top, right, bottom, and left, arranged in such a way that they must
 *  be laid out in a spiral, making it a real layout challenge for the
 *  manager object.
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	int      i;
	xvobject manager, left, right, bottom, top;
	xvobject previous_left, previous_right, previous_bottom, previous_top;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");
	
        /* initialize xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
	              XVW_WIDTH,  512,
	              XVW_HEIGHT, 512,
		      NULL);

	previous_left   =
	previous_right  =
	previous_top    =
	previous_bottom = NULL;
	for (i = 0; i < 6; i++)
	{
	   left   = xvw_create_button(manager, "left button");
	   right  = xvw_create_button(manager, "right button");
	   top    = xvw_create_button(manager, "top button");
	   bottom = xvw_create_button(manager, "bottom button");

	   xvw_set_attributes(left,
	   	      XVW_LABEL,     "left",
	   	      XVW_RIGHT_OF,   previous_left,
	   	      XVW_BELOW,      previous_top,
	   	      XVW_ABOVE,      bottom,
		      XVW_TACK_EDGE,  KMANAGER_TACK_VERT,
	   	      NULL);

	   xvw_set_attributes(bottom,
	   	      XVW_LABEL,     "bottom",
	   	      XVW_ABOVE,      previous_bottom,
	   	      XVW_RIGHT_OF,   previous_left,
	   	      XVW_LEFT_OF,    right,
	   	      XVW_TACK_EDGE,  KMANAGER_TACK_HORIZ,
	   	      NULL);

	   xvw_set_attributes(right,
	   	      XVW_LABEL,     "right",
	   	      XVW_LEFT_OF,    previous_right,
	   	      XVW_ABOVE,      previous_bottom,
	   	      XVW_BELOW,      top,
		      XVW_TACK_EDGE,  KMANAGER_TACK_VERT,
	   	      NULL);

	   xvw_set_attributes(top,
	   	      XVW_LABEL,     "top",
	   	      XVW_BELOW,      previous_top,
	   	      XVW_LEFT_OF,    previous_right,
	   	      XVW_RIGHT_OF,   left,
	   	      XVW_TACK_EDGE,  KMANAGER_TACK_HORIZ,
	   	      NULL);
	   previous_left   = left;
	   previous_right  = right;
	   previous_top    = top;
	   previous_bottom = bottom;
	}

	/*
	 * display & run program
	 */
	xvf_run_form();
}
