#include <xvinclude.h>

/*
 *  This program illustrates the using of the tacking attribute,
 *  XVW_TACK_EDGE, and the different effects that can be achieved
 *  by providing it with different values.  This example is similar
 *  to the 02.layout/ and 03.layout/ example, except that each button
 *  is constrained such that it cannot "take priority" over any other
 *  button, so they all get centered, and no button can overlap any  
 *  other button (producing empty spaces in the corners).
 *
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager;
	xvobject left, right, bottom, top;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");
	
        /* initialize xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
	              XVW_WIDTH,  512,  /* flag => mapped */
	              XVW_HEIGHT, 512,  /* flag => mapped */
		      NULL);

	left   = xvw_create_button(manager, "left button");
	right  = xvw_create_button(manager, "right button");
	top    = xvw_create_button(manager, "top button");
	bottom = xvw_create_button(manager, "bottom button");

	xvw_set_attributes(left,
		      XVW_LABEL,    "left",
		      XVW_RIGHT_OF,  NULL,
		      XVW_BELOW,     top,
		      XVW_ABOVE,     bottom,
	              XVW_TACK_EDGE, KMANAGER_TACK_VERT,
		      NULL);

	xvw_set_attributes(right,
		      XVW_LABEL,    "right",
		      XVW_LEFT_OF,   NULL,
		      XVW_BELOW,     top,
		      XVW_ABOVE,     bottom,
	              XVW_TACK_EDGE, KMANAGER_TACK_VERT,
		      NULL);

	xvw_set_attributes(top,
		      XVW_LABEL,    "top",
		      XVW_BELOW,     NULL,
		      XVW_RIGHT_OF,  left,
		      XVW_LEFT_OF,   right,
		      XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		      NULL);

	xvw_set_attributes(bottom,
		      XVW_LABEL,    "bottom",
		      XVW_ABOVE,     NULL,
		      XVW_RIGHT_OF,  left,
		      XVW_LEFT_OF,   right,
		      XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		      NULL);

	/*
	 * display & run program
	 */
	xvf_run_form();
}
