#include <xvinclude.h>

/*
 *  This program illustrates the using of the tacking attribute,
 *  XVW_TACK_EDGE, and the different effects that can be achieved
 *  by providing it with different values.  Here, two tall, vertical
 *  buttons are created on the right & left; they are tacked to the
 *  top & bottom so that they extend the full height of the window.
 *  Then, two long, horizontal buttons are created on the top &
 *  bottom; they are tacked to the left and right so that they extend
 *  the full width of the window.  Since the top & bottom buttons are
 *  created last, they will obscure the left & right buttons.
 *
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager;
	xvobject left, right, bottom, top;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager object backplane: this one is 512x512 pixels */
	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
	                   XVW_WIDTH,  512,
	                   XVW_HEIGHT, 512,
		           NULL);

	/* create buttons for left, right, top, and bottom */
	top    = xvw_create_button(manager, "top button");
	left   = xvw_create_button(manager, "left button");
	bottom = xvw_create_button(manager, "bottom button");
	right  = xvw_create_button(manager, "right button");

	/*
	 *  tack the "left" button to parent, so it "sticks" to the L side;
         *  tack it vertically, so it "grows" vertically to size of parent
	 */
	xvw_set_attributes(left,
		XVW_LABEL,    "left",
		XVW_RIGHT_OF,  NULL,  
		XVW_TACK_EDGE, KMANAGER_TACK_VERT,
		NULL);

	/*
	 *  tack the "right" button to parent, so it "sticks" to the R side;
         *  tack it vertically, so it "grows" vertically to size of parent
	 */
	xvw_set_attributes(right,
		XVW_LABEL,    "right",
		XVW_LEFT_OF,   NULL,  
		XVW_TACK_EDGE, KMANAGER_TACK_VERT,
		NULL);

	/*
	 *  tack the "top" button to parent, so it "sticks" to the top;
         *  tack it horizontally, so it "grows" horizontally to size of parent
	 */
	xvw_set_attributes(top,
		XVW_LABEL,    "top",
		XVW_BELOW,     NULL,
		XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		NULL);

	/*
	 *  tack the "bottom" button to parent, so it "sticks" to the bottom;
         *  tack it horizontally, so it "grows" horizontally to size of parent
	 */
	xvw_set_attributes(bottom,
		XVW_LABEL,    "bottom",
		XVW_ABOVE,     NULL,
	        XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		NULL);

	/* display & run program */
	xvf_run_form();
}
