#include "xvinclude.h"

/*
 * This example illustrates how a callback is installed on a button object.
 * It also reminds us of the fact that we need not use the client_data
 * pointer to pass any information that can be obtained through a
 * xvw_get_attributes() calls on the xvobject itself.
 *
 */

void button_callback PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject   manager;
	xvobject   button;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
           kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "back");

	/* a single button on the manager */
	button = xvw_create_button(manager, "button");
	xvw_set_attributes(button,
	      XVW_LABEL,            "Yellow", /* label says yellow  */
	      XVW_BACKGROUND_COLOR, "yellow", /* yellow color       */
	      NULL);

	/* add callback to button */
	xvw_add_callback(button, XVW_BUTTON_SELECT, 
		         button_callback, NULL);

	/* display and run */
	xvf_run_form();
}

/*
 * here's the callback for the button
 */
void button_callback(
    xvobject object,      /* the button */
    kaddr    client_data, /* not used   */
    kaddr    call_data)   /* not used   */
{
	float char_width;
	float char_height;
	char  *label;
	char  *bg_color;

	/*
	 *  obtain info from the button object
	 */
	xvw_get_attributes(object, 
		XVW_CHAR_WIDTH,       &char_width,
		XVW_CHAR_HEIGHT,      &char_height,
		XVW_BACKGROUND_COLOR, &bg_color,
		XVW_LABEL,            &label,
		NULL);

	/*
	 *  use kinfo() to pop up information about the button
	 */
	kinfo(KSTANDARD, "Button %s,\ncolor %s,\nwidth x height = %.1f x %.1f", 
	      label, bg_color, char_width, char_height);
}
