#include <dataserv.h>

/* 
 * standard 16bit checksum (the one used by tcp and ip protocols in fact)
 */
static void _checksum(char *name)
{
   kobject i;
   long j;
   unsigned long chk;
   unsigned long *data;
   int *size,begin[5],end[5];

   i = kdms_input(name);
   kdms_set_attribute(i,KDMS_SEGMENT_VALUE,KDMS_DATA_TYPE,KULONG);
   kdms_get_attribute(i,KDMS_SEGMENT_VALUE,KDMS_SIZE,&size);

   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = size[0] - 1;
   end[1] = size[1] - 1;
   end[2] = size[2] - 1;
   end[3] = size[3] - 1;
   end[4] = size[4] - 1;
   data = kdms_get_data(i,KDMS_SEGMENT_VALUE,begin,end,NULL);

   /* standard 16bit checksum, keep track of min, max, mean */
   for(j=0,chk=0;j<size[0]*size[1]*size[2]*size[3]*size[4];j++) {
      chk += data[j];
      chk += (chk >= 0x00010000) ? (-0x00010000) : 1;
   }
   kprintf("\nChecksum = 0x%lx\n\n",(~chk) & 0xffff);

   kfree(data);
   
}

dooley(char *format)
{
   kobject o;
   unsigned char *data = NULL;
   int r,c,i,size[5];
   int order[5] = {KWIDTH, KHEIGHT, KDEPTH, KTIME, KELEMENTS};
   int begin[5], end[5];

   o = kdms_output("test.xv");
   kdms_set_attribute(o,NULL,KDMS_FORMAT,format);
   size[0] = c = 100;
   size[1] = r = 100;
   size[2] = size[3] = size[4] = 1;

   kdms_create_segment(o,KDMS_SEGMENT_VALUE);
   kdms_set_attributes(o,KDMS_SEGMENT_VALUE,
	KDMS_DIMENSION, 5,
	KDMS_SIZE,size,
	KDMS_INDEX_ORDER,order,
	KDMS_DATA_TYPE, KUBYTE,
	NULL);

   data = (unsigned char *)malloc(sizeof(unsigned char) * c); 
  
   for(i=0;i<c;i++) 
      data[i] = (unsigned char)(128.0*sin((double)i*15.0/c) + 128);

   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = size[0] -1; end[1] = end[2] = end[3] = end[4] = 0;
   for(i=0;i<r;i++) {
       kdms_put_data(o,KDMS_SEGMENT_VALUE,begin,end,data);
       begin[1] ++; end[1] ++;
   }

   kdms_close(o);
   kfree(data);

   _checksum("test.xv");

   return 0;
}

main(int argc, char **argv)
{
  char **formats = NULL;
  int num, c;
  
  if (argc == 1) 
  {
     formats = kdms_support(&num);
     for (c = 0; c < num; c++)
	kprintf("%s\n",formats[c]);
     kfree(formats);
  } 
  else
     dooley(argv[1]);

  kexit(0);
  return 0;
}

