#include <dataserv.h>

/* 
 * standard 16bit checksum (the one used by tcp and ip protocols in fact)
 */
static void _checksum(char *name)
{
   kobject i;
   long j;
   unsigned long chk;
   unsigned long *data;
   int *size,begin[5],end[5];

   i = kdms_input(name);
   kdms_set_attribute(i,KDMS_SEGMENT_VALUE,KDMS_DATA_TYPE,KULONG);
   kdms_get_attribute(i,KDMS_SEGMENT_VALUE,KDMS_SIZE,&size);

   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = size[0] - 1;
   end[1] = size[1] - 1;
   end[2] = size[2] - 1;
   end[3] = size[3] - 1;
   end[4] = size[4] - 1;
   data = kdms_get_data(i,KDMS_SEGMENT_VALUE,begin,end,NULL);

   /* standard 16bit checksum, keep track of min, max, mean */
   for(j=0,chk=0;j<size[0]*size[1]*size[2]*size[3]*size[4];j++) {
      chk += data[j];
      chk += (chk >= 0x00010000) ? (-0x00010000) : 1;
   }
   kprintf("\nChecksum = 0x%lx\n\n",(~chk) & 0xffff);
   kdms_close(i);
   kfree(data);
}

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject image, out;
	int     available;
	int *size;
	char    *filename = "input.xv";


	if ((image = kdms_input(filename)) == NULL)
	   kexit(1);
	
	if ((out = kdms_output("test.xv")) == NULL)
	   kexit(1);	

	kdms_copy_object(image, out, TRUE, FALSE);

	kdms_get_attribute(image, KDMS_SEGMENT_VALUE, KDMS_SIZE, &size);

	size[0] *= 2;
	size[1] *= 2;
	kdms_set_attributes(out, KDMS_SEGMENT_VALUE,
		KDMS_SIZE, size,
		KDMS_INTERPOLATE, KZERO_ORDER,
		KDMS_PAD_VALUE, 128.0, 128.0,
		NULL);

	kdms_copy_object(image,out,TRUE,TRUE);

	kdms_close(image);
	kdms_close(out);

	_checksum("test.xv");
	kexit(0);
}
