#include <dataserv.h>

/*  //  This test program checks fickle's ability to expand out the size 
 *  //  of the value data segment.  It starts the value segment out with 
 *  //  the size of a single value, and then expands it in each of the
 *  //  five dimensions.  The resulting output is then saved and read 
 *  //  to be compared with a comparison array.
 */

main()
{
   kobject i, o;
   float *data = NULL;
   float compare[32];   /* Data for comparison purposes */
   int k, status, *sz;
   int size[5] = { 1, 1, 1, 1, 1};
   int order[5] = {KWIDTH, KHEIGHT, KDEPTH, KTIME, KELEMENTS};
   int begin[5], end[5];

   o = kdms_output("test.viff");

   /*
    * this is necessary because this thing works in 5-space
    */
   kdms_set_attribute(o,NULL,KDMS_FORMAT,KVIFF);

   kdms_create_segment(o,KDMS_SEGMENT_VALUE);
   kdms_set_attributes(o, KDMS_SEGMENT_VALUE,
	KDMS_DIMENSION, 5,
	KDMS_INDEX_ORDER, order,
	KDMS_SIZE, size,
	KDMS_DATA_TYPE, KFLOAT,
	NULL);

   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = end[1] = end[2] = end[3] = end[4] = 0;

   data = (float *) kcalloc(1, sizeof(float)); 
   data[0] = 42;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }

   /* Hunky-Dory up til now!  let's get dangerous... */

   /* ################## size of output will be doubled */

   /* Up the size of the value segment in the w direction and put data */ 
   size[0] = 2;
   if (!kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size))
   {
      kfprintf(kstderr,"Unable to increase size in the w dimension \n");
      kexit(1);
   }

   /* Put the new data into the expanded w dimension */
   end[0] = begin[0] = 1;
   /* Twice one will be two, so need to add one */
   data[0] = 43;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }


   /* ################## size of output will be doubled */

   /* Up the size of the value segment in the h direction and put data */ 
   size[1] = 2;
   if (!kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size))
   {
      kfprintf(kstderr,"Unable to increase size in the h dimension \n");
      kexit(1);
   }

   begin[0] = 0; end[0] = 1;
   begin[1] = end[1] = 1;
   /* Put the new data into the expanded h dimension */
   /* Twice two will be four, so need to add two */
   data = (float *) krealloc(data, 2 * sizeof(float));
   for(k=0;k<2;k++) data[k] = 44;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }

   /* ################## size of output will be doubled */

   size[2] = 2;
   /* Up the size of the value segment in the d direction and put data */ 
   if (!kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size))
   {
      kfprintf(kstderr,"Unable to increase size in the h dimension \n");
      kexit(1);
   }

   begin[0] = begin[1] = 0;
   end[0] = end[1] = 1;
   begin[2] = end[2] = 1;
   /* Put the new data into the expanded d dimension */
   /* Twice four will be eight, so need to add four */
   data = (float *) krealloc(data, 4 * sizeof(float));
   for(k=0;k<4;k++) data[k] = 45.0;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }

   /* ################## size of output will be doubled */

   size[3] = 2;
   /* Up the size of the value segment in the t direction and put data */ 
   if (!kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size))
   {
      kfprintf(kstderr,"Unable to increase size in the t dimension \n");
      kexit(1);
   }

   begin[0] = begin[1] = begin[2] = 0;
   end[0] = end[1] = end[2] = 1;
   begin[3] = end[3] = 1;
   /* Twice eight will be sixteen, so need to add eight */
   data = (float *) krealloc(data, 8 * sizeof(float));
   for(k=0;k<8;k++) data[k] = 46.0;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }

   /* ################## size of output will be doubled */
   size[4] = 2;
   /* Up the size of the value segment in the e direction and put data */ 
   if (!kdms_set_attribute(o, KDMS_SEGMENT_VALUE, KDMS_SIZE, size))
   {
      kfprintf(kstderr,"Unable to increase size in the e dimension \n");
      kexit(1);
   }

   begin[0] = begin[1] = begin[2] = begin[3] = 0;
   end[0] = end[1] = end[2] = end[3] = 1;
   begin[4] = end[4] = 1;
   /* Twice sixteen will be thirty-two, so need to add sixteen */
   data = (float *) krealloc(data, 16 * sizeof(float));
   for(k=0;k<16;k++) data[k] = 47.0;

   if (!kdms_put_data(o, KDMS_SEGMENT_VALUE, begin, end, data ))
   {
      kfprintf(kstderr,"Unable to put intial data into value segment\n");
      kexit(1);
   }

   /* ################## */

   /* Close the puppy down so we can reopen it later */ 
   kdms_close(o);
   kfree(data);
   data = NULL;
   /* ################## */

   /* Get all the data and compare with what it should be */
   i = kdms_input("test.viff");

   status = FALSE;
   kdms_get_attribute(i, KDMS_SEGMENT_VALUE, KDMS_SIZE, &sz);

   kprintf("size = %d %d %d %d %d\n",sz[0],sz[1],sz[2],sz[3],sz[4]);


   begin[0] = begin[1] = begin[2] = begin[3] = begin[4] = 0;
   end[0] = end[1] = end[2] = end[3] = end[4] = 1;
   if (!(data = kdms_get_data(i,KDMS_SEGMENT_VALUE,begin,end,NULL)))
   {
      kfprintf(kstderr,"Unable to retrieve data from written VIFF!\n");
      kexit(1);
   }

   for(k=0;k<sz[0]*sz[1]*sz[2]*sz[3]*sz[4];k++)
      kprintf("%f\n",data[k]);
  
   kexit(0);
}
