#include <dataserv.h>

void test_callback(kobject o, char *segment, kaddr cd, kdms_callback *dta)
{
   kprintf("Got a callback: %s: \n",segment);
   kprintf("\t%s\n\tbegin = %d %d %d %d %d\n\tend = %d %d %d %d %d\n",
	 dta->segment,dta->begin.w,dta->begin.h,dta->begin.d,
	 dta->begin.t,dta->begin.e,dta->end.w,dta->end.h,dta->end.d,
	 dta->end.t,dta->end.e);
}

main()
{
   kobject i,o,t;
   int j,ii,jj,n,p;
   unsigned char *data = NULL;
   int *size, begin[5], end[5];

   i = kdms_input("$DATASERV/data/testdata/100x100.ubyte.xvimage");
   o = kdms_output("test.xv");

   kdms_copy_object(i,o,TRUE,FALSE);
	
   t = kdms_reference(o);
/*
 *   printf ("number of divisions: ");
 *  scanf("%d",&n);
 */
   n = 16;

   kdms_add_callback(t,KDMS_SEGMENT_VALUE,KDMS_CALLBACK_CHANGE,test_callback,
	NULL);

   kdms_get_attribute(i,KDMS_SEGMENT_VALUE,KDMS_SIZE,&size);

   for(ii=0;ii<n;ii++){
      for(jj=0;jj<n;jj++){
          begin[0] = (size[0]-size[0]/n) - ii*(size[0]/n);
	  begin[1] = (size[1]-size[1]/n)-jj*(size[1]/n);
	  end[0] = begin[0] + size[0]/n - 1;
	  end[1] = begin[1] + size[1]/n - 1;
	  begin[2] = begin[3] = begin[4] = end[2] = end[3] = end[4] = 0;
          data = kdms_get_data(i,KDMS_SEGMENT_VALUE,begin,end,data);

	  begin[0] = ii*(size[0]/n);
	  begin[1] = jj*(size[1]/n);
	  end[0] = begin[0] + size[0]/n - 1;
	  end[1] = begin[1] + size[1]/n - 1;
	  begin[2] = begin[3] = begin[4] = end[2] = end[3] = end[4] = 0;
          kprintf("Putting...");
          kdms_put_data(o,KDMS_SEGMENT_VALUE,begin,end,data);
      }
   }

   kdms_close(o);
   kdms_close(i);
   kdms_close(t);
   kfree(data);
   kexit(0);
}
