 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Initialization of Data Services
   >>>>
   >>>>   Static:
   >>>>                 _kdms_get_buffer_size()
   >>>>                 _kdms_exit_data_services()
   >>>>                 _kdms_legal_type()
   >>>>
   >>>>                 _get_size()
   >>>>                 _set_size()
   >>>>                 _match_size()
   >>>>                 _copy_size()
   >>>>                 _query_size()
   >>>>                 _print_size()
   >>>>
   >>>>                 _get_index_order()
   >>>>                 _set_index_order()
   >>>>                 _match_index_order()
   >>>>                 _copy_index_order()
   >>>>                 _query_index_order()
   >>>>                 _print_index_order()
   >>>>
   >>>>                 _get_data_type()
   >>>>                 _set_data_type()
   >>>>                 _match_data_type()
   >>>>                 _copy_data_type()
   >>>>                 _query_data_type()
   >>>>                 _print_data_type()
   >>>>
   >>>>                 _get_permanence()
   >>>>                 _set_permanence()
   >>>>                 _match_permanence()
   >>>>                 _copy_permanence()
   >>>>                 _query_permanence()
   >>>>                 _print_permanence()
   >>>>
   >>>>                 _get_complex_convert()
   >>>>                 _set_complex_convert()
   >>>>                 _match_complex_convert()
   >>>>                 _copy_complex_convert()
   >>>>                 _query_complex_convert()
   >>>>                 _print_complex_convert()
   >>>>
   >>>>                 _get_format()
   >>>>                 _set_format()
   >>>>                 _match_format()
   >>>>                 _copy_format()
   >>>>                 _query_format()
   >>>>                 _print_format()
   >>>>
   >>>>                 _get_name()
   >>>>                 _set_name()
   >>>>                 _match_name()
   >>>>                 _copy_name()
   >>>>                 _query_name()
   >>>>                 _print_name()
   >>>>
   >>>>                 _get_dimension()
   >>>>                 _set_dimension()
   >>>>                 _match_dimension()
   >>>>                 _copy_dimension()
   >>>>                 _query_dimension()
   >>>>                 _print_dimension()
   >>>>
   >>>>                 _get_architecture()
   >>>>                 _set_architecture()
   >>>>                 _match_architecture()
   >>>>                 _copy_architecture()
   >>>>                 _query_architecture()
   >>>>                 _print_architecture()
   >>>>
   >>>>                 _get_coupling()
   >>>>                 _set_coupling()
   >>>>                 _match_coupling()
   >>>>                 _copy_coupling()
   >>>>                 _query_coupling()
   >>>>                 _print_coupling()
   >>>>
   >>>>                 _get_interpolate()
   >>>>                 _set_interpolate()
   >>>>                 _match_interpolate()
   >>>>                 _copy_interpolate()
   >>>>                 _query_interpolate()
   >>>>                 _print_interpolate()
   >>>>
   >>>>                 _get_norm_min()
   >>>>                 _set_norm_min()
   >>>>                 _match_norm_min()
   >>>>                 _copy_norm_min()
   >>>>                 _query_norm_min()
   >>>>                 _print_norm_min()
   >>>>
   >>>>                 _get_norm_max()
   >>>>                 _set_norm_max()
   >>>>                 _match_norm_max()
   >>>>                 _copy_norm_max()
   >>>>                 _query_norm_max()
   >>>>                 _print_norm_max()
   >>>>
   >>>>                 _get_scale_factor()
   >>>>                 _set_scale_factor()
   >>>>                 _match_scale_factor()
   >>>>                 _copy_scale_factor()
   >>>>                 _query_scale_factor()
   >>>>                 _print_scale_factor()
   >>>>
   >>>>                 _get_scale_offset()
   >>>>                 _set_scale_offset()
   >>>>                 _match_scale_offset()
   >>>>                 _copy_scale_offset()
   >>>>                 _query_scale_offset()
   >>>>                 _print_scale_offset()
   >>>>
   >>>>                 _get_scaling()
   >>>>                 _set_scaling()
   >>>>                 _match_scaling()
   >>>>                 _copy_scaling()
   >>>>                 _query_scaling()
   >>>>                 _print_scaling()
   >>>>
   >>>>                 _get_pad_value()
   >>>>                 _set_pad_value()
   >>>>                 _match_pad_value()
   >>>>                 _copy_pad_value()
   >>>>                 _query_pad_value()
   >>>>                 _print_pad_value()
   >>>>                 
   >>>>                 _get_optimimum_region_size()
   >>>>                 _match_optimum_region_size()
   >>>>                 _query_optimum_region_size()
   >>>>                 _print_optimum_region_size()
   >>>>
   >>>>                 _kdms_init_attributes()
   >>>>
   >>>>  Private:
   >>>>                 _kdms_init()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

/*
 * Centerline's CLCC doesn't honor the ARGSUSED *standard* so
 * this pragma turns off warnings about unused arguments, which
 * are numerous in this file.
 */
#ifdef __CLCC__
#pragma Warning_level (3)
#endif

#include "internals.h"
extern int _kdms_compiled;
extern klist *kdms_object_list;

/*
 * from data.c
 */
int _kdms_buffer_threshold;

/* Use this threshold, if KHOROS_KDMS_BUFSIZE environment variable isn't set */
#define THRESHOLD 2097152

/*-----------------------------------------------------------
|
|  Routine Name: (static) _compute_buffer_size
|       Purpose:
|         Input:
|        Output:
|       Returns:
|    Written By: Jeremy Worley
|          Date: Apr 21, 1994 08:44
| Modifications:
|
------------------------------------------------------------*/

static int
_compute_buffer_size(void)
{
   return THRESHOLD;
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_get_buffer_size - get the buffer size
|
|       Purpose: This routine gets the environment variable
|                KHOROS_KDMS_BUFSIZE and sets the internal
|                buffersize threshold to that.
|
|         Input: none
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Jun 23, 1993 12:09
| Modifications:
|
------------------------------------------------------------*/

static void
_kdms_get_buffer_size(void)
{
   char *size;

   size = kgetenv("KHOROS_KDMS_BUFSIZE");
   if (size != NULL)
      _kdms_buffer_threshold = atol(size);
   else
      _kdms_buffer_threshold = _compute_buffer_size();

   return;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _kdms_exit_data_services
|
|       Purpose: This routine is used to cleanup data services upon
|                exiting of the application.  Currently the only
|                thing it does is to make sure that all the data
|                services are closed.
|
|         Input: status      - the exit status
|                client_data - the data we installed with the 
|                              kexit_handler handler
|
|        Output: nothing
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young and Jeremy Worley
|          Date: May 17, 1993 16:14
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static void
_kdms_exit_data_services(int status, kaddr client_data)
{
   kobject object;
   klist *list = kdms_object_list;

   /*
    * race thru the list closing any left open objects
    */
   while (list != NULL)
   {
      object = (kobject) klist_identifier(list);
      list = klist_next(list);
      _kdms_close(object, status);
   }

   /*
    * zip through all of the attribute definitions and free them up.
    */
   (void)kdms_free_attribute_defins();

   /*
    * ditto for the segment definitions and free them up.
    */
   (void)kdms_free_segment_defins();

   /*
    * free up the data used by the data pipelines.
    */
   _kdms_free_pipeline_memory();
   
   return;
}

/*
 *    ================================================================== 
 *    KDMS Quasi Attribute Methods
 *    ==================================================================
 */

/*********** ---------------------------------------------------------------
 ***********  KDMS_SIZE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_size
|       Purpose: get the size attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_size(kobject obj, int assoc, int attr, kaddr clientData, kva_list *list)
{
   kpresentation *pres;
   int **args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   args = kva_arg(*list, int **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->size;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_size
|       Purpose: set the size attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_size(kobject obj, int assoc, int attr, kaddr clientData, kva_list *list)
{
   kpresentation *pres;
   int *args,
      i;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   /* 
    *  set the size dimensions for all args which are not == -1 if the
    *  arg is -1 that implies that the old size should be retained. 
    */
   for (i = 0; i < pres->dimension; i++)
      pres->size[i] = (args[i] == -1) ? pres->size[i] : args[i];

   for (i = pres->dimension; i < KDMS_MAX_DIM; i++)
      pres->size[i] = 1;

   /*
    * if the size at the physical layer has not yet been initialized
    * and the coupling is either demand or coupled, then go ahead
    * and set the physical size as well.  Otherwise, mark the
    * segment for update if its coupled.
    */
   if (!_kdms_legal_size(pres->segment->size, pres->dimension) &&
       pres->coupling != KUNCOUPLED)
      kmemcpy(pres->segment->size, pres->size, pres->dimension * sizeof(int));
   else if (pres->coupling == KCOUPLED)
      pres->segment->update = TRUE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_size
|       Purpose: match the size attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_size(kobject obj1, kobject obj2, int assoc, int attrib,
            kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;
   int i;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   if (pres1->dimension <= 0 || pres2->dimension <= 0 ||
       pres1->dimension != pres2->dimension)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   for (i = 0; i < pres1->dimension; i++)
      if (pres1->size[i] != pres2->size[i])
         return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_size
|       Purpose: copy the size attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_size(kobject obj1, kobject obj2, int assoc, int attrib,
           kaddr clientData1, kaddr clientData2)
{
   char *segment = ktoken_to_string(assoc);
   int  *size;
   
   if (!kdms_get_attribute(obj1, segment, KDMS_SIZE, &size))
      return FALSE;

   if (!kdms_set_attribute(obj2, segment, KDMS_SIZE, size))
      return FALSE;
   
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_size
|       Purpose: query the size attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_size(kobject obj, int assoc, int attrib, kaddr clientData,
            int *num_args, int *arg_size, int *data_type, int *permanent)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   /* these are all constant, just fill them out */
   if (num_args)
      *num_args = 1;
   if (data_type)
      *data_type = KINT;
   if (permanent)
      *permanent = TRUE;

   if (arg_size)
      *arg_size = pres->dimension;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_size
|       Purpose: print the size attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_size(kobject obj, int assoc, int attrib, kaddr clientData,
            kfile *outfile)
{
   kpresentation *pres;
   int i;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   for (i = 0; i < pres->dimension; i++)
      kfprintf(outfile, " %d ", pres->size[i]);

   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_INDEX_ORDER
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_index_order
|       Purpose: get the index order attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_index_order(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;
   int **args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_ORDERDIM);
      return FALSE;
   }

   args = kva_arg(*list, int **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->order;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_index_order
|       Purpose: set the index order attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_index_order(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;
   int *args;
   int  i;
   int  tmp[5];

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_ORDERDIM);
      return FALSE;
   }

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   /* now we gotta update the ordering of the size attribute */
   if (pres->order[0] != -1)
   {
      for (i = 0; i < pres->dimension; i++)
      {
         tmp[i] = _kdms_get_order(args[i], pres->order, pres->size,
                                  pres->dimension, 0);
      }

      /* copy the new size in */
      kmemcpy(pres->size, &(tmp[0]), pres->dimension * sizeof(int));
   }

   /* copy the index order in */
   kmemcpy(pres->order, args, pres->dimension * sizeof(int));


   /*
    * Set the physical layer if it hasn't been set yet, otherwise,
    * if we're coupled, then mark the segment for update prior to
    * next data altering function.
    */
   if (!_kdms_legal_order(pres->segment->order, pres->dimension))
      kmemcpy(pres->segment->order, pres->order, pres->dimension*sizeof(int));
   else if (pres->coupling == KCOUPLED)
      pres->segment->update = TRUE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_index_order
|       Purpose: match the index order attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_index_order(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;
   int i;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   if (pres1->dimension <= 0 || pres2->dimension <= 0 ||
       pres1->dimension != pres2->dimension)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   for (i = 0; i < pres1->dimension; i++)
      if (pres1->order[i] != pres2->order[i])
         return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_index_order
|       Purpose: copy the index order attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_index_order(kobject obj1, kobject obj2, int assoc, int attrib,
                  kaddr clientData1, kaddr clientData2)
{
   char *segment = ktoken_to_string(assoc);
   int  *order;
   
   if (!kdms_get_attribute(obj1, segment, KDMS_INDEX_ORDER, &order))
      return FALSE;

   if (!kdms_set_attribute(obj2, segment, KDMS_INDEX_ORDER, order))
      return FALSE;
   
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_index_order
|       Purpose: query the index_order attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_index_order(kobject obj, int assoc, int attrib, kaddr clientData,
                   int *num_args, int *arg_size, int *data_type,
                   int *permanent)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   /* these are all constant, just fill them out */
   if (num_args)
      *num_args = 1;
   if (data_type)
      *data_type = KINT;
   if (permanent)
      *permanent = TRUE;

   if (arg_size)
      *arg_size = pres->dimension;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_index_order
|       Purpose: print the index order attribute
|    Written By: Jeremy Worley
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_index_order(kobject obj, int assoc, int attrib, kaddr clientData,
                   kfile *outfile)
{
   kpresentation *pres;
   int i;
   
   /* get the presentations */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (assoc == kstring_to_token(KDMS_SEGMENT_VALUE) || 
       assoc == kstring_to_token(KDMS_SEGMENT_MASK))
   {
      for (i = 0; i < pres->dimension; i++)
	 switch(pres->order[i])
	 {
	    case KWIDTH: 
	       kfprintf(outfile,"KWIDTH ");
	       break;
	    case KHEIGHT: 
	       kfprintf(outfile,"KHEIGHT ");
	       break;
	    case KDEPTH: 
	       kfprintf(outfile,"KDEPTH ");
	       break;
	    case KTIME: 
	       kfprintf(outfile,"KTIME ");
	       break;
	    case KELEMENTS: 
	       kfprintf(outfile,"KELEMENTS ");
	       break;
	    default:
	       kfprintf(outfile,"Unknown axis (%d) ",pres->order[i]);
	 }
   }
   else if (assoc == kstring_to_token(KDMS_SEGMENT_MAP))
   {
      for (i = 0; i < pres->dimension; i++)
	 switch(pres->order[i])
	 {
	    case KWIDTH: 
	       kfprintf(outfile,"KMAP_WIDTH ");
	       break;
	    case KHEIGHT: 
	       kfprintf(outfile,"KMAP_HEIGHT ");
	       break;
	    case KDEPTH: 
	       kfprintf(outfile,"KMAP_DEPTH ");
	       break;
	    case KTIME: 
	       kfprintf(outfile,"KMAP_TIME ");
	       break;
	    case KELEMENTS: 
	       kfprintf(outfile,"KMAP_ELEMENTS ");
	       break;
	    default:
	       kfprintf(outfile,"Unknown axis (%d) ",pres->order[i]);
	 }
   }
   else if (assoc == kstring_to_token(KDMS_SEGMENT_LOCATION))
   {
      for (i = 0; i < pres->dimension; i++)
	 switch(pres->order[i])
	 {
	    case KWIDTH: 
	       kfprintf(outfile,"KWIDTH ");
	       break;
	    case KHEIGHT: 
	       kfprintf(outfile,"KHEIGHT ");
	       break;
	    case KDEPTH: 
	       kfprintf(outfile,"KDEPTH ");
	       break;
	    case KDIMENSION: 
	       kfprintf(outfile,"KDIMENSION ");
	       break;
	    default:
	       kfprintf(outfile,"Unknown axis (%d) ",pres->order[i]);
	 }
   }
   else if (assoc == kstring_to_token(KDMS_SEGMENT_TIME))
   {
      kfprintf(outfile, "KTIME");
   }
   else 
   {
      for (i = 0; i < pres->dimension; i++)
	 kfprintf(outfile,"%d ",pres->order[i]);
   }
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_DATA_TYPE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_data_type
|       Purpose: get the data type attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_data_type(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->datatype;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_data_type
|       Purpose: set the data type attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_data_type(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;
   int tmp;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   tmp = kva_arg(*list, int);
   if (!_kdms_legal_datatype(tmp))
   {
      kinfo(KSTANDARD,
          "The datatype %d is illegal...data type attribute not set.", tmp);
      return FALSE;
   }

   pres->datatype = tmp;

   if (!_kdms_legal_datatype(pres->segment->datatype))
      pres->segment->datatype = pres->datatype;
   else if (pres->coupling == KCOUPLED)
      pres->segment->update = TRUE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_data_type
|       Purpose: match the data type attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_data_type(kobject obj1, kobject obj2, int assoc, int attrib,
                 kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->datatype == pres2->datatype);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_data_type
|       Purpose: copy the data type attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_data_type(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   char *segment = ktoken_to_string(assoc);
   int   type;
   
   if (!kdms_get_attribute(obj1, segment, KDMS_DATA_TYPE, &type))
      return FALSE;

   if (!kdms_set_attribute(obj2, segment, KDMS_DATA_TYPE, type))
      return FALSE;
   
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_data_type
|       Purpose: query the data type attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_data_type(kobject obj, int assoc, int attrib, kaddr clientData,
                 int *num_args, int *arg_size, int *data_type,
                 int *permanent)
{
   /* these are all constant, just fill them out */
   if (num_args)
      *num_args = 1;
   if (data_type)
      *data_type = KINT;
   if (permanent)
      *permanent = TRUE;
   if (arg_size)
      *arg_size = 1;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_data_type
|       Purpose: print the data type attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_data_type(kobject obj, int assoc, int attrib, kaddr clientData,
                 kfile *outfile)
{
   kpresentation *pres;
   
   /* get the presentations */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "%s", kdefine_to_datatype(pres->datatype));
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_PERMANENCE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_permanence
|       Purpose: get the permanence attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_permanence(kobject obj, int assoc, int attr, kaddr clientData,
                kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->permanence;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_permanence
|       Purpose: set the permanence attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_permanence(kobject obj, int assoc, int attr, kaddr clientData,
                kva_list *list)
{
   kpresentation *pres;
   int tmp;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   tmp = kva_arg(*list, int);

   pres->segment->permanence = tmp;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_permanence
|       Purpose: match the permanence attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_permanence(kobject obj1, kobject obj2, int assoc, int attrib,
                  kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1,
     *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->segment->permanence == pres2->segment->permanence);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_permanence
|       Purpose: copy the permanence attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_permanence(kobject obj1, kobject obj2, int assoc, int attrib,
                 kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_permanence
|       Purpose: query the permanence attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_permanence(kobject obj, int assoc, int attrib, kaddr clientData,
                  int *num_args, int *arg_size, int *data_type,
                  int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_permanence
|       Purpose: print the permanence attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_permanence(kobject obj, int assoc, int attrib, kaddr clientData,
                  kfile *outfile)
{
   kpresentation *pres;
   
   /* get the presentations */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile,pres->segment->permanence ? "permanent" : "transient");
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_COMPLEX_CONVERT
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_complex_convert
|       Purpose: get the complex convert attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_complex_convert(kobject obj, int assoc, int attr, kaddr clientData,
                     kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->complex_convert;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_complex_convert
|       Purpose: set the complex convert attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_complex_convert(kobject obj, int assoc, int attr, kaddr clientData,
                     kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->complex_convert = kva_arg(*list, int);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_complex_convert
|       Purpose: match the complex convert attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_complex_convert(kobject obj1, kobject obj2, int assoc, int attrib,
                       kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->complex_convert == pres2->complex_convert);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_complex_convert
|       Purpose: copy the complex convert attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_complex_convert(kobject obj1, kobject obj2, int assoc, int attrib,
                      kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_complex_convert
|       Purpose: query the complex convert attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_complex_convert(kobject obj, int assoc, int attrib, kaddr clientData,
                       int *num_args, int *arg_size, int *data_type,
                       int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_complex_convert
|       Purpose: print the complex convert attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_complex_convert(kobject obj, int assoc, int attrib, kaddr clientData,
                       kfile *outfile)
{
   kpresentation *pres;
   
   /* get the presentations */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   switch (pres->complex_convert)
   {
      case KREAL:
	 kfprintf(outfile,"KREAL");
	 break;
      case KIMAGINARY:
	 kfprintf(outfile,"KIMAGINARY");
	 break;
      case KMAGNITUDE:
	 kfprintf(outfile,"KMAGNITUDE");
	 break;
      case KPHASE:
	 kfprintf(outfile,"KPHASE");
	 break;
      case KMAGSQ:
	 kfprintf(outfile,"KMAGSQ");
	 break;
      case KLOGMAGSQ:
	 kfprintf(outfile,"KLOGMAGSQ");
	 break;
      case KLOGMAGSQP1:
	 kfprintf(outfile,"KLOGMAGSQP1");
	 break;
      case KLOGMAG:
	 kfprintf(outfile,"KLOGMAG");
	 break;
      case KLOGMAGP1:
	 kfprintf(outfile,"KLOGMAGP1");
	 break;
      default:
	 kfprintf(outfile,"Bogus conversion (%d)",pres->complex_convert);
	 break;
   }
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_FORMAT
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_format
|       Purpose: get the format attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_format(kobject obj, int assoc, int attr, kaddr clientData,
            kva_list *list)
{
   char **args;

   args = kva_arg(*list, char **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = _kdms_glue_identifier(obj);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_format
|       Purpose: set the format attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_format(kobject obj, int assoc, int attr, kaddr clientData,
            kva_list *list)
{
   char *ptr;
   DataServiceInformation *routines;

   /* grab the file format name */
   ptr = kva_arg(*list, char *);

   /*
    * if the file format has already been initialized and the file format is
    * not the same as what is currently set, then generate an error message.
    */
   if (obj->phys->routines != NULL && _kdms_initialized(obj) &&
       kstrcmp(_kdms_glue_identifier(obj), ptr) != 0)
   {
      _kdms_set_error(KDMS_EFMT_INIT);
      return FALSE;
   }

   /*
    * According to the specified file format get the appropriate data service
    * routines.
    */
   routines = _kdms_glue_routines(ptr);

   if (routines == NULL)
   {
      _kdms_set_error(KDMS_EOBJ_SUPPORT);
      return FALSE;
   }
   obj->phys->routines = routines;
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_format
|       Purpose: match the format attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_format(kobject obj1, kobject obj2, int assoc, int attrib,
              kaddr clientData1, kaddr clientData2)
{
   if (kstrcmp(_kdms_glue_identifier(obj1), _kdms_glue_identifier(obj2)) != 0)
      return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_format
|       Purpose: copy the format attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_format(kobject obj1, kobject obj2, int assoc, int attrib,
             kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_format
|       Purpose: query the format attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_format(kobject obj, int assoc, int attrib, kaddr clientData,
              int *num_args, int *arg_size, int *data_type,
              int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_format
|       Purpose: print the format attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_format(kobject obj, int assoc, int attrib, kaddr clientData,
              kfile *outfile)
{
   kfprintf(obj, "%s", obj->phys->routines->label);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_NAME
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_name
|       Purpose: get the name attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_name(kobject obj, int assoc, int attr, kaddr clientData,
          kva_list *list)
{
   char **args;
   static int count = 0;
   char name[KLENGTH];

   args = kva_arg(*list, char **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   /* -- generate a unique pretty name for temporary transports -- */
   if (obj->phys->filename == NULL)
   {
      ksprintf(name, "%d", count++);
      *args = kstring_cat("temporary", name, NULL);
   }
   else
      *args = obj->phys->filename;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_name
|       Purpose: set the name attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_name(kobject obj, int assoc, int attr, kaddr clientData,
          kva_list *list)
{
   _kdms_set_error(KDMS_ELIMITATION);

   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_name
|       Purpose: match the name attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_name(kobject obj1, kobject obj2, int assoc, int attrib,
            kaddr clientData1, kaddr clientData2)
{
   if (kstrcmp((obj1)->phys->filename, (obj2)->phys->filename) != 0)
      return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_name
|       Purpose: copy the name attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_name(kobject obj1, kobject obj2, int assoc, int attrib,
           kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_name
|       Purpose: query the name attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_name(kobject obj, int assoc, int attrib, kaddr clientData,
            int *num_args, int *arg_size, int *data_type,
            int *permanent)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_name
|       Purpose: print the name attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_name(kobject obj, int assoc, int attrib, kaddr clientData,
            kfile *outfile)
{
   kfprintf(outfile,"%s",obj->phys->filename);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_DIMENSION
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_dimension
|       Purpose: get the dimension attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_dimension(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->dimension;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_dimension
|       Purpose: set the dimension attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_dimension(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->dimension = kva_arg(*list, int);

   if (pres->segment->dimension <= 0)
      pres->segment->dimension = pres->dimension;
   else if (pres->coupling == KCOUPLED)
      pres->segment->update = TRUE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_dimension
|       Purpose: match the dimension attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_dimension(kobject obj1, kobject obj2, int assoc, int attrib,
                 kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->dimension == pres2->dimension);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_dimension
|       Purpose: copy the dimension attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_dimension(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   char *segment = ktoken_to_string(assoc);
   int   dimension;
   
   if (!kdms_get_attribute(obj1, segment, KDMS_DIMENSION, &dimension))
      return FALSE;

   if (!kdms_set_attribute(obj2, segment, KDMS_DIMENSION, dimension))
      return FALSE;
   
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_dimension
|       Purpose: query the dimension attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_dimension(kobject obj, int assoc, int attrib, kaddr clientData,
                 int *num_args, int *arg_size, int *data_type,
                 int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_dimension
|       Purpose: print the dimension attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_dimension(kobject obj, int assoc, int attrib, kaddr clientData,
                 kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "%d", pres->dimension);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_ARCHITECTURE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_architecture
|       Purpose: get the architecture attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_architecture(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   int *args;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = _kdms_glue_get_architecture(obj);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_architecture
|       Purpose: set the architecture attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_architecture(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   return _kdms_glue_set_architecture(obj, kva_arg(*list, int));
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_architecture
|       Purpose: match the architecture attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_architecture(kobject obj1, kobject obj2, int assoc, int attrib,
                    kaddr clientData1, kaddr clientData2)
{
   return (_kdms_glue_get_architecture(obj1) ==
           _kdms_glue_get_architecture(obj2));
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_architecture
|       Purpose: copy the architecture attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_architecture(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_architecture
|       Purpose: query the architecture attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_architecture(kobject obj, int assoc, int attrib, kaddr clientData,
                    int *num_args, int *arg_size, int *data_type,
                    int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_architecture
|       Purpose: print the architecture attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_architecture(kobject obj, int assoc, int attrib, kaddr clientData,
                    kfile *outfile)
{
   kfprintf(outfile,"%s", kmach_description(_kdms_glue_get_architecture(obj)));
   return TRUE;
}
/*********** ---------------------------------------------------------------
 ***********  KDMS_FLAGS
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_flags
|       Purpose: get the flags attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_flags(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   int *args;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = obj->phys->flags;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_flags
|       Purpose: set the flags attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_flags(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_flags
|       Purpose: match the flags attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_flags(kobject obj1, kobject obj2, int assoc, int attrib,
                    kaddr clientData1, kaddr clientData2)
{
   return (obj1->phys->flags == obj2->phys->flags);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_flags
|       Purpose: copy the flags attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_flags(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_flags
|       Purpose: query the flags attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_flags(kobject obj, int assoc, int attrib, kaddr clientData,
                    int *num_args, int *arg_size, int *data_type,
                    int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_flags
|       Purpose: print the flags attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_flags(kobject obj, int assoc, int attrib, kaddr clientData,
                    kfile *outfile)
{
   int r = FALSE, w = FALSE, s = FALSE;

   if (obj->phys->flags & KOBJ_READ)
   {
      kfprintf(outfile, "KOBJ_READ");
      r = TRUE;
   }

   if (obj->phys->flags & KOBJ_WRITE)
   {
      if (r)
         kfprintf(outfile, " | ");
      kfprintf(outfile, "KOBJ_WRITE");
      w = TRUE;
   }

   if (obj->phys->flags & KOBJ_STREAM)
   {
      if (r || w)
         kfprintf(outfile, " | ");
     
      kfprintf(outfile, "KOBJ_STREAM");
      s = TRUE;
   }

   if (obj->phys->flags & KOBJ_RAW)
   {
      if (r || w || s)
         kfprintf(outfile, " | ");

      kfprintf(outfile, "KOBJ_RAW");
   }

   kfprintf(outfile, " (0x%.2x)\n", obj->phys->flags);

   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_COUPLING
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_coupling
|       Purpose: get the coupling attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_coupling(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;
   int *args;

   /*
    *  get the presentation.  if the presentation fails, then just get
    *  the first presentation.  This oughta be close enough to the
    *  "global coupling".  Can't think of a better way to go right now.
    */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
   {
      if (!_kdms_get_segment_info(obj,
                   kstring_to_token(obj->presentations->identifier), &pres))
         return FALSE;
   }

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->coupling;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_coupling
|       Purpose: set the coupling attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_coupling(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;

   if (assoc != kstring_to_token(NULL))
   {
      int cp = kva_arg(*list, int);
      /* get the presentation */
      if (!_kdms_get_segment_info(obj, assoc, &pres))
         return FALSE;

      /*
       * If the segment is coupled, and an update is necessary, then do
       * it if the coupling will become more restrictive.  Otherwise,  
       * the following can occur:
       *    1.  attribute changes, update flag is to true
       *    2.  coupling gets set to uncoupled,
       *    3.  attribute in (1) gets changed
       *    4.  get/put data forces update and physical attribute takes
       *        on value from (3), not (1)!!!
       */
      if (pres->coupling == KCOUPLED && cp != KCOUPLED && 
	  pres->segment->update == TRUE)
	 _kdms_update_segment(obj, pres);

      pres->coupling = cp;
   }
   else
   {
      int cp = kva_arg(*list, int);
      klist *mylist;
      klist *temp;

      mylist = obj->presentations;

      while (mylist != NULL)
      {
         temp = klist_next(mylist);
         if (!_kdms_get_segment_info(obj, klist_token(mylist), &pres))
            return FALSE;
         pres->coupling = cp;
         mylist = temp;
      }
   }

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_coupling
|       Purpose: match the coupling attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_coupling(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /*
    *  get the presentations.  if the presentation fails, then just get
    *  the first presentation.  This oughta be close enough to the
    *  "global coupling".  Can't think of a better way to go right now.
    */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
   {
      if (!_kdms_get_segment_info(obj1,
                 kstring_to_token(obj1->presentations->identifier), &pres1))
         return FALSE;
   }

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
   {
      if (!_kdms_get_segment_info(obj2,
                 kstring_to_token(obj2->presentations->identifier), &pres2))
         return FALSE;
   }

   return (pres1->coupling == pres2->coupling);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_coupling
|       Purpose: copy the coupling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_coupling(kobject obj1, kobject obj2, int assoc, int attrib,
               kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_coupling
|       Purpose: query the coupling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_coupling(kobject obj, int assoc, int attrib, kaddr clientData,
                int *num_args, int *arg_size, int *data_type,
                int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_coupling
|       Purpose: print the coupling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_coupling(kobject obj, int assoc, int attrib, kaddr clientData,
                kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   switch (pres->coupling)
   {
      case KUNCOUPLED:
	 kfprintf(outfile,"KUNCOUPLED");
	 break;
      case KCOUPLED:
	 kfprintf(outfile,"KCOUPLED");
	 break;
      case KDEMAND:
	 kfprintf(outfile,"KDEMAND");
	 break;
      default:
	 kfprintf(outfile,"Bogus coupling (%d)",pres->coupling);
	 break;
   }
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_INTERPOLATE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_interpolate
|       Purpose: get the interpolate attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_interpolate(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->interp;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_interpolate
|       Purpose: set the interpolate attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_interpolate(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->interp = kva_arg(*list, int);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_interpolate
|       Purpose: match the intepolate attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_interpolate(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1,
     *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->interp == pres2->interp);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_interpolate
|       Purpose: copy the interpolate attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_interpolate(kobject obj1, kobject obj2, int assoc, int attrib,
                  kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_interpolate
|       Purpose: query the interpolate attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_interpolate(kobject obj, int assoc, int attrib, kaddr clientData,
                   int *num_args, int *arg_size, int *data_type,
                   int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_interpolate
|       Purpose: print the interpolate attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_interpolate(kobject obj, int assoc, int attrib, kaddr clientData,
                   kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   switch (pres->interp)
   {
      case KNONE:
	 kfprintf(outfile,"KNONE");
	 break;
      case KPAD:
	 kfprintf(outfile,"KPAD");
	 break;
      case KZERO_ORDER:
	 kfprintf(outfile,"KZERO_ORDER");
	 break;
      default:
	 kfprintf(outfile,"Bogus interp (%d)",pres->interp);
	 break;
   }
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_NORM_MIN
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_norm_min
|       Purpose: get the normalization minimum attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_norm_min(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;
   double *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, double *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->norm_min;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_norm_min
|       Purpose: set the normalization minimum attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_norm_min(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->norm_min = kva_arg(*list, double);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_norm_min
|       Purpose: match the normalization minimum attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_norm_min(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->norm_min == pres2->norm_min);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_norm_min
|       Purpose: copy the normalization minimum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_norm_min(kobject obj1, kobject obj2, int assoc, int attrib,
               kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_norm_min
|       Purpose: query the normalization minimum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_norm_min(kobject obj, int assoc, int attrib, kaddr clientData,
                int *num_args, int *arg_size, int *data_type,
                int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_norm_min
|       Purpose: print the normalization minimum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_norm_min(kobject obj, int assoc, int attrib, kaddr clientData,
                kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "%g", pres->norm_min);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_NORM_MAX
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_norm_max
|       Purpose: get the normalization maximum attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_norm_max(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;
   double *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, double *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->norm_max;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_norm_max
|       Purpose: set the normalization maximum attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_norm_max(kobject obj, int assoc, int attr, kaddr clientData,
              kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->norm_max = kva_arg(*list, double);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_norm_max
|       Purpose: match the normalization maximum attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_norm_max(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1,
     *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->norm_max == pres2->norm_max);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_norm_max
|       Purpose: copy the normalization maximum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_norm_max(kobject obj1, kobject obj2, int assoc, int attrib,
               kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_norm_max
|       Purpose: query the normalization maximum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_norm_max(kobject obj, int assoc, int attrib, kaddr clientData,
                int *num_args, int *arg_size, int *data_type,
                int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_norm_max
|       Purpose: print the normalization maximum attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_norm_max(kobject obj, int assoc, int attrib, kaddr clientData,
                kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "%g", pres->norm_max);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_SCALE_FACTOR
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_scale_factor
|       Purpose: get the scale factor attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_scale_factor(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   kpresentation *pres;
   double *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, double *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->scale_factor;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_scale_factor
|       Purpose: set the scale factor attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_scale_factor(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->scale_factor = kva_arg(*list, double);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_scale_factor
|       Purpose: match the scale factor attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_scale_factor(kobject obj1, kobject obj2, int assoc, int attrib,
                    kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1,
     *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->scale_factor == pres2->scale_factor);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_scale_factor
|       Purpose: copy the scale factor attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_scale_factor(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_scale_factor
|       Purpose: query the scale factor attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_scale_factor(kobject obj, int assoc, int attrib, kaddr clientData,
                    int *num_args, int *arg_size, int *data_type,
                    int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_scale_factor
|       Purpose: print the scale factor attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_scale_factor(kobject obj, int assoc, int attrib, kaddr clientData,
                    kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "%g", pres->scale_factor);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_SCALE_OFFSET
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_scale_offset
|       Purpose: get the scale offset attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_scale_offset(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   kpresentation *pres;
   double *r;
   double *i;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   r = kva_arg(*list, double *);
   i = kva_arg(*list, double *);

   *r = pres->scale_offset_real;
   *i = pres->scale_offset_imag;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_scale_offset
|       Purpose: set the scale offset attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_scale_offset(kobject obj, int assoc, int attr, kaddr clientData,
                  kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->scale_offset_real = kva_arg(*list, double);
   pres->scale_offset_imag = kva_arg(*list, double);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_scale_offset
|       Purpose: match the scale offset attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_scale_offset(kobject obj1, kobject obj2, int assoc, int attrib,
                    kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->scale_offset_real == pres2->scale_offset_real &&
           pres1->scale_offset_imag == pres2->scale_offset_imag);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_scale_offset
|       Purpose: copy the scale offset attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_scale_offset(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_scale_offset
|       Purpose: query the scale offset attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_scale_offset(kobject obj, int assoc, int attrib, kaddr clientData,
                    int *num_args, int *arg_size, int *data_type,
                    int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_scale_offset
|       Purpose: print the scale offset attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_scale_offset(kobject obj, int assoc, int attrib, kaddr clientData,
                    kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "(%g %g)", 
	    pres->scale_offset_real, pres->scale_offset_imag);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_SCALING
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_scaling
|       Purpose: get the scaling attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_scaling(kobject obj, int assoc, int attr, kaddr clientData,
             kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->scaling;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_scaling
|       Purpose: set the scaling attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_scaling(kobject obj, int assoc, int attr, kaddr clientData,
             kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->scaling = kva_arg(*list, int);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_scaling
|       Purpose: match the scaling attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_scaling(kobject obj1, kobject obj2, int assoc, int attrib,
               kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->scaling == pres2->scaling);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_scaling
|       Purpose: copy the scaling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_scaling(kobject obj1, kobject obj2, int assoc, int attrib,
              kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_scaling
|       Purpose: query the scaling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_scaling(kobject obj, int assoc, int attrib, kaddr clientData,
               int *num_args, int *arg_size, int *data_type,
               int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_scaling
|       Purpose: print the scaling attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_scaling(kobject obj, int assoc, int attrib, kaddr clientData,
               kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   switch (pres->scaling)
   {
      case KNONE:
	 kfprintf(outfile,"KNONE");
	 break;
      case KSCALE:
	 kfprintf(outfile,"KSCALE");
	 break;
      case KNORMALIZE:
	 kfprintf(outfile,"KNORMALIZE");
	 break;
      default:
	 kfprintf(outfile,"Bogus scaling (%d)",pres->interp);
	 break;
   }
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_PAD_VALUE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_pad_value
|       Purpose: get the pad value attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_pad_value(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;
   double *r;
   double *i;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   r = kva_arg(*list, double *);
   i = kva_arg(*list, double *);

   *r = pres->pad_real;
   *i = pres->pad_imag;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_pad_value
|       Purpose: set the pad value attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_pad_value(kobject obj, int assoc, int attr, kaddr clientData,
               kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->pad_real = kva_arg(*list, double);
   pres->pad_imag = kva_arg(*list, double);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_pad_value
|       Purpose: match the pad value attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_pad_value(kobject obj1, kobject obj2, int assoc, int attrib,
                 kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->pad_real == pres2->pad_real &&
           pres1->pad_imag == pres2->pad_imag);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_pad_value
|       Purpose: copy the pad value attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_pad_value(kobject obj1, kobject obj2, int assoc, int attrib,
                kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_pad_value
|       Purpose: query the pad value attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_pad_value(kobject obj, int assoc, int attrib, kaddr clientData,
                 int *num_args, int *arg_size, int *data_type,
                 int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_pad_value
|       Purpose: print the pad value attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_pad_value(kobject obj, int assoc, int attrib, kaddr clientData,
                 kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile, "(%g %g)", pres->pad_real, pres->pad_imag);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_OPTIMAL_REGION_SIZE
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_optimal_region_size
|       Purpose: get the optimal_region_size attribute
|	Comment: THIS ROUTINE NEEDS A LITTLE WORK
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_optimal_region_size(kobject obj, int assoc, int attr, kaddr clientData,
                         kva_list *list)
{
   int   span;
   int   newspan;
   int   i;
   int **indx;
   int   num = 1;
   int   chunk[KDMS_MAX_DIM] = {1, 1, 1, 1, 1};

   static int reg[KDMS_MAX_DIM + 1];
   int        tmp[KDMS_MAX_DIM];

   kpresentation *pres;
   int total;
   
   /*
    * get the presentation
    */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   /*
    * fixes a heinous bug.
    */
   if (pres->coupling == KCOUPLED && pres->segment->update == TRUE)
      _kdms_update_segment(obj, pres);

   /*
    * fixes another bug!  If the datatype has not been properly set
    * then tmp will be returned as the whole size...this check causes
    * a message to be issued to the programmer if they call this
    * function before initializing the datatype.
    */
   if (pres->segment->datatype == 0)
   {
      kerror("kdataman","get_optimal_region_size",
	     "The data type for the %s segment has not been "
	     "initialized.  It is impossible to compute the optimal "
	     "region size without knowing the data type.\n", 
	     ktoken_to_string(pres->id));
      return FALSE;
   }
   
   span = _kdms_compute_chunk_size(pres->segment->size, 
				   pres->segment->dimension, tmp,
                                   pres->segment->datatype,
				   pres->segment->buffer_threshold);

   for (i = pres->segment->dimension; i < KDMS_MAX_DIM; i++)
      tmp[i] = 1;

   _kdms_translate_coords(pres->segment->size, pres->segment->order, tmp,
				pres->size, pres->order, chunk, 
				pres->dimension, 1, 1);

   /* 
    * correction for translate_coords goofiness
    */
   for (i = 0; i < KDMS_MAX_DIM; i++)
      chunk[i] = kmax (1, chunk[i]);
   
   if (span < pres->dimension) 
   {
      for (i = 0, newspan = -1; i < pres->dimension && newspan == -1; i++)
	 if (pres->order[i] == pres->segment->order[span]) 
	    newspan = i;
   
      while (pres->size[newspan] % chunk[newspan] != 0)
	 chunk[newspan] --;
   }
   
   /*
    * Ok.  What if the resulting chunk is still too big?  Back off of
    * it so that it will fit.  Right now, this is kind of a strange
    * way to to implement this.  This approach is simply to replace
    * the optimal region size with a presentation optimal region size.
    */
   for (i = 0, total = 1; i < pres->dimension; i++)
      total *= chunk[i];
   
   if (total > _kdms_get_buffer_threshold(pres))
      span = _kdms_compute_chunk_size(pres->size, 
				      pres->dimension, chunk,
				      pres->datatype,
				      pres->segment->buffer_threshold);
      
   indx = kva_arg(*list, int **);

   if (indx == NULL)
      return FALSE;   /* we can't return anything */

   /* point them to our handy space */
   *indx = (int *)reg;

   for (i = 0; i < pres->dimension; i++)
      num *= (int)(kceil((float)pres->size[i]/(float)chunk[i]));
   
   for (i = 0; i < pres->dimension; i++)
   {
      (*indx)[i] = chunk[i];
   }

   /* the final element is the number of arguments */
   (*indx)[pres->dimension] = num;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_optimal_region_size
|       Purpose: match the optimal region size attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_optimal_region_size(kobject obj1, kobject obj2, int assoc, int attrib,
                           kaddr clientData1, kaddr clientData2)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_optimal_region_size
|       Purpose: query the optimal region size attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_optimal_region_size(kobject obj, int assoc, int attrib,
                           kaddr clientData, int *num_args, int *arg_size,
                           int *data_type, int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_optimal_region_size
|       Purpose: print the optimal region size attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_optimal_region_size(kobject obj, int assoc, int attrib,
                           kaddr clientData, kfile *outfile)
{
   return FALSE ;
}

/*********** ---------------------------------------------------------------
 ***********  KDMS_BUFFER_THRESHOLD
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_buffer_threshold
|       Purpose: get the buffer_threshold attribute
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_buffer_threshold(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->buffer_threshold;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_buffer_threshold
|       Purpose: set the buffer_threshold attribute
|    Written By: Jermey Worley
|          Date: Oct 04, 1993 12:29
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_buffer_threshold(kobject obj, int assoc, int attr, kaddr clientData,
                 kva_list *list)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   pres->segment->buffer_threshold = kva_arg(*list, int);

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_buffer_threshold
|       Purpose: match the intepolate attribute
|    Written By: John M. Salas
|          Date: Dec 23, 1993
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_buffer_threshold(kobject obj1, kobject obj2, int assoc, int attrib,
                   kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   return (pres1->segment->buffer_threshold == 
	   pres2->segment->buffer_threshold);
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_buffer_threshold
|       Purpose: copy the buffer_threshold attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_buffer_threshold(kobject obj1, kobject obj2, int assoc, int attrib,
                  kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;

   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   pres2->segment->buffer_threshold = pres1->segment->buffer_threshold;
   
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_buffer_threshold
|       Purpose: query the buffer_threshold attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_buffer_threshold(kobject obj, int assoc, int attrib, kaddr clientData,
                   int *num_args, int *arg_size, int *data_type,
                   int *permanent)
{
   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_buffer_threshold
|       Purpose: print the buffer_threshold attribute
|    Written By: Steve Kubica
|          Date: Mar 30, 1994 14:36
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_buffer_threshold(kobject obj, int assoc, int attrib, kaddr clientData,
                   kfile *outfile)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   kfprintf(outfile,"%d bytes",pres->segment->buffer_threshold);
   
   return TRUE;
}

/*********** ---------------------------------------------------------------
 ***********  Physical Layer Attributes
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_physical_size
|       Purpose: get the physical size attribute
|    Written By: Jeremy Worley
|          Date: Aug 13, 1994 15:42
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_physical_size(kobject obj, int assoc, int attr, kaddr clientData,
		   kva_list *list)
{
   kpresentation *pres;
   int **args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->segment->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   args = kva_arg(*list, int **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->size;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _get_physical_index_order
|       Purpose: get the physical order attribute
|    Written By: Jeremy Worley
|          Date: Aug 13, 1994 15:42
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_physical_index_order(kobject obj, int assoc, int attr, kaddr clientData,
			  kva_list *list)
{
   kpresentation *pres;
   int **args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->segment->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   args = kva_arg(*list, int **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->order;

   return TRUE;
}


/*-----------------------------------------------------------
|  Routine Name: (static) _get_physical_data_type
|       Purpose: get the physical data type attribute
|    Written By: Jeremy Worley
|          Date: Aug 13, 1994 15:43
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_physical_data_type(kobject obj, int assoc, int attr, kaddr clientData,
			kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->datatype;

   return TRUE;
}


/*-----------------------------------------------------------
|  Routine Name: (static) _get_physical_dimension
|       Purpose: get the physical dimension attribute
|    Written By: Jeremy Worley
|          Date: Aug 13, 1994 15:43
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_physical_dimension(kobject obj, int assoc, int attr, kaddr clientData,
			kva_list *list)
{
   kpresentation *pres;
   int *args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->segment->dimension;

   return TRUE;
}


/*********** ---------------------------------------------------------------
 ***********  KDMS_OFFSET
 *********** --------------------------------------------------------------- */

/*-----------------------------------------------------------
|  Routine Name: (static) _get_offset
|       Purpose: get the offset attribute
|    Written By: Jeremy Worley
|          Date: Fri Dec  2 10:22:30 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_get_offset(kobject obj, int assoc, int attr, kaddr clientData,
	    kva_list *list)
{
   kpresentation *pres;
   int **args;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   args = kva_arg(*list, int **);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   *args = pres->offset;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _set_offset
|       Purpose: set the offset attribute
|    Written By: Jermey Worley
|          Date: Fri Dec  2 10:22:40 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_set_offset(kobject obj, int assoc, int attr, kaddr clientData,
             kva_list *list)
{
   kpresentation *pres;
   int *args;
   int i;
   
   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   args = kva_arg(*list, int *);

   if (args == NULL)
   {
      _kdms_set_error(KDMS_EATTR_NULLARGS);
      return FALSE;
   }

   /* 
    *  set the size dimensions for all args which are not == -1 if the
    *  arg is -1 that implies that the old size should be retained. 
    */
   for (i = 0; i < pres->dimension; i++)
      pres->offset[i] = args[i];

   for (i = pres->dimension; i < KDMS_MAX_DIM; i++)
      pres->offset[i] = 0;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _match_offset
|       Purpose: match the offset attribute
|    Written By: John M. Salas
|          Date: Fri Dec  2 10:22:50 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_match_offset(kobject obj1, kobject obj2, int assoc, int attrib,
               kaddr clientData1, kaddr clientData2)
{
   kpresentation *pres1;
   kpresentation *pres2;
   int i;
   
   /* get the presentations */
   if (!_kdms_get_segment_info(obj1, assoc, &pres1))
      return FALSE;

   if (!_kdms_get_segment_info(obj2, assoc, &pres2))
      return FALSE;

   if (pres1->dimension <= 0 || pres2->dimension <= 0 ||
       pres1->dimension != pres2->dimension)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   for (i = 0; i < pres1->dimension; i++)
      if (pres1->offset[i] != pres2->offset[i])
         return FALSE;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _copy_offset
|       Purpose: copy the offset attribute
|    Written By: Steve Kubica
|          Date: Fri Dec  2 10:22:58 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_copy_offset(kobject obj1, kobject obj2, int assoc, int attrib,
	     kaddr clientData1, kaddr clientData2)
{
   return FALSE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _query_offset
|       Purpose: query the offset attribute
|    Written By: Steve Kubica
|          Date: Fri Dec  2 10:23:06 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_query_offset(kobject obj, int assoc, int attrib, kaddr clientData,
	      int *num_args, int *arg_size, int *data_type, int *permanent)
{
   kpresentation *pres;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   /* these are all constant, just fill them out */
   if (num_args)
      *num_args = 1;
   if (data_type)
      *data_type = KINT;
   if (permanent)
      *permanent = TRUE;

   if (arg_size)
      *arg_size = pres->dimension;

   return TRUE;
}

/*-----------------------------------------------------------
|  Routine Name: (static) _print_offset
|       Purpose: print the offset attribute
|    Written By: Steve Kubica
|          Date: Fri Dec  2 10:23:12 1994
-----------------------------------------------------------*/

/*ARGSUSED */
static int
_print_offset(kobject obj, int assoc, int attrib, kaddr clientData,
	      kfile *outfile)
{
   kpresentation *pres;
   int i;

   /* get the presentation */
   if (!_kdms_get_segment_info(obj, assoc, &pres))
      return FALSE;

   if (pres->dimension <= 0)
   {
      _kdms_set_error(KDMS_EATTR_SIZEDIM);
      return FALSE;
   }

   for (i = 0; i < pres->dimension; i++)
      kfprintf(outfile, " %d ", pres->offset[i]);

   return (TRUE);
}

/* 
 *    ================================================================== 
 *    Initialization Routines
 *    ==================================================================
 */

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_init_attributes
|
|       Purpose: Initializes all attributes used by the khoros
|                Data Management Services (KDMS).
|
|         Input: none
|
|        Output: none
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:17
| Modifications:
|
------------------------------------------------------------*/

static int
_kdms_init_attributes(void)
{
   kdms_define_quasi_attribute(KDMS_OBJECT, KDMS_NAME, NULL,
                               _get_name, _set_name, _match_name,
                               _copy_name, _query_name, _print_name);

   kdms_define_quasi_attribute(KDMS_OBJECT, KDMS_FORMAT, NULL,
                               _get_format, _set_format, _match_format,
                               _copy_format, _query_format, _print_format);

   kdms_define_quasi_attribute(KDMS_OBJECT, KDMS_ARCHITECTURE, NULL,
              _get_architecture, _set_architecture, _match_architecture,
              _copy_architecture, _query_architecture, _print_architecture);

   kdms_define_quasi_attribute(KDMS_OBJECT, KDMS_FLAGS, NULL,
              _get_flags, _set_flags, _match_flags,
              _copy_flags, _query_flags, _print_flags);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_SIZE, NULL,
                               _get_size, _set_size, _match_size,
                               _copy_size, _query_size, _print_size);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_INDEX_ORDER, NULL,
                 _get_index_order, _set_index_order, _match_index_order,
                 _copy_index_order, _query_index_order, _print_index_order);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_COMPLEX_CONVERT, NULL,
     _get_complex_convert, _set_complex_convert, _match_complex_convert,
     _copy_complex_convert, _query_complex_convert, _print_complex_convert);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_COUPLING, NULL,
                          _get_coupling, _set_coupling, _match_coupling,
                          _copy_coupling, _query_coupling, _print_coupling);

   kdms_define_quasi_attribute(KDMS_OBJECT, KDMS_COUPLING, NULL,
                          _get_coupling, _set_coupling, _match_coupling,
                          _copy_coupling, _query_coupling, _print_coupling);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_INTERPOLATE, NULL,
                 _get_interpolate, _set_interpolate, _match_interpolate,
                 _copy_interpolate, _query_interpolate, _print_interpolate);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_BUFFER_THRESHOLD, NULL,
			       _get_buffer_threshold, _set_buffer_threshold, 
			       _match_buffer_threshold, _copy_buffer_threshold,
			       _query_buffer_threshold, 
			       _print_buffer_threshold);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_NORM_MIN, NULL,
                          _get_norm_min, _set_norm_min, _match_norm_min,
                          _copy_norm_min, _query_norm_min, _print_norm_min);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_NORM_MAX, NULL,
                          _get_norm_max, _set_norm_max, _match_norm_max,
                          _copy_norm_max, _query_norm_max, _print_norm_max);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PAD_VALUE, NULL,
                       _get_pad_value, _set_pad_value, _match_pad_value,
                       _copy_pad_value, _query_pad_value, _print_pad_value);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_SCALE_FACTOR, NULL,
              _get_scale_factor, _set_scale_factor, _match_scale_factor,
              _copy_scale_factor, _query_scale_factor, _print_scale_factor);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_SCALE_OFFSET, NULL,
              _get_scale_offset, _set_scale_offset, _match_scale_offset,
              _copy_scale_offset, _query_scale_offset, _print_scale_offset);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_SCALING, NULL,
                             _get_scaling, _set_scaling, _match_scaling,
                             _copy_scaling, _query_scaling, _print_scaling);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_DATA_TYPE, NULL,
                       _get_data_type, _set_data_type, _match_data_type,
                       _copy_data_type, _query_data_type, _print_data_type);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PERMANENCE, NULL,
                    _get_permanence, _set_permanence, _match_permanence,
                    _copy_permanence, _query_permanence, _print_permanence);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_DIMENSION, NULL,
                       _get_dimension, _set_dimension, _match_dimension,
                       _copy_dimension, _query_dimension, _print_dimension);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_OPTIMAL_REGION_SIZE,
           NULL, _get_optimal_region_size, NULL, _match_optimal_region_size,
           NULL, _query_optimal_region_size, _print_optimal_region_size);

   kdms_define_attribute(KDMS_ALL_SEGMENTS, KDMS_TRANSFERABLE, 1, 1, KINT,
			 TRUE, TRUE, TRUE);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PHYSICAL_SIZE, NULL,
                               _get_physical_size, NULL, NULL,
                               NULL, NULL, NULL);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PHYSICAL_INDEX_ORDER, 
			       NULL, _get_physical_index_order, NULL, NULL,
                               NULL, NULL, NULL);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PHYSICAL_DATA_TYPE, 
			       NULL, _get_physical_data_type, NULL, NULL,
                               NULL, NULL, NULL);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_PHYSICAL_DIMENSION, 
			       NULL, _get_physical_dimension, NULL, NULL,
                               NULL, NULL, NULL);

   kdms_define_quasi_attribute(KDMS_ALL_SEGMENTS, KDMS_OFFSET, NULL,
                               _get_offset, _set_offset, _match_offset,
                               _copy_offset, _query_offset, _print_offset);

   /*
    *   it is possible to generate errnos with duplicate attribute
    *   definitions.  to prevent the user from seeing this, we'll
    *   re-zero the errno.
    */
   errno = 0;

   return TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: _kdms_init
|
|       Purpose: Initializes everything needed by the khoros
|                Data Management Services (KDMS).
|
|         Input: none
|
|        Output: none
|
|       Returns: TRUE all the time
|
|    Written By: Jeremy Worley
|          Date: Oct 04, 1993 12:17
| Modifications:
|
------------------------------------------------------------*/

int
_kdms_init(void)
{
   if (_kdms_compiled == TRUE)
      return TRUE;

   /* prevent this routine from being called again */
   _kdms_compiled = TRUE;

   /* initialize the formats */
   _kdms_init_formats();
   
   /* initialize the error numbers */
   _kdms_init_errors();

   /* define all of the attributes */
   _kdms_init_attributes();

   /* add exit handler to cleanup data services upon exit */
   kexit_handler(_kdms_exit_data_services, NULL);

   /* determine buffer sizes, etc. */
   _kdms_get_buffer_size();

   /* get a life */
   return TRUE;
}
