 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";

#endif

 /*
  * $Log$
  */


/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros XBM Data Service Routines
   >>>>
   >>>>   Static:
   >>>>             _init()
   >>>>             xbm_check()
   >>>>             xbm_input()
   >>>>             xbm_output()
   >>>>             xbm_destroy()
   >>>>             xbm_order()
   >>>>  Private:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


#if !defined(KXBM_DEF)
DataServiceInformation xbm_format[] =
{NULL};

#else

#include "kdatafmt/xbm.h"


static int xbm_check PROTO((int));
static int xbm_input PROTO((kobject, int, int));
static int xbm_output PROTO((kobject, int, int));
static int xbm_destroy PROTO((kobject));
static int xbm_order PROTO((char *, int *));

DataServiceInformation xbm_format[] =
{
   {
      "X11 Bitmap File Format (xbm)",
      "xbm",
      xbm_check,
      xbm_input,
      xbm_output,
      xbm_destroy,
      NULL,
      NULL,
      xbm_order,
      NULL,
      NULL,
      NULL,
   }
};

/*
 *  Internal Resource Structure for the following data services
 *
 *              xbm  -  X11 Bitmap File Format Utilities (xbm)
 */
typedef struct
{
   kfile *file;
   xbm *image;
}
ResourceStruct;


/*-----------------------------------------------------------
|
|  Routine Name: _init - Creates an xbm image
|
|       Purpose: This function is used to create an xbm image.  Which
|                means that we use the current dimension values in order
|                to create a proper xbm.
|
|         Input: data - initial sample of data
|                num  - number of bytes in the sample
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

static int
_init(kobject object)
{
   ResourceStruct *resources;


   /*
    * Create the image to the object file
    */
   resources = (ResourceStruct *) kcalloc(1, sizeof(ResourceStruct));

   if (resources == NULL)
      return (FALSE);

   _kdms_glue_set_resources(object, resources);
   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: xbm_check - Checks to see if the file is
|                                an xbm
|
|       Purpose: This function is used to check the first few bytes of
|                the stream to see if it is an xbm.
|
|         Input: object - the xbm object to be initialized
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

static int
xbm_check(int fid)
{
   /*
    * Seems like the easiest way to do this is to check the header
    */
   if (xbm_readheader(fid) == NULL)
      return (FALSE);
   else
      return (TRUE);
}



/*-----------------------------------------------------------
|
|  Routine Name: xbm_input - Read a xbm image
|
|       Purpose: This function is used to read in the image if the
|                supplied data is xbm image.  The data was checked
|                by the xbm_check() routine in which the xbm
|                identifier indicated that the data is a valid xbm.
|                Since the data was valid we can assume simply read
|                the header in and initialize that data segments.
|
|         Input: object - the xbm object to be initialized
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static int
xbm_input(kobject object, int fid, int flags)
{
   ResourceStruct *resources;
   xbm *image;
   kaddr tmp;
   int num;
   int i,
      size[KDMS_MAX_DIM],
      order[KDMS_MAX_DIM],
      begin[KDMS_MAX_DIM],
      end[KDMS_MAX_DIM];

   if (!_kdms_initialized(object))
      _init(object);

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);

   /*
    * Read the image from the object file and go ahead and set the xbm image
    * within the resource structure.
    */
   image = resources->image = xbm_fdread(fid);
   if (image == NULL)
   {
      _kdms_set_error(KDMS_EFMT_FAILURE);
      return (FALSE);
   }

   /*
    * Initialize the data segments according to the data found in the xbm
    * structure.
    * 
    * The xbm structure only contains value (image->data)
    */

   /* check the value data */
   if (image->width != 0 && image->height != 0)
   {
      size[0] = image->width;
      size[1] = image->height;
      size[2] = size[3] = size[4] = 1;

      order[0] = KWIDTH;
      order[1] = KHEIGHT;
      order[2] = KELEMENTS;
      order[3] = KDEPTH;
      order[4] = KTIME;

      for (i = 0; i < KDMS_MAX_DIM; i++)
      {
         end[i] = size[i] - 1;
         begin[i] = 0;
      }

      num = ((size[0] + 7) >> 3) << 3;
      kdata_cast(image->data, KBIT_LSB, KBIT, ( num * 
					       (end[1] - begin[1] + 1) * 
					       (end[2] - begin[2] + 1) * 
					       (end[3] - begin[3] + 1) * 
					       (end[4] - begin[4] + 1)), 
		 KNONE, 1.0, 1.0, image->data);

      /*
       * This is kind of gross but its here to prevent a free of unallocated
       * memory later on.
       */
      tmp = kmalloc((num >> 3) * size[1]);
      kmemcpy(tmp, image->data, (num >> 3) * size[1]);
      
      _kdms_set_segment(object, KDMS_SEGMENT_VALUE, tmp, KBIT,
                        order, size, begin, end, 5);

      /*
       * Since we never use this again, might as well save some space.
       * The free of this in xbm_free is smart enough not to try it if
       * the image->data pointer is NULL.
       */
      kfree(image->data);
      image->data = NULL;
      
      /*
       * it is vitally important that you include this step because if the
       * data set larger than the buffer threshold, then spurous flushes
       * will ensue that should not happen...it turns out that xvimages and
       * viffs will cope with that situation (though not very efficiently),
       * but file formats that buffer the whole thing in memory won't.
       */
      kdms_set_attribute(object, KDMS_SEGMENT_VALUE, KDMS_COUPLING,KUNCOUPLED);

   }

   return (TRUE);
}



/*-----------------------------------------------------------
|
|  Routine Name: xbm_output - Closes the xbm image
|
|       Purpose: This function is used to close the xbm image.  Which
|                means if the image was modified we then re-write image
|                back out.
|
|         Input: object - the xbm object to be closed
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static int
xbm_output(kobject object, int fid, int flags)
{
   ResourceStruct *resources;
   int vorder[KDMS_MAX_DIM] = {KWIDTH, KHEIGHT, KDEPTH, KTIME, KELEMENTS};
   int begin[KDMS_MAX_DIM] = {0, 0, 0, 0, 0};
   int end[KDMS_MAX_DIM];
   int num;
   
   xbm *image;
   int *size;
   
   if (!_kdms_initialized(object))
      _init(object);

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);

   if (resources->image == NULL)
   {
      resources->image = xbm_create();
      if (!resources->image)
      {
         _kdms_traceback("xbm_output");
         _kdms_set_error(KDMS_EFMT_FAILURE);
         return (FALSE);
      }
   }
   image = resources->image;

   /*
    * Initialize the image's data arrays according to the data found in the
    * data segment->
    * 
    * The xbm structure only contains value (imagedata), maps, and location
    * data.
    */

   /*
    * check the value data
    */
   if (!kdms_set_attributes(object, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KBIT,
                            KDMS_INDEX_ORDER, vorder, NULL))
      return (FALSE);

   kdms_get_attribute(object, KDMS_SEGMENT_VALUE, KDMS_SIZE, &size);
   
   end[0] = size[0] - 1;
   end[1] = size[1] - 1;
   end[2] = end[3] = end[4] = 0;
   
   image->width = (int)size[0];
   image->height = (int)size[1];

   image->data = kdms_get_data(object, KDMS_SEGMENT_VALUE, begin, end, NULL);
   num = ((size[0] + 7) >> 3) << 3;
   kdata_cast(image->data, KBIT_LSB, KBIT, ( num * 
					    (end[1] - begin[1] + 1) * 
					    (end[2] - begin[2] + 1) * 
					    (end[3] - begin[3] + 1) * 
					    (end[4] - begin[4] + 1)), 
	      KNONE, 1.0, 1.0, image->data);
   /*	
    * Write the xbm structure out to the specified filename
    */
   return(xbm_fdwrite(fid, image));
}

/*-----------------------------------------------------------
|
|  Routine Name: xbm_destroy - Frees an xbm image
|
|       Purpose: This function is used to create an xbm image.  Which
|                means that we use the current dimension values in order
|                to create a proper xbm.
|
|         Input: data - initial sample of data
|                num  - number of bytes in the sample
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

static int
xbm_destroy(kobject object)
{
   ResourceStruct *resources;

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);

   /*
    * free the xbmer structure
    */
   xbm_free(resources->image);

   /*
    * free the resources
    */
   kfree(resources);

   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: xbm_order
|
|       Purpose:
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Mar 14, 1994 15:43
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED*/
static int
xbm_order(char *seg, int *ord)
{
   return (TRUE);
}

#endif /* KXBM_DEF */

/* don`t add after the endif */
