 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "xpm" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   X11 Pixmap Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   GROUPE BULL
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 07, 1993 13:50
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_xpm_h_
#define _kdatafmt_xpm_h_

/*
 *	The "xpm" image file format describes the format used by
 *	the X11 Pixmap Format  conversion routines.  The format was developed
 *	by GROUPE BULL
 *
 *	The following structure is used by the conversion routines to read
 *	and write the xpm files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert xpm
 *	files to and from the format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _xpmcolor
{
        unsigned long   pixel;
        unsigned short  red;
        unsigned short  green;
        unsigned short  blue;
        unsigned char   flags;
        char	 *val;
} xpmcolor;


typedef struct _xpm
{
	int	 width;
	int	 height;
	int	 ncolors;
        int	 size;
	char     *data;
	char     *name;
	xpmcolor *maps;
} xpm;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

xpm	*xpm_readheader PROTO((int));
xpm	*xpm_read	PROTO((char *));
xpm	*xpm_fdread	PROTO((int));
xpm	*xpm_create     PROTO((void));
int	xpm_writeheader PROTO((int, xpm *));
int	xpm_write	PROTO((char *, xpm *));
int	xpm_fdwrite	PROTO((int, xpm *));
int	xpm_free	PROTO((xpm *));


#endif /* _kdatafmt_xpm_h_ */
/* Don't add after this point */
