#! /bin/sh 

echo "running test5.sh for knormal ... process ($$)"

echo "         Test  5 Large data set - tests not written yet"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  5:  large data set
# ------------------------------------------------------------------------
# ---------- Test 5a --> clouds   run -w -h , then stats -w -h -min -max 
# 			 -minpos -maxpos... and compare with stored stats
# ---------- Test 5a --> clouds   run -whole , then stats -w -h -min -max 
# 			 -minpos -maxpos... and compare with stored stats

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------

exit $status

