#! /bin/sh 

echo "running test2.sh for knormal ... process ($$)"

echo "         Test  2 Normalize map data (with and without value data)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  2:  Normalize objects map data (with and without value data)
# ------------------------------------------------------------------------

# ---------- Test 2a --> normalize (5 to 100), map only, -whole

test_num=2a
descr="normalize (5 to 100), map only, -whole"
cat <<EOF > $tmpdir/ascii.$$
-2 -1 -3 7
7 58 59 13
36 3 38 1
1 -2 -3 -4
EOF
kasc2map -i1 $tmpdir/ascii.$$ -o $tmpdir/mapdata.$$ -type Float -wsize 4 -hsize 4 
knormal -i $tmpdir/mapdata.$$ -o $tmpdir/out.$$ -uval 100 -lval 5 -whole -type "Unsigned Byte"
cat <<EOF > $tmpdir/ascii2.$$
8.01587  9.52381  6.50794  21.5873  
21.5873  98.4921  100  30.6349  
65.3175  15.5556  68.3333  12.5397  
12.5397  8.01587  6.50794  5  
EOF
kasc2map -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "Unsigned Byte" -wsize 4 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2b --> normalize (5 to 100), map only, -h

test_num=2b
descr="normalize (5 to 100), map only, -h"
knormal -i $tmpdir/mapdata.$$ -o $tmpdir/out.$$ -uval 100 -lval 5 -h -type Long
cat <<EOF > $tmpdir/ascii2.$$
5	6.58333  5	66.4706
27.5  	100	100	100
100  	12.9167	67.8226	32.9412
12.5  	5	5	5
EOF
kasc2map -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Long -wsize 4 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2c --> normalize (5 to 100), map only, -w

test_num=2c
descr="normalize (5 to 100), map only, -w"
knormal -i $tmpdir/mapdata.$$ -o $tmpdir/out.$$ -uval 100 -lval 5 -w -type Short
cat <<EOF > $tmpdir/ascii2.$$
14.5  24  5  100
5  98.1731  100  15.9615
94.8649  10.1351  100  5  
100  43  24  5  
EOF
kasc2map -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type Short -wsize 4 -hsize 4
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 2d --> normalize (5 to 100) for map, value, -whole

test_num=2d
descr="normalize (5 to 100) for map, value, -whole"
cat <<EOF > $tmpdir/ascii.$$
-2 -1 -3 7
7 58 59 13
36 3 38 1
1 -2 -3 -4
EOF
kasc2map -i1 $tmpdir/ascii.$$ -o $tmpdir/mapdata.$$ -type Float -wsize 4 -hsize 4 
cat <<EOF > $tmpdir/ascii.$$
2 3 4 0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -i2 $tmpdir/mapdata.$$ -o $tmpdir/mvdata.$$ -type "Unsigned Byte" -wsize 1 -hsize 6
knormal -i $tmpdir/mvdata.$$ -o $tmpdir/out.$$ -uval 100 -lval 5 -whole -type "Unsigned Byte"

cat <<EOF > $tmpdir/ascii2.$$
8.01587  9.52381  6.50794  21.5873
21.5873  98.4921  100  30.6349
65.3175  15.5556  68.3333  12.5397
12.5397  8.01587  6.50794  5
EOF
kasc2map -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "Unsigned Byte" -wsize 4 -hsize 4 
kasc2val -i1 $tmpdir/ascii.$$ -i2 $tmpdir/answer.$$ -o $tmpdir/answer.$$ -type "Unsigned Byte" -wsize 1 -hsize 6
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------
/bin/rm $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$ 
/bin/rm $tmpdir/mapdata.$$ $tmpdir/answer.$$ 
/bin/rm $tmpdir/mvdata.$$

exit $status

