#! /bin/sh 

echo "running test1.sh for kmapdata ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  value data maps into valid map rows 
# ------------------------------------------------------------------------
test_num=1
descr="value data mapping into valid map rows"
kmapdata -i $datapath/2x3ival_6x3fmap.viff -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test1.results/2x3ival_6x3fmap.mapped" "$descr"
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2:  Value data indexes beyond map range  
# ------------------------------------------------------------------------
test_num=2
descr="Value data indexes beyond map range"
kmapdata -i $datapath/2x5ival_6x3fmap.viff -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test1.results/2x5ival_6x3fmap.mapped" "$descr"
descr="Same data, but no tolerance on ksegcmp - catches almost zeros"
ksegcmp -i1 "$tmpdir/out.$$" -i2 "test1.results/2x5ival_6x3fmap.mapped" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$descr""
else
   echo "FAILED:  Test  $test_num --> "$descr""
   status=1
fi

/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  Value, Mask, and Map data 
# ------------------------------------------------------------------------
test_num=3
descr="Value, Mask, and Map data"
kmapdata -i $datapath/2x3ival_6x3fmap_2x3bmask.viff -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "test1.results/2x3ival_6x3fmap_2x3bmask.mapped" "$descr"
/bin/rm -f $tmpdir/out.$$

exit $status
