#! /bin/sh  

# Replace oname and file.sh in the two lines below with the name
# of the program you are testing and the file name of this test
# (for example, test1.sh).
 
object_name="klinearop"
file_name="test1.sh"
 
# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test
# suite" comment lines (line 60).
# ---------------------------------------------------------------
 
echo "running "$file_name" for "$object_name" ... process ($$)"
 
# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output
# data object ($2) against the correct result ($3), and reports
# success or failure of the test.  If the result of ksegcmp is
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"
 
   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}
 
# Initialize status to be success (ie. 0).  Upon failure, status
# is initialized to 1.  Set the tmpdir variable.  Script will
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
bpath=`kecho -tb DATAMANIP -echo path`/bin
dpath="$tbpath/data/images/"

# ------------------------------------------------------------------------
# Test  1: convolution theorem 2D data type Double 
# ------------------------------------------------------------------------
test_num=1
descr="convolution theorem:  2D data type Double"

kresample -resize 1 -inter 0 -i $dpath/ball.xv -wmag 0.125 -hmag 0.125 -o $tmpdir/out1.$$

kpad -i $tmpdir/out1.$$ -wsize 128 -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o $tmpdir/out1.$$ 

$bpath/klinearop -i1 $tmpdir/out1.$$ -i2 $tbpath/data/kernels/avg5x5.asc -w -h -o $tmpdir/out.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0 -upcast

kfft -i $tmpdir/out1.$$ -dir 0 -scale 3 -o $tmpdir/out1.$$ -w -h

kpad -i $tbpath/data/kernels/avg5x5.asc  -wsize 128  -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o  $tmpdir/kernel.$$

kfft -i  $tmpdir/kernel.$$ -dir 0 -scale 3 -o  $tmpdir/kernel.$$ -w -h

karith2 -mul -i1 $tmpdir/out1.$$ -i2  $tmpdir/kernel.$$ -o $tmpdir/out1.$$

kfft -i $tmpdir/out1.$$ -dir 1 -scale 1 -o $tmpdir/out1.$$ -w -h

kconvert -i $tmpdir/out1.$$ -type 11 -scale 1 -roff 0 -ioff 0 -o $tmpdir/out1.$$ -val

report $test_num "$tmpdir/out1.$$" "$tmpdir/out.$$" "$descr" "1e-3"
/bin/rm -f $tmpdir/out.$$
/bin/rm -f $tmpdir/out1.$$
/bin/rm -f $tmpdir/kernel.$$

# ------------------------------------------------------------------------
# Test  2: convolution theorem 2D data type Long 
# ------------------------------------------------------------------------
test_num=2
descr="convolution theorem:  2D data type Long"

kconvert -i $dpath/ball.xv -type 8 -scale 1 -roff 0 -ioff 0 -o $tmpdir/out1.$$ -val

kresample -resize 1 -inter 0 -i $tmpdir/out1.$$ -wmag 0.125 -hmag 0.125 -o $tmpdir/out1.$$

kpad -i $tmpdir/out1.$$ -wsize 128 -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o $tmpdir/out1.$$ 

$bpath/klinearop -i1 $tmpdir/out1.$$ -i2 $tbpath/data/kernels/avg5x5.asc -w -h -o $tmpdir/out.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

kfft -i $tmpdir/out1.$$ -dir 0 -scale 3 -o $tmpdir/out1.$$ -w -h

kpad -i $tbpath/data/kernels/avg5x5.asc -wsize 128  -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o  $tmpdir/kernel.$$

kfft -i  $tmpdir/kernel.$$ -dir 0 -scale 3 -o  $tmpdir/kernel.$$ -w -h

karith2 -mul -i1 $tmpdir/out1.$$ -i2  $tmpdir/kernel.$$ -o $tmpdir/out1.$$

kfft -i $tmpdir/out1.$$ -dir 1 -scale 1 -o $tmpdir/out1.$$ -w -h

kcmplx2real -i $tmpdir/out1.$$ -om $tmpdir/out1.$$ -mag
 
karith2 -absdiff -i1 $tmpdir/out1.$$ -i2 $tmpdir/out.$$ -o $tmpdir/absdiff.$$
kstats -i $tmpdir/absdiff.$$ -o $tmpdir/stats.$$ -minval -maxval
cat <<EOF > $tmpdir/results.$$
         0   0.0001953124997  
EOF
kasc2val -i1 $tmpdir/results.$$ -o $tmpdir/results.$$ -esize 2 -type 11
 
report $test_num "$tmpdir/stats.$$" "$tmpdir/results.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$
/bin/rm -f $tmpdir/out1.$$
/bin/rm -f $tmpdir/kernel.$$
/bin/rm -f $tmpdir/absdiff.$$
/bin/rm -f $tmpdir/stats.$$
/bin/rm -f $tmpdir/results.$$

# ------------------------------------------------------------------------
# Test  3: convolution theorem 2D data type Unsigned Byte 
# ------------------------------------------------------------------------
test_num=3
descr="convolution theorem:  2D data type Unsigned Byte"

kconvert -i $dpath/ball.xv -type 3 -scale 1 -roff 0 -ioff 0 -o $tmpdir/out1.$$ -val

kresample -resize 1 -inter 0 -i $tmpdir/out1.$$ -wmag 0.125 -hmag 0.125 -o $tmpdir/out1.$$

kpad -i $tmpdir/out1.$$ -wsize 128 -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o $tmpdir/out1.$$ 

$bpath/klinearop -i1 $tmpdir/out1.$$ -i2 $tbpath/data/kernels/avg5x5.asc -w -h -o $tmpdir/out.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

kfft -i $tmpdir/out1.$$ -dir 0 -scale 3 -o $tmpdir/out1.$$ -w -h

kpad -i $tbpath/data/kernels/avg5x5.asc -wsize 128  -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o  $tmpdir/kernel.$$

kfft -i  $tmpdir/kernel.$$ -dir 0 -scale 3 -o  $tmpdir/kernel.$$ -w -h

karith2 -mul -i1 $tmpdir/out1.$$ -i2  $tmpdir/kernel.$$ -o $tmpdir/out1.$$

kfft -i $tmpdir/out1.$$ -dir 1 -scale 1 -o $tmpdir/out1.$$ -w -h

kcmplx2real -i $tmpdir/out1.$$ -om $tmpdir/out1.$$ -mag
 
karith2 -absdiff -i1 $tmpdir/out1.$$ -i2 $tmpdir/out.$$ -o $tmpdir/absdiff.$$
kstats -i $tmpdir/absdiff.$$ -o $tmpdir/stats.$$ -minval -maxval
cat <<EOF > $tmpdir/results.$$
         0   0.0001953124997  
EOF
kasc2val -i1 $tmpdir/results.$$ -o $tmpdir/results.$$ -esize 2 -type 11
 
report $test_num "$tmpdir/stats.$$" "$tmpdir/results.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$
/bin/rm -f $tmpdir/out1.$$
/bin/rm -f $tmpdir/kernel.$$
/bin/rm -f $tmpdir/absdiff.$$
/bin/rm -f $tmpdir/stats.$$
/bin/rm -f $tmpdir/results.$$
 
# ------------------------------------------------------------------------
# Test  4: convolution theorem 2D data type Double Complex 
# ------------------------------------------------------------------------
test_num=4
descr="convolution theorem:  2D data type Double Complex"

kresample -resize 1 -inter 0 -i $dpath/ankle_complex.xv -wmag 0.25 -hmag 0.25 -o $tmpdir/out1.$$

kpad -i $tmpdir/out1.$$ -wsize 128 -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o $tmpdir/out1.$$ 

$bpath/klinearop -i1 $tmpdir/out1.$$ -i2 $tbpath/data/kernels/avg5x5.asc -w -h -o $tmpdir/out.$$ -flip 0 -size 0 -l -w0 0 -h0 0 -real 0 -imag 0

kfft -i $tmpdir/out1.$$ -dir 0 -scale 3 -o $tmpdir/out1.$$ -w -h

kpad -i $tbpath/data/kernels/avg5x5.asc -wsize 128  -hsize 128 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -real 0 -imag 0 -valid 1 -o  $tmpdir/kernel.$$

kfft -i  $tmpdir/kernel.$$ -dir 0 -scale 3 -o  $tmpdir/kernel.$$ -w -h

karith2 -mul -i1 $tmpdir/out1.$$ -i2  $tmpdir/kernel.$$ -o $tmpdir/out1.$$

kfft -i $tmpdir/out1.$$ -dir 1 -scale 1 -o $tmpdir/out1.$$ -w -h

kmag -i $tmpdir/out1.$$ -om $tmpdir/out1.$$ -mag 

kmag -i $tmpdir/out.$$ -om $tmpdir/out.$$ -mag 

karith2 -absdiff -i1 $tmpdir/out1.$$ -i2 $tmpdir/out.$$ -o $tmpdir/absdiff.$$
kstats -i $tmpdir/absdiff.$$ -o $tmpdir/stats.$$ -minval -maxval
cat <<EOF > $tmpdir/results.$$
2.433171176e-07   0.560110962  
EOF
kasc2val -i1 $tmpdir/results.$$ -o $tmpdir/results.$$ -esize 2 -type 11

report $test_num "$tmpdir/stats.$$" "$tmpdir/results.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$
/bin/rm -f $tmpdir/out1.$$
/bin/rm -f $tmpdir/kernel.$$
/bin/rm -f $tmpdir/absdiff.$$
/bin/rm -f $tmpdir/stats.$$
/bin/rm -f $tmpdir/results.$$

exit $status
