#! /bin/sh

echo "running test2.sh for kinset ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  inset data w, h, d, e on time 
# ------------------------------------------------------------------------

test_num=1a
descr="inset 1x3x3x1x4 data into 1x3x3x1x4 data -toff 1"

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
1 14 15 16 
1 17 18 19 
2 21 22 23
2 24 25 26
2 27 28 29
3 31 32 33
3 34 35 36 
3 37 38 39 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
4 41 42 43
4 44 45 46 
4 47 48 49 
5 51 52 53
5 54 55 56
5 57 58 59
6 61 62 63
6 64 65 66 
6 67 68 69 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input2.$$

kinset -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/result.$$ -toff 1

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
1 14 15 16 
1 17 18 19 
2 21 22 23
2 24 25 26
2 27 28 29
3 31 32 33
3 34 35 36 
3 37 38 39 
4 41 42 43
4 44 45 46 
4 47 48 49 
5 51 52 53
5 54 55 56
5 57 58 59
6 61 62 63
6 64 65 66 
6 67 68 69 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 4 -tsize 2 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/answer.$$

report $test_num "$tmpdir/result.$$" "$tmpdir/answer.$$" "$descr"

cat <<EOF > $tmpdir/ascii.$$
7 71 72 73
7 74 75 76 
7 77 78 79 
8 81 82 83
8 84 85 86
8 87 88 89
9 91 92 93
9 94 95 96 
9 97 98 99 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input3.$$

kinset -i1 $tmpdir/result.$$ -i2 $tmpdir/input3.$$ -o $tmpdir/result.$$ -toff 2

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
1 14 15 16 
1 17 18 19 
2 21 22 23
2 24 25 26
2 27 28 29
3 31 32 33
3 34 35 36 
3 37 38 39 
4 41 42 43
4 44 45 46 
4 47 48 49 
5 51 52 53
5 54 55 56
5 57 58 59
6 61 62 63
6 64 65 66 
6 67 68 69 
7 71 72 73
7 74 75 76 
7 77 78 79 
8 81 82 83
8 84 85 86
8 87 88 89
9 91 92 93
9 94 95 96 
9 97 98 99 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -esize 4 -tsize 3 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/answer.$$

test_num=1b
descr="inset 1x3x3x1x4 data into 1x3x3x2x4 data -toff 2"
report $test_num "$tmpdir/result.$$" "$tmpdir/answer.$$" "$descr"


# ------------------------------------------------------------------------
# Test  2:  
# ------------------------------------------------------------------------

test_num=2a
descr="inset 2x3x3x1x4 data into 2x3x3x1x4 data -toff 1"

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
13 12 11 1
1 14 15 16 
16 15 14 1
1 17 18 19 
19 18 17 1
2 21 22 23
23 22 21 2
2 24 25 26
26 25 24 2
2 27 28 29
29 28 27 2
3 31 32 33
33 32 31 3
3 34 35 36 
36 35 34 3
3 37 38 39 
39 38 37 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input1.$$
cat <<EOF > $tmpdir/ascii.$$
4 41 42 43
43 42 41 4
4 44 45 46 
46 45 44 4
4 47 48 49 
49 48 47 4
5 51 52 53
53 52 51 5
5 54 55 56
56 55 54 5
5 57 58 59
59 58 57 5
6 61 62 63
63 62 61 6
6 64 65 66 
66 65 64 6
6 67 68 69 
69 68 67 6
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input2.$$

kinset -i1 $tmpdir/input1.$$ -i2 $tmpdir/input2.$$ -o $tmpdir/result.$$ -toff 1

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
13 12 11 1
1 14 15 16 
16 15 14 1
1 17 18 19 
19 18 17 1
2 21 22 23
23 22 21 2
2 24 25 26
26 25 24 2
2 27 28 29
29 28 27 2
3 31 32 33
33 32 31 3
3 34 35 36 
36 35 34 3
3 37 38 39 
39 38 37 3
4 41 42 43
43 42 41 4
4 44 45 46 
46 45 44 4
4 47 48 49 
49 48 47 4
5 51 52 53
53 52 51 5
5 54 55 56
56 55 54 5
5 57 58 59
59 58 57 5
6 61 62 63
63 62 61 6
6 64 65 66 
66 65 64 6
6 67 68 69 
69 68 67 6
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -tsize 2 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/answer.$$

report $test_num "$tmpdir/result.$$" "$tmpdir/answer.$$" "$descr"

cat <<EOF > $tmpdir/ascii.$$
7 71 72 73
73 72 71 7
7 74 75 76 
76 75 74 7
7 77 78 79 
79 78 77 7
8 81 82 83
83 82 81 8
8 84 85 86
86 85 84 8
8 87 88 89
89 88 87 8
9 91 92 93
93 92 91 9
9 94 95 96 
96 95 94 9
9 97 98 99 
99 98 97 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/input3.$$

kinset -i1 $tmpdir/result.$$ -i2 $tmpdir/input3.$$ -o $tmpdir/result.$$ -toff 2

cat <<EOF > $tmpdir/ascii.$$
1 11 12 13
13 12 11 1
1 14 15 16 
16 15 14 1
1 17 18 19 
19 18 17 1
2 21 22 23
23 22 21 2
2 24 25 26
26 25 24 2
2 27 28 29
29 28 27 2
3 31 32 33
33 32 31 3
3 34 35 36 
36 35 34 3
3 37 38 39 
39 38 37 3
4 41 42 43
43 42 41 4
4 44 45 46 
46 45 44 4
4 47 48 49 
49 48 47 4
5 51 52 53
53 52 51 5
5 54 55 56
56 55 54 5
5 57 58 59
59 58 57 5
6 61 62 63
63 62 61 6
6 64 65 66 
66 65 64 6
6 67 68 69 
69 68 67 6
7 71 72 73
73 72 71 7
7 74 75 76 
76 75 74 7
7 77 78 79 
79 78 77 7
8 81 82 83
83 82 81 8
8 84 85 86
86 85 84 8
8 87 88 89
89 88 87 8
9 91 92 93
93 92 91 9
9 94 95 96 
96 95 94 9
9 97 98 99 
99 98 97 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -tsize 3 -dsize 3 -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5 -type byte -o $tmpdir/answer.$$

test_num=2b
descr="inset 2x3x3x1x4 data into 2x3x3x2x4 data -toff 2"
report $test_num "$tmpdir/result.$$" "$tmpdir/answer.$$" "$descr"

/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/input1.$$ $tmpdir/input2.$$ $tmpdir/input3.$$ $tmpdir/answer.$$

exit $status

