#! /bin/sh

echo "running test1.sh for kgconst ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  generation of 2x3x1x1x4 bit data -real 1
# ------------------------------------------------------------------------
test_num=1
descr="generation of 2x3x1x1x4 bit data -real 1"
kgconst -o $tmpdir/out.$$ -wsize 2 -hsize 3 -esize 4 -real 1 -type bit
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
1 1 1 1
1 1 1 1
1 1 1 1
1 1 1 1
1 1 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -type bit -o $tmpdir/answer.$$ -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  generation of 2x3x1x1x4 bit data -real -1
# ------------------------------------------------------------------------
test_num=2
descr="generation of 2x3x1x1x4 bit data -real -1"
kgconst -o $tmpdir/out.$$ -wsize 2 -hsize 3 -esize 4 -real -1 -type bit
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0
0 0 0 0
0 0 0 0
0 0 0 0
0 0 0 0
0 0 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 4 -type bit -o $tmpdir/answer.$$ -eindex 1 -windex 2 -hindex 3 -dindex 4 -tindex 5
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3:  generation of 2x3x4x2x1 byte data -real -5
# ------------------------------------------------------------------------
test_num=3
descr="generation of 2x3x4x2x1 byte data -real -5"
kgconst -o $tmpdir/out.$$ -wsize 2 -hsize 3 -dsize 4 -tsize 2 -real -5 -type byte
cat <<EOF > $tmpdir/ascii.$$
-5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5
-5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5 -5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -dsize 4 -tsize 2 -type byte -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4:  generation of 2x3x4x1x2 ubyte data -real 7
# ------------------------------------------------------------------------
test_num=4
descr="generation of 2x3x4x1x2 ubyte data -real 7"
kgconst -o $tmpdir/out.$$ -wsize 2 -hsize 3 -dsize 4 -esize 2 -real 7 -type "unsigned byte"
cat <<EOF > $tmpdir/ascii.$$
7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7
7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -dsize 4 -esize 2 -type "unsigned byte" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5:  generation of 4x3x4x1x1 short data -real 255
# ------------------------------------------------------------------------
test_num=5
descr="generation of generation of 4x3x4x1x1 short data -real 255"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 255 -type "short"
cat <<EOF > $tmpdir/ascii.$$
255 255 255 255 255 255 255 255 255 255 255 255 
255 255 255 255 255 255 255 255 255 255 255 255
255 255 255 255 255 255 255 255 255 255 255 255 
255 255 255 255 255 255 255 255 255 255 255 255
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "short" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  6:  generation of 4x3x4x1x1 unsigned short data -real 255
# ------------------------------------------------------------------------
test_num=6
descr="generation of generation of 4x3x4x1x1 unsigned short data -real 255"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 255 -type "unsigned short"
cat <<EOF > $tmpdir/ascii.$$
255 255 255 255 255 255 255 255 255 255 255 255 
255 255 255 255 255 255 255 255 255 255 255 255
255 255 255 255 255 255 255 255 255 255 255 255 
255 255 255 255 255 255 255 255 255 255 255 255
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "unsigned short" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  7:  generation of 4x3x4x1x1 integer data -real -113
# ------------------------------------------------------------------------
test_num=7
descr="generation of 4x3x4x1x1 integer data -real -113"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real -113 -type "integer"
cat <<EOF > $tmpdir/ascii.$$
-113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 
-113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 
-113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 
-113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 -113 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "integer" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  8:  generation of 4x3x4x1x1 unsigned integer data -real 113
# ------------------------------------------------------------------------
test_num=8
descr="generation of 4x3x4x1x1 unsigned integer data -real 113"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 113 -type "unsigned integer"
cat <<EOF > $tmpdir/ascii.$$
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "unsigned integer" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  9:  generation of 1x1x1x1x1 long data -real 113
# ------------------------------------------------------------------------
test_num=9
descr="generation of 1x1x1x1x1 long data -real 113"
kgconst -o $tmpdir/out.$$ -wsize 1 -real 113 -type "long"
cat <<EOF > $tmpdir/ascii.$$
113
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -type "long" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  10:  generation of 4x3x4x1x1 unsigned long data -real 113
# ------------------------------------------------------------------------
test_num=10
descr="generation of 4x3x4x1x1 unsigned long data -real 113"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 113 -type "unsigned long"
cat <<EOF > $tmpdir/ascii.$$
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
113 113 113 113 113 113 113 113 113 113 113 113 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "unsigned long" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  11:  generation of 4x3x4x1x1 float data -real 1.13
# ------------------------------------------------------------------------
test_num=11
descr="generation of 4x3x4x1x1 float data -real 1.13"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 1.13 -type "float"
cat <<EOF > $tmpdir/ascii.$$
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "float" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  12:  generation of 4x3x4x1x1 double data -real 1.13
# ------------------------------------------------------------------------
test_num=12
descr="generation of 4x3x4x1x1 float data -real 1.13"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 4 -real 1.13 -type "double"
cat <<EOF > $tmpdir/ascii.$$
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 1.13 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 4 -type "double" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  13:  generation of 4x3x2x1x1 complex data -real 1.13 -imag -3.21
# ------------------------------------------------------------------------
test_num=13
descr="generation of 4x3x2x1x1 complex data -real 1.13 -imag -3.21"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 2 -real 1.13 -imag -3.21 -type "complex"
cat <<EOF > $tmpdir/ascii.$$
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 2 -type "complex" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  14:  generation of 4x3x2x1x1 double complex data -real 1.13 -imag -3.21
# ------------------------------------------------------------------------
test_num=14
descr="generation of 4x3x2x1x1 double complex data -real 1.13 -imag -3.21"
kgconst -o $tmpdir/out.$$ -wsize 4 -hsize 3 -dsize 2 -real 1.13 -imag -3.21 -type "double complex"
cat <<EOF > $tmpdir/ascii.$$
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
(1.13, -3.21) (1.13, -3.21) (1.13, -3.21) (1.13, -3.21) 
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 3 -dsize 2 -type "double complex" -o $tmpdir/answer.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$ $tmpdir/ascii.$$

exit $status

