#! /bin/sh

echo "running test1.sh for kflip ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set data path for image data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/images"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
#  extract an unsigned byte reference image from moon.xv 
# ------------------------------------------------------------------------
kextract -i image:moon -o $tmpdir/ref.$$ -woff 40 -hoff 25 -wsize 128 -hsize 64 -subpos FALSE

# ------------------------------------------------------------------------
# Test  1:  unsigned byte image flipped along width
# ------------------------------------------------------------------------
test_num=1
descr="unsigned byte image flipped along width"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -w
report $test_num "$tmpdir/out.$$" "test1.results/flipmoon_w" "$descr"

# ------------------------------------------------------------------------
# Test  2:  unsigned byte image flipped along height
# ------------------------------------------------------------------------
test_num=2
descr="unsigned byte image flipped along height"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -h
report $test_num "$tmpdir/out.$$" "test1.results/flipmoon_h" "$descr"

# ------------------------------------------------------------------------
# Test  3:  unsigned byte image flipped along width & height
# ------------------------------------------------------------------------
test_num=3
descr="unsigned byte image flipped along width & height"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -w -h
report $test_num "$tmpdir/out.$$" "test1.results/flipmoon_wh" "$descr"

# ------------------------------------------------------------------------
#  extract a float reference image from spine.xv 
# ------------------------------------------------------------------------
kextract -i image:spine -o $tmpdir/ref.$$ -woff 110 -wsize 64 -hsize 128 -subpos FALSE

# ------------------------------------------------------------------------
# Test  4:  float image flipped along width 
# ------------------------------------------------------------------------
test_num=4
descr="float image flipped along width"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -w
report $test_num "$tmpdir/out.$$" "test1.results/flipspine_w" "$descr"

# ------------------------------------------------------------------------
# Test  5:  float data flipped on width twice and subtracted from ref
# ------------------------------------------------------------------------
test_num=5
descr="float data flipped on width twice and subtracted from ref"
kflip -i $tmpdir/out.$$ -o $tmpdir/out.$$ -w
karith2 -sub -i1 $tmpdir/ref.$$ -i2 $tmpdir/out.$$ -o $tmpdir/out.$$
kstats -i $tmpdir/out.$$ -all -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/flipspine_ww.stats" "$descr"

# ------------------------------------------------------------------------
# Test  6:  float image flipped along height
# ------------------------------------------------------------------------
test_num=6
descr="float image flipped along height"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -h
report $test_num "$tmpdir/out.$$" "test1.results/flipspine_h" "$descr"

# ------------------------------------------------------------------------
# Test  7:  float image flipped along width and height 
# ------------------------------------------------------------------------
test_num=7
descr="float image flipped along width and height"
kflip -i $tmpdir/ref.$$ -o $tmpdir/out.$$ -w -h
report $test_num "$tmpdir/out.$$" "test1.results/flipspine_wh" "$descr"

# ------------------------------------------------------------------------
#  set data path for 1D complex data
# ------------------------------------------------------------------------
dpath="$tbpath/data/signals"

# ------------------------------------------------------------------------
# Test  8:  1D complex data flipped along width
# ------------------------------------------------------------------------
test_num=8
descr="1D complex data flipped along width"
kflip -i $dpath/brain.c.xv -o $tmpdir/out.$$ -w
# ksegcmp cannot operate on complex data yet....
# report $test_num "$tmpdir/out.$$" "$dpath/brain.c.xv" "$descr"
kcmplx2real -i $tmpdir/out.$$ -om $tmpdir/out.$$ -mag 
report $test_num "$tmpdir/out.$$" "test1.results/brain.c.mag" "$descr"

# ------------------------------------------------------------------------
# Test  9:  1D complex data flipped along height
# ------------------------------------------------------------------------
test_num=9
descr="1D complex data flipped along height"
kflip -i $dpath/brain.c.xv -o $tmpdir/out.$$ -h
# ksegcmp cannot operate on complex data yet....
# report $test_num "$tmpdir/out.$$" "test1.results/flipsig_h" "$descr"
kcmplx2real -i $tmpdir/out.$$ -om $tmpdir/fout.$$ -mag 
report $test_num "$tmpdir/fout.$$" "test1.results/flipsig_h.mag" "$descr"

# ------------------------------------------------------------------------
# Test  10:  1D complex data flipped along height 2 times
# ------------------------------------------------------------------------
test_num=10
descr="1D complex data flipped along height 2 times"
kflip -i $tmpdir/out.$$ -o $tmpdir/out.$$ -h
# ksegcmp cannot operate on complex data yet....
# report $test_num "$tmpdir/out.$$" "$dpath/brain.c.xv" "$descr"
kcmplx2real -i $tmpdir/out.$$ -om $tmpdir/out.$$ -mag 
report $test_num "$tmpdir/out.$$" "test1.results/brain.c.mag" "$descr"

# ------------------------------------------------------------------------
# Test  11:  1D complex data flipped along height 2 times
# ------------------------------------------------------------------------
test_num=11
descr="1D complex data flipped along height 2 times"
kflip -i $dpath/brain.c.xv -o $tmpdir/out.$$ -w -h
# ksegcmp cannot operate on complex data yet....
# report $test_num "$tmpdir/out.$$" "test1.results/flipsig_h" "$descr"
kcmplx2real -i $tmpdir/out.$$ -om $tmpdir/out.$$ -mag
report $test_num "$tmpdir/out.$$" "test1.results/flipsig_h.mag" "$descr"

# ------------------------------------------------------------------------
#  set data path for datamanip toolbox testdata
# ------------------------------------------------------------------------
tbpath=`kecho -tb datamanip -echo path`
dpath="$tbpath/data/testdata"

# ------------------------------------------------------------------------
# Test  12:  value and mask data flipped along width
# ------------------------------------------------------------------------
test_num=12
descr="value and mask data flipped along width"
kflip -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -w
report $test_num "$tmpdir/out.$$" "test1.results/flip4x2vm_w" "$descr"

# ------------------------------------------------------------------------
# Test  13:  value and mask data flipped along height
# ------------------------------------------------------------------------
test_num=13
descr="value and mask data flipped along height"
kflip -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -h
report $test_num "$tmpdir/out.$$" "test1.results/flip4x2vm_h" "$descr"

# ------------------------------------------------------------------------
# Test  14:  value and mask data flipped along width and height
# ------------------------------------------------------------------------
test_num=14
descr="value and mask data flipped along width and height"
kflip -i $dpath/4x2masked.float.viff -o $tmpdir/out.$$ -w -h
report $test_num "$tmpdir/out.$$" "test1.results/flip4x2vm_wh" "$descr"

/bin/rm -f $tmpdir/out.$$ $tmpdir/fout.$$ $tmpdir/stats.$$ $tmpdir/ref.$$

exit $status
