#! /bin/sh 

echo "testing kcmplx2real  ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
datapath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  4x3cmplx.xv -or -oi -om -op
# ------------------------------------------------------------------------
test_num=1a
kcmplx2real -i $datapath/4x3cmplx.xv -or $tmpdir/real.$$ -oi \
$tmpdir/imag.$$ -mag -om $tmpdir/mag.$$ -op $tmpdir/phase.$$ 
descr="real output:  4x3cmplx.xv"
report $test_num "$tmpdir/real.$$" "test1.results/4x3r_c-f" "$descr"
test_num=1b
descr="imaginary output:  4x3cmplx.xv"
report $test_num "$tmpdir/imag.$$" "test1.results/4x3i_c-f" "$descr"
test_num=1c
descr="magnitude output:  4x3cmplx.xv"
report $test_num "$tmpdir/mag.$$" "test1.results/4x3m_c-f" "$descr"
test_num=1d
descr="phase output:  4x3cmplx.xv"
report $test_num "$tmpdir/phase.$$" "test1.results/4x3p_c-f" "$descr"
/bin/rm -f $tmpdir/real.$$ $tmpdir/imag.$$ $tmpdir/mag.$$ $tmpdir/phase.$$

# ------------------------------------------------------------------------
# Test  2:  magnitude tests on 4x3cmplx.xv 
# ------------------------------------------------------------------------
echo "         Test  2  --> magnitude tests on 4x3cmplx.xv . . ."

karith2 -i1 $datapath/4x3cmplx.xv -add -real 1 -imag 1 -o $tmpdir/temp.$$
# to run from command line
# karith2 -i1 ~/datamanip/data/testdata/4x3cmplx.xv -add -real 1 -imag 1 -o temp

test_num=2a
kcmplx2real -i $datapath/4x3cmplx.xv -om $tmpdir/out.$$ -logmag1
descr="log (magnitude + 1)"
report $test_num "$tmpdir/out.$$" "test1.results/4x3lm1_c-f" "$descr"

test_num=2b
kcmplx2real -i $tmpdir/temp.$$ -om $tmpdir/out.$$ -logmag
descr="log (magnitude)"
report $test_num "$tmpdir/out.$$" "test1.results/4x3lm_c-f" "$descr"
# to run from command line
# kcmplx2real -i temp -om out -logmag

test_num=2c
kcmplx2real -i $datapath/4x3cmplx.xv -om $tmpdir/out.$$ -magsq
descr="magnitude squared"
report $test_num "$tmpdir/out.$$" "test1.results/4x3msq_c-f" "$descr"
# to run from command line
# kcmplx2real -i ~/datamanip/data/testdata/4x3cmplx.xv -om out -magsq

test_num=2d
kcmplx2real -i $datapath/4x3cmplx.xv -om $tmpdir/out.$$ -logmagsq1
descr="log (magnitude squared + 1)"
report $test_num "$tmpdir/out.$$" "test1.results/4x3lmsq1_c-f" "$descr"
# to run from command line
# kcmplx2real -i ~/datamanip/data/testdata/4x3cmplx.xv -om out -logmagsq1

test_num=2e
kcmplx2real -i  $tmpdir/temp.$$ -om $tmpdir/out.$$ -logmagsq
descr="log (magnitude squared)"
report $test_num "$tmpdir/out.$$" "test1.results/4x3lmsq_c-f" "$descr"

/bin/rm $tmpdir/temp.$$ $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  test conversion of data with mask
# ------------------------------------------------------------------------
echo "         Test  3  --> test conversion of data with mask . . ."

# create and import the complex value data
cat <<EOF > $tmpdir/ascii.$$
(-1, 1) 
(2, 3)
(57, -8) 
(4, 14.3)
(65536, 0) 
(-.6666, 14)
(1, -1) 
(-2, -3)
(-57, 8) 
(-4, -14.3)
(-65536, -0) 
(.6666, -14)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 2 -type 12 -o $tmpdir/data.$$

# create and import the mask data
cat <<EOF > $tmpdir/ascii_mask.$$
1
0
1
0
1
0
0
1
0
1
0
1
EOF
kasc2mask -i1 $tmpdir/ascii_mask.$$ -wsize 2 -hsize 3 -esize 2 -type Byte -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

kcmplx2real -i $tmpdir/data.$$ -or $tmpdir/r.$$ -oi $tmpdir/i.$$

# create real comparision data
cat <<EOF > $tmpdir/ascii.$$
-1
2
57
4
65536
-.6666
1
-2
-57
-4
-65536
.6666
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 2 -type Float -o $tmpdir/data.$$
kasc2mask -i1 $tmpdir/ascii_mask.$$ -wsize 2 -hsize 3 -esize 2 -type Byte -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

test_num=3a
descr="real output"
report $test_num "$tmpdir/r.$$" "$tmpdir/data.$$" "$descr"

# create imaginary comparision data
cat <<EOF > $tmpdir/ascii.$$
1
3
-8
14.3
0
14
-1 
-3
8 
-14.3
-0 
-14
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -esize 2 -type Float -o $tmpdir/data.$$
kasc2mask -i1 $tmpdir/ascii_mask.$$ -wsize 2 -hsize 3 -esize 2 -type Byte -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

test_num=3b
descr="imaginary output"
report $test_num "$tmpdir/i.$$" "$tmpdir/data.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/ascii.$$ $tmpdir/ascii_mask.$$ 
/bin/rm -f $tmpdir/r.$$ $tmpdir/i.$$ 


# ------------------------------------------------------------------------
# Test  4:  test conversion of real data with complex map
# ------------------------------------------------------------------------
echo "         Test  4  --> test conversion of real data with complex map . . ."

# create and import complex map data
cat <<EOF > $tmpdir/ascii.$$
(-1,  1)  (-2,  2)  (-3,  3)
(57, -8)  (58, -9)  (59, -10)
(36,  0)  (37,  1)  (38,  2)
(-2, -3)  (-3, -4)  (-4, -5)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type Complex -o $tmpdir/data.$$
kcmplx2real -i $tmpdir/data.$$ -om $tmpdir/mapmag.$$ -mag

# create and import the real value data
cat <<EOF > $tmpdir/ascii.$$
3
2
1
0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -type Short -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

kcmplx2real -i $tmpdir/data.$$ -om $tmpdir/mag.$$ -mag

# create and import magnitude comparision map data
cat <<EOF > $tmpdir/ascii.$$
 1.41421   2.82843   4.24264
57.55867  58.69412  59.84146
36        37.01351  38.05260
 3.60555   5         6.40312
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type Float -o $tmpdir/data.$$

test_num=4a
descr="magnitude of object with map only"
report $test_num "$tmpdir/mapmag.$$" "$tmpdir/data.$$" "$descr"

# create and import the real value data
cat <<EOF > $tmpdir/ascii.$$
3
2
1
0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -type Short -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

test_num=4b
descr="magnitude of object with map and value data"
report $test_num "$tmpdir/mag.$$" "$tmpdir/data.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/ascii.$$ $tmpdir/mag.$$ $tmpdir/mapmag.$$


# ------------------------------------------------------------------------
# Test  5:  test conversion of complex data with complex map ...
# ------------------------------------------------------------------------
echo "         Test  5  --> test conversion of complex data with complex map . . ."

# create and import complex map data
cat <<EOF > $tmpdir/ascii.$$
(-1,  1)  (-2,  2)  (-3,  3)
(57, -8)  (58, -9)  (59, -10)
(36,  0)  (37,  1)  (38,  2)
(-2, -3)  (-3, -4)  (-4, -5)
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type Complex -o $tmpdir/data.$$
kcmplx2real -i $tmpdir/data.$$ -om $tmpdir/mapmag.$$ -mag

# create and import the real value data
cat <<EOF > $tmpdir/ascii.$$
(3, -3)
(-2,3)
(1, -1)
(0, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -type Short -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

kcmplx2real -i $tmpdir/data.$$ -om $tmpdir/mag.$$ -mag

# create and import magnitude comparision map data
cat <<EOF > $tmpdir/ascii.$$
 1.41421   2.82843   4.24264
57.55867  58.69412  59.84146
36        37.01351  38.05260
 3.60555   5         6.40312
EOF
kasc2map -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 4 -type Float -o $tmpdir/data.$$

test_num=5a
descr="magnitude of object with map only"
report $test_num "$tmpdir/mapmag.$$" "$tmpdir/data.$$" "$descr"

# create and import the real value data
cat <<EOF > $tmpdir/ascii.$$
(3, -3)
(-2,3)
(1, -1)
(0, 0)
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -type Short -i2 $tmpdir/data.$$ -o $tmpdir/data.$$

test_num=5b
descr="magnitude of object with map and value data"
report $test_num "$tmpdir/mag.$$" "$tmpdir/data.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/ascii.$$ $tmpdir/mag.$$ $tmpdir/mapmag.$$

# ------------------------------------------------------------------------
# Test  6:  test real input data file
# ------------------------------------------------------------------------
echo "         Test  6  --> testing real input data file . . ."

# create and import real data 
cat <<EOF > $tmpdir/ascii.$$
-1  1 -2  2
57 -8  58 -9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 2 -wsize 4 -type Float -o $tmpdir/data.$$
kcmplx2real -i $tmpdir/data.$$ -om $tmpdir/m.$$ -mag -or $tmpdir/r.$$ -oi $tmpdir/i.$$ -op $tmpdir/p.$$

test_num=6a
descr="real output"
report $test_num "$tmpdir/r.$$" "$tmpdir/data.$$" "$descr"

# create and import magnitude output
cat <<EOF > $tmpdir/ascii.$$
1  1 2  2
57 8  58 9
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 2 -wsize 4 -type Float -o $tmpdir/data.$$

test_num=6b
descr="magnitude output"
report $test_num "$tmpdir/m.$$" "$tmpdir/data.$$" "$descr"

# create and import imaginary output
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0
0 0 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 2 -wsize 4 -type Float -o $tmpdir/data.$$

test_num=6c
descr="imaginary output"
report $test_num "$tmpdir/i.$$" "$tmpdir/data.$$" "$descr"

# create and import imaginary output
cat <<EOF > $tmpdir/ascii.$$
3.141592741 0 3.141592741 0
0 3.141592741 0 3.141592741
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 2 -wsize 4 -type Float -o $tmpdir/data.$$

test_num=6d
descr="phase output"
report $test_num "$tmpdir/p.$$" "$tmpdir/data.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/ascii.$$ $tmpdir/r.$$ $tmpdir/i.$$
/bin/rm $tmpdir/m.$$ $tmpdir/p.$$

exit $status
