#! /bin/sh

echo "running test1.sh for kclip ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  clip: 3x4 double, -uc 21 -lc 3
# ------------------------------------------------------------------------
test_num=1
descr="clip: 3x4 double, -uc 21 -lc 3"
kclip -i $dpath/3x4.double.viff -o $tmpdir/out.$$ -lc 3 -uc 21
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_uc21_lc3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.double.viff -o junk -lc 3 -uc 21

# ------------------------------------------------------------------------
# Test  2:  clip: 3x4 double, -uc 21 -lc 3 -tval 75 -fval 400 
# ------------------------------------------------------------------------
test_num=2
descr="clip: 3x4 double, -uc 21 -lc 3 -tval 75 -fval 400"
kclip -i $dpath/3x4.double.viff -o $tmpdir/out.$$ -lc 3 -uc 21 -tval 75 -fval 400
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_uc21_lc3_tv75_fv400" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.double.viff -o junk -lc 3 -uc 21 -tval 75 -fval 400

# ------------------------------------------------------------------------
# Test  3:  clip: 3x4 double, -lc 21 -uc 3 -tval 75 -fval 400 
# ------------------------------------------------------------------------
test_num=3
descr="clip: 3x4 double, -lc 21 -uc 3 -tval 75 -fval 400"
kclip -i $dpath/3x4.double.viff -o $tmpdir/out.$$ -uc 3 -lc 21 -tval 75 -fval 400
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_lc21_uc3_tv75_fv400" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.double.viff -o junk -uc 3 -lc 21 -tval 75 -fval 400

# ------------------------------------------------------------------------
# Test  4:  thresh: 3x4 int, -lc 21 -uc 3 -tval 75 -fval 400 
# ------------------------------------------------------------------------
test_num=4
descr="thresh: 3x4 int, -lc 21 -uc 3 -tval 75 -fval 400"
kclip -i $dpath/3x4.int.viff -o $tmpdir/out.$$ -uc 3 -lc 21 -tval 75 -fval 400 -thresh 1
report $test_num "$tmpdir/out.$$" "test1.results/thresh3x4iv_lc21_uc3_tv75_fv400" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.int.viff -o junk -uc 3 -lc 21 -tval 75 -fval 400 -thresh 1

# ------------------------------------------------------------------------
# Test  5:  thresh: val & map, index out of range, -uc 12 -lc 41.5
# ------------------------------------------------------------------------
test_num=5
descr="thresh: val & map, index out of range, -uc 12 -lc 41.5"
kclip -i $dpath/2x5ival_6x3fmap.viff -o $tmpdir/out.$$ -uc 12 -lc 41.5 -thresh 1
report $test_num "$tmpdir/out.$$" "test1.results/thresh2x5ivfm_uc12_lc41.5" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/2x5ival_6x3fmap.viff -o junk -uc 12 -lc 41.5 -thresh 1

# ------------------------------------------------------------------------
# Test  6:  clip: val & map, index out of range, -lc -20 -uc 30.1 -tval 17
# ------------------------------------------------------------------------
test_num=6
descr="clip: val & map, index out of range, -lc -20 -uc 30.1 -tval 17"
kclip -i $dpath/2x5ival_6x3fmap.viff -o $tmpdir/out.$$ -lc -20 -uc 30.1 -tval 17
report $test_num "$tmpdir/out.$$" "test1.results/clip2x5ivfm_lc-20_uc30.1" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/2x5ival_6x3fmap.viff -o junk -lc -20 -uc 30.1 -tval 17

# ------------------------------------------------------------------------
# Test  7:  clip: 3x4 -lc 2 -iuc 3x4.float.const10.3.viff 
# ------------------------------------------------------------------------
test_num=7
descr="clip: 3x4 -lc 2 -iuc 3x4.float.const10.3.viff"
kclip -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -lc 2 -iuc $dpath/3x4.float.const10.3.viff 
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_lc2_iuc3x4c10.3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.float.viff -lc 2 -iuc ~/datamanip/data/testdata/3x4.float.const10.3.viff -o junk

# ------------------------------------------------------------------------
# Test  8:  clip: 3x4 -lc 1.5 -iuc 4x3.float.const10.3.viff -fval 300 -tval 200
# ------------------------------------------------------------------------
test_num=8
descr="clip: 3x4 -lc 1.5 -iuc 4x3.float.const10.3.viff -fval 300 -tval 200"
kclip -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -lc 1.5 -iuc $dpath/4x3.float.const10.3.viff -fval 300 -tval 200
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_lc1.5_iuc4x3c10.3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.float.viff -lc 1.5 -iuc ~/datamanip/data/testdata/4x3.float.const10.3.viff -o junk -fval 300 -tval 200

# ------------------------------------------------------------------------
# Test  9:  clip: 3x4 -uc 21 -ilc 3x4.float.const10.3.viff -fval 300 -tval 200
# ------------------------------------------------------------------------
test_num=9
descr="clip: 3x4 -uc 21 -ilc 3x4.float.const10.3.viff -fval 300 -tval 200"
kclip -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -uc 21 -ilc $dpath/4x3.float.const10.3.viff -fval 300 -tval 200
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_uc21_ilc4x3c10.3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.float.viff -uc 21 -ilc ~/datamanip/data/testdata/4x3.float.const10.3.viff -o junk -fval 300 -tval 200

# ------------------------------------------------------------------------
# Test 10:  clip: 3x4 -iuc & -ilc 3x4.float.const10.3.viff -fval 100 -tval 200
# ------------------------------------------------------------------------
test_num=10
descr="clip: 3x4 -iuc & -ilc 3x4.float.const10.3.viff -fval 100 -tval 200"
kclip -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -ilc $dpath/3x4.float.const10.3.viff -iuc $dpath/3x4.float.const10.3.viff -fval 100 -tval 200
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_iuc_ilc3x4c10.3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.float.viff -ilc ~/datamanip/data/testdata/3x4.float.const10.3.viff -iuc ~/datamanip/data/testdata/3x4.float.const10.3.viff -o junk -fval 100 -tval 200

# ------------------------------------------------------------------------
# Test 11:  thresh: 3x4 -uc 21 -ilc 3x4.float.const10.3.viff -fval 300 -tval 200
# ------------------------------------------------------------------------
test_num=11
descr="thresh: 3x4 -uc 21 -ilc 3x4.float.const10.3.viff -fval 300 -tval 200"
kclip -i $dpath/3x4.float.viff -o $tmpdir/out.$$ -uc 21 -ilc $dpath/3x4.float.const10.3.viff -fval 300 -tval 200 -thresh 1
report $test_num "$tmpdir/out.$$" "test1.results/thresh3x4dv_uc21_ilc3x4c10.3" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4.float.viff -uc 21 -ilc ~/datamanip/data/testdata/3x4.float.const10.3.viff -o junk -fval 300 -tval 200 -thresh 1

# ------------------------------------------------------------------------
# Test 12:  clip: 2 inputs with map and value - ilc indexes out of map
# ------------------------------------------------------------------------
test_num=12
descr="clip: 2 inputs with map and value - ilc indexes out of map"
kclip -i $dpath/2x3ival_6x3fmap.viff -o $tmpdir/out.$$ -ilc $dpath/2x5ival_6x3fmap.viff 
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dv_ilc2x5v6x3m" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/2x3ival_6x3fmap.viff -ilc ~/datamanip/data/testdata/2x5ival_6x3fmap.viff -o junk

# ------------------------------------------------------------------------
# Test 13:  thresh: -i has val, -iuc has val & mask
# ------------------------------------------------------------------------
test_num=13
descr="thresh: -i has val, -iuc has val & mask"
kclip -i $dpath/2x3.float.xv -o $tmpdir/out.$$ -iuc $dpath/3x4masked.byte.viff -thresh 1
report $test_num "$tmpdir/out.$$" "test1.results/thresh2x3fv_iuc3x4bmk" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/2x3.float.xv -iuc ~/datamanip/data/testdata/3x4masked.byte.viff -o junk -thresh 1

# ------------------------------------------------------------------------
# Test 14:  clip: -i has val & mask, -iuc has val and must pad
# ------------------------------------------------------------------------
test_num=14
descr="clip: -i has val & mask, -iuc has val and must pad"
kclip -i $dpath/3x4masked.double.viff -o $tmpdir/out.$$ -iuc $dpath/2x3.float.xv
report $test_num "$tmpdir/out.$$" "test1.results/clip3x4dmk_iuc2x3f" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/3x4masked.double.viff -iuc ~/datamanip/data/testdata/2x3.float.xv -o junk

# ------------------------------------------------------------------------
# Test 15:  thresh: complex value data, -uc 25 -lc -8 -fval 0.07
# ------------------------------------------------------------------------
test_num=15
descr="thresh: complex value data, -uc 25 -lc -8 -fval 0.07"

kclip -i $dpath/4x3cmplx.xv -o $tmpdir/out.$$ -uc 25 -lc -8 -fval 0.07 -thresh 1
report $test_num "$tmpdir/out.$$" "test1.results/thresh4x3cv_uc25lc-8fval.07" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/4x3cmplx.xv -uc 25 -lc -8 -fval 0.07 -thresh 1 -o junk

# ------------------------------------------------------------------------
# Test 16:  clip: complex data, -uc 3x4.double.viff -lc -1 
# ------------------------------------------------------------------------
test_num=16
descr="clip: complex data, -uc 3x4.double.viff -lc -1"

kclip -i $dpath/4x3cmplx.xv -o $tmpdir/out.$$ -iuc $dpath/3x4.double.viff -lc -1
report $test_num "$tmpdir/out.$$" "test1.results/clip4x3cv_iuc3x4d_lc-1" "$descr"
/bin/rm -f $tmpdir/out.$$
# to run, use following command line
# kclip -i ~/datamanip/data/testdata/4x3cmplx.xv -iuc ~/datamanip/data/testdata/3x4.double.viff -lc -1 -o junk
exit $status
