#! /bin/sh

echo "running test1d.sh for karith1 ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num="$1"
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}


# ------------------------------------------------------------------------
# Test  46:  floor - float value data with no map
# ------------------------------------------------------------------------
test_num=46
descr="floor - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.99
-0.99 1.01
-1.01 1.0001e-5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -floor
cat <<EOF > $tmpdir/ascii.$$
0 0
-1 1
-2 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  47:  trunc - float value data with no map
# ------------------------------------------------------------------------
test_num=47
descr="trunc - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.99
-0.99 1.01
-1.01 1.0001e-5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -trunc
cat <<EOF > $tmpdir/ascii.$$
0 0
0 1
-1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  48:  fract - float value data with no map
# ------------------------------------------------------------------------
test_num=48
descr="fract - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.99
-0.99 1.01
-1.01 1.0001e-5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -fract
cat <<EOF > $tmpdir/ascii.$$
0 0.99
-0.99 0.01
-0.01 1.0001e-5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  49:  lgamma - float value data with no map
# ------------------------------------------------------------------------
test_num=49
descr="lgamma - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0.01
0.5
1
5
2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 5 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -lgamma
cat <<EOF > $tmpdir/ascii.$$
4.5994796
0.5723649
0
3.17805538
0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 5 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  50:  erf - float value data with no map
# ------------------------------------------------------------------------
test_num=50
descr="erf - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0
0.5
2
1e6
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 4 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -erf
cat <<EOF > $tmpdir/ascii.$$
0
0.520499885
0.9953222871
1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  51:  erfc - float value data with no map
# ------------------------------------------------------------------------
test_num=51
descr="erfc - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0
0.5
2
1e6
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 4 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -erfc
cat <<EOF > $tmpdir/ascii.$$
1
0.4795001149
0.004677734803
0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  52:  set - signed short value data with no map
# ------------------------------------------------------------------------
test_num=52
descr="set - signed short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -set
cat <<EOF > $tmpdir/ascii.$$
-1 -1
-1 -1
-1 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  53:  set - signed int value data with no map
# ------------------------------------------------------------------------
test_num=53
descr="set - signed int data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -set
cat <<EOF > $tmpdir/ascii.$$
-1 -1
-1 -1
-1 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  54:  clear - signed short value data with no map
# ------------------------------------------------------------------------
test_num=54
descr="clear - signed short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -clear
cat <<EOF > $tmpdir/ascii.$$
0 0
0 0
0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  55:  clear - signed int value data with no map
# ------------------------------------------------------------------------
test_num=55
descr="clear - signed int data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -clear
cat <<EOF > $tmpdir/ascii.$$
0 0
0 0
0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  56:  clear - float value data with no map
# ------------------------------------------------------------------------
test_num=56
descr="clear - float data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1.4
-127 0.01
-32767.05 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -clear
cat <<EOF > $tmpdir/ascii.$$
0 0
0 0
0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  57:  not - signed short value data with no map
#
# This one does two not's in a row, hopefully obtaining the same data back.
# The reason for this that there is otherwise no way to put the right
# values in the result file since those values will be architecture
# dependent with the number of bits in a long int. Scott Wilson 8 July 1994
# ------------------------------------------------------------------------
test_num=57
descr="not - signed short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -not
karith1 -i $tmpdir/out.$$ -o $tmpdir/out.$$ -not
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  58:  not - signed int value data with no map
#
# This one does two not's in a row, hopefully obtaining the same data back.
# The reason for this that there is otherwise no way to put the right
# values in the result file since those values will be architecture
# dependent with the number of bits in a long int. Scott Wilson 8 July 1994
# ------------------------------------------------------------------------
test_num=58
descr="not - signed int data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -not
karith1 -i $tmpdir/out.$$ -o $tmpdir/out.$$ -not
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 0
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 6 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  59:  not - BIT data with no map
#
# ------------------------------------------------------------------------
test_num=59
descr="not - BIT data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1
1 0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -not
cat <<EOF > $tmpdir/ascii.$$
0 1 0 1 0 1 0 1
1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  60:  clear - BIT data with no map
#
# ------------------------------------------------------------------------
test_num=60
descr="clear - BIT data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1
1 0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -clear
cat <<EOF > $tmpdir/ascii.$$
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 0 0 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  61:  set - BIT data with no map
#
# ------------------------------------------------------------------------
test_num=61
descr="set - BIT data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 0 1 0 1 0 1 0
0 1 0 1 0 1 0 1
1 0 1 0 1 0 1 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -set
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 8 -hsize 3 -type 1 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

