 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kstats.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kstats_get_args
| 
|       Purpose: Gets command line args for kstats
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kstats
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kstats_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kstats is out of sync with arguments specified in kstats's *.pane file; please rerun ghostwriter on kstats.";


	/*
	 * allocate the kstats structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "igate",
			  &(clui_info->igate_file),
			  &(clui_info->igate_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "f",
			  &(clui_info->f_file),
			  &(clui_info->f_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "whole",
			  &(clui_info->whole_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "w",
			  &(clui_info->w_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "h",
			  &(clui_info->h_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "d",
			  &(clui_info->d_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "t",
			  &(clui_info->t_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "e",
			  &(clui_info->e_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "all",
			  &(clui_info->all_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mean",
			  &(clui_info->mean_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "sum",
			  &(clui_info->sum_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "var",
			  &(clui_info->var_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wmin",
			  &(clui_info->wmin_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "psum",
			  &(clui_info->psum_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "sd",
			  &(clui_info->sd_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hmin",
			  &(clui_info->hmin_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "nsum",
			  &(clui_info->nsum_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "rms",
			  &(clui_info->rms_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dmin",
			  &(clui_info->dmin_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "pts",
			  &(clui_info->pts_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "skew",
			  &(clui_info->skew_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "tmin",
			  &(clui_info->tmin_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ppts",
			  &(clui_info->ppts_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "kur",
			  &(clui_info->kur_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "emin",
			  &(clui_info->emin_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "npts",
			  &(clui_info->npts_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "minval",
			  &(clui_info->minval_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "zpts",
			  &(clui_info->zpts_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "maxval",
			  &(clui_info->maxval_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wmax",
			  &(clui_info->wmax_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "wsize",
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hmax",
			  &(clui_info->hmax_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hsize",
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dmax",
			  &(clui_info->dmax_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "dsize",
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "tmax",
			  &(clui_info->tmax_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "tsize",
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "emax",
			  &(clui_info->emax_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "esize",
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kstats_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



