 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ksetdattr
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ksetdattr.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Modify Data Object Attributes
|
|       Purpose: main program for ksetdattr
|
|         Input:
|		char *clui_info->i_file; {First Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int   clui_info->maskpres_list; {Set the KPDS_MASKED_VALUE_PRESENTATION attribute}
|		char *clui_info->maskpres_label;
|		int   clui_info->maskpres_flag; {TRUE if -maskpres specified}
|
|		double clui_info->wbegin_double; {Explicit Location Begin for width dimension}
|		int    clui_info->wbegin_flag; {TRUE if -wbegin specified}
|
|		double clui_info->wend_double; {Explicit Location End for width dimension}
|		int    clui_info->wend_flag; {TRUE if -wend specified}
|
|		double clui_info->hbegin_double; {Explicit Location Begin for height dimension}
|		int    clui_info->hbegin_flag; {TRUE if -hbegin specified}
|
|		double clui_info->hend_double; {Explicit Location End for height dimension}
|		int    clui_info->hend_flag; {TRUE if -hend specified}
|
|		double clui_info->dbegin_double; {Explicit Location Begin for depth dimension}
|		int    clui_info->dbegin_flag; {TRUE if -dbegin specified}
|
|		double clui_info->dend_double; {Explicit Location End for depth dimension}
|		int    clui_info->dend_flag; {TRUE if -dend specified}
|
|		int clui_info->wpos_int; {Sub-object width position with respect to parent object}
|		int clui_info->wpos_flag; {TRUE if -wpos specified}
|
|		double clui_info->wpsize_double; {World coordinate point size in width dimension}
|		int    clui_info->wpsize_flag; {TRUE if -wpsize specified}
|
|		int clui_info->hpos_int; {Sub-object height position with respect to parent object}
|		int clui_info->hpos_flag; {TRUE if -hpos specified}
|
|		double clui_info->hpsize_double; {World coordinate point size in height dimension}
|		int    clui_info->hpsize_flag; {TRUE if -hpsize specified}
|
|		int clui_info->dpos_int; {Sub-object depth position with respect to parent object}
|		int clui_info->dpos_flag; {TRUE if -dpos specified}
|
|		double clui_info->dpsize_double; {World coordinate point size in depth dimension}
|		int    clui_info->dpsize_flag; {TRUE if -dpsize specified}
|
|		int clui_info->tpos_int; {Sub-object time position with respect to parent object}
|		int clui_info->tpos_flag; {TRUE if -tpos specified}
|
|		double clui_info->tpsize_double; {World coordinate point size in time dimension}
|		int    clui_info->tpsize_flag; {TRUE if -tpsize specified}
|
|		int clui_info->epos_int; {Sub-object elements position with respect to parent object}
|		int clui_info->epos_flag; {TRUE if -epos specified}
|
|		double clui_info->epsize_double; {World coordinate point size in elements dimension}
|		int    clui_info->epsize_flag; {TRUE if -epsize specified}
|
|		int   clui_info->cspace_list; {Set the KCOLOR_COLORSPACE attribute}
|		char *clui_info->cspace_label;
|		int   clui_info->cspace_flag; {TRUE if -cspace specified}
|
|		int   clui_info->alpha_list; {Set the KCOLOR_HAS_ALPHA attribute}
|		char *clui_info->alpha_label;
|		int   clui_info->alpha_flag; {TRUE if -alpha specified}
|
|		Loose group:
|		    double clui_info->rmasksub_double; {Set the real component of the KPDS_MASK_SUBSTITUTE_VALUE attribute }
|		    int    clui_info->rmasksub_flag; {TRUE if -rmasksub specified}
|
|		    double clui_info->imasksub_double; {Set the imaginary component of the KPDS_MASK_SUBSTITUTE_VALUE attribute }
|		    int    clui_info->imasksub_flag; {TRUE if -imasksub specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject src_obj=NULL, dst_obj=NULL;
	int     create_location = FALSE;
	int     grid;
	double	wpsize=1, hpsize=1, dpsize=1, tpsize=1, epsize=1;
	int	wpos=0, hpos=0, dpos=0, tpos=0, epos=0;
	double	wbeg=0, hbeg=0, dbeg=0;
	double	wend=0, hend=0, dend=0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(ksetdattr_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "ksetdattr",
		ksetdattr_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ksetdattr_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         *  Open the input and output data objects.
         */
        if ((src_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("ksetdattr","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
 
        if ((dst_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
        {
           kerror("ksetdattr","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

	/* 
	 *  Set specified masked data presentation attributes.
	 */
	if (clui_info->maskpres_flag)
	{
	   if (!kpds_set_attribute(src_obj, KPDS_MASKED_VALUE_PRESENTATION, 
			clui_info->maskpres_list))
           {
              kerror("ksetdattr","main", 
		     "Unable to set KPDS_MASKED_VALUE_PRESENTATION to %s.",
		     clui_info->maskpres_label);
              kexit(KEXIT_FAILURE);
           }
	}
	if (clui_info->rmasksub_flag || clui_info->imasksub_flag)
	{
	   if (!kpds_set_attribute(src_obj, KPDS_MASK_SUBSTITUTE_VALUE, 
			clui_info->rmasksub_double, clui_info->imasksub_double))
           {
              kerror("ksetdattr","main", 
		     "Unable to set KPDS_MASK_SUBSTITUTE_VALUE to (%g, %g).",
		     clui_info->rmasksub_double, clui_info->imasksub_double);
              kexit(KEXIT_FAILURE);
           }
	}

	/* 
	 *  Set world coordinate point size attribute if specified.
	 */
	if (clui_info->wpsize_flag || clui_info->hpsize_flag || 
	    clui_info->dpsize_flag || clui_info->tpsize_flag ||
	    clui_info->epsize_flag)
	{
	   kpds_get_attribute(src_obj, KPDS_POINT_SIZE,
			&wpsize, &hpsize, &dpsize, &tpsize, &epsize);
	   if (clui_info->wpsize_flag)	wpsize = clui_info->wpsize_double;
	   if (clui_info->hpsize_flag)	hpsize = clui_info->hpsize_double;
	   if (clui_info->dpsize_flag)	dpsize = clui_info->dpsize_double;
	   if (clui_info->tpsize_flag)	tpsize = clui_info->tpsize_double;
	   if (clui_info->epsize_flag)	epsize = clui_info->epsize_double;

	   if (!kpds_set_attribute(src_obj, KPDS_POINT_SIZE, 
			wpsize, hpsize, dpsize, tpsize, epsize))
           {
              kerror("ksetdattr","main", 
		     "Unable to set KPDS_POINT_SIZE to (%g,%g,%g,%g,%g).",
			wpsize, hpsize, dpsize, tpsize, epsize);
              kexit(KEXIT_FAILURE);
           }
	}

	/* 
	 *  Set location begin and/or end attributes, if specified.
	 */
	if (clui_info->wbegin_flag || clui_info->hbegin_flag || 
	    clui_info->dbegin_flag || clui_info->wend_flag   || 
	    clui_info->hend_flag   || clui_info->dend_flag  )
	{
	   if (kpds_query_location(src_obj))
	   {
	      if (!kpds_get_attribute(src_obj, KPDS_LOCATION_GRID, &grid))
	      {
		 kerror("ksetdattr","main", 
			"Unable to get KPDS_LOCATION_GRID attribute");
		 kexit(KEXIT_FAILURE);
	      }

	      if (grid != KUNIFORM && (grid == KRECTILINEAR || 
				       grid == KCURVILINEAR))
	      {
		 kwarn("ksetdattr", "main",
		       "Object contains %s location data.  Destroying that "
		       "location data and creating uniform location data.",
		       (grid == KRECTILINEAR) ? "rectilinear" : "uniform");

		 /* -- destroy the old location in favor of the new order -- */
		 kpds_destroy_location(src_obj);
		 create_location = TRUE;
	      }
	   }
	   else
	      create_location = TRUE;

	   if (create_location)
	   {
	      /* -- create new uniform location -- */
	      if (!kpds_set_attribute(src_obj, KPDS_LOCATION_GRID, KUNIFORM))
	      {
		 kerror("ksetdattr","main", 
			"Unable to set KPDS_LOCATION_GRID to KUNIFORM");
		 kexit(KEXIT_FAILURE);
	      }
	      kpds_create_location(src_obj);
	      create_location = FALSE;
	   }

/* combine begin and end code */
	   /* -- at this point we know we have uniform location data -- */
	   kpds_get_attributes(src_obj,
			KPDS_LOCATION_BEGIN, &wbeg, &hbeg, &dbeg,
			KPDS_LOCATION_END,   &wend, &hend, &dend, 
			NULL);

	   if (clui_info->wbegin_flag)	wbeg = clui_info->wbegin_double;
	   if (clui_info->hbegin_flag)	hbeg = clui_info->hbegin_double;
	   if (clui_info->dbegin_flag)	dbeg = clui_info->dbegin_double;

	   if (clui_info->wend_flag)	wend = clui_info->wend_double;
	   if (clui_info->hend_flag)	hend = clui_info->hend_double;
	   if (clui_info->dend_flag)	dend = clui_info->dend_double;

	   if (!kpds_set_attributes(src_obj, 
			KPDS_LOCATION_BEGIN, wbeg, hbeg, dbeg, 
			KPDS_LOCATION_END,   wend, hend, dend, 
			NULL))
           {
              kerror("ksetdattr","main", 
			"Unable to set location begin and end attributes to "
		        "(%g,%g,%g)  (%g,%g,%g).",
			wbeg, hbeg, dbeg, wend, hend, dend);
              kexit(KEXIT_FAILURE);
           }
	}

	/* 
	 *  Set sub-object position attribute if specified.
	 */
	if (clui_info->wpos_flag || clui_info->hpos_flag || 
	    clui_info->dpos_flag || clui_info->tpos_flag ||
	    clui_info->epos_flag)
	{
	   kpds_get_attribute(src_obj, KPDS_SUBOBJECT_POSITION,
			&wpos, &hpos, &dpos, &tpos, &epos);
	   if (clui_info->wpos_flag)	wpos = clui_info->wpos_int;
	   if (clui_info->hpos_flag)	hpos = clui_info->hpos_int;
	   if (clui_info->dpos_flag)	dpos = clui_info->dpos_int;
	   if (clui_info->tpos_flag)	tpos = clui_info->tpos_int;
	   if (clui_info->epos_flag)	epos = clui_info->epos_int;
	   if (!kpds_set_attribute(src_obj, KPDS_SUBOBJECT_POSITION, 
			wpos, hpos, dpos, tpos, epos))
           {
              kerror("ksetdattr","main", 
		"Unable to set KPDS_SUBOBJECT_POSITION to (%d,%d,%d,%d,%d).",
			wpos, hpos, dpos, tpos, epos);
              kexit(KEXIT_FAILURE);
           }
	}

	/* 
	 *  Set specified color attributes.
	 */
	if (clui_info->cspace_flag)
	{
	   if (!kcolor_set_attribute(src_obj, KCOLOR_COLORSPACE, 
			clui_info->cspace_list))
           {
              kerror("ksetdattr","main", 
			"Unable to set KCOLOR_COLORSPACE to %s.",
			 clui_info->cspace_label);
              kexit(KEXIT_FAILURE);
           }
	}
	if (clui_info->alpha_flag)
	{
	   if (!kcolor_set_attribute(src_obj, KCOLOR_HAS_ALPHA, 
			clui_info->alpha_list))
           {
              kerror("ksetdattr","main", 
			"Unable to set KCOLOR_HAS_ALPHA to %s.",
			 clui_info->alpha_label);
              kexit(KEXIT_FAILURE);
           }
	}

        /* 
	 *  Copy the source object to the destination object 
	 */
        if (!kpds_copy_object(src_obj, dst_obj))
        {
           kerror("ksetdattr","main",
                  "Unable to copy source object to destination.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* uncomment print statements for debugging 
	kpds_print_attribute(dst_obj, KPDS_MASKED_VALUE_PRESENTATION, kstdout);
	kinfo(KSTANDARD, " <-- KPDS_MASKED_VALUE_PRESENTATION");

	kpds_print_attribute(dst_obj, KPDS_MASK_SUBSTITUTE_VALUE, kstdout);
	kinfo(KSTANDARD, " <-- KPDS_MASK_SUBSTITUTE_VALUE");

	kpds_print_attribute(dst_obj, KPDS_POINT_SIZE, kstdout);
	kinfo(KSTANDARD, " <-- KPDS_POINT_SIZE");

	if (kpds_query_location(dst_obj))
	{
	   kpds_print_attribute(dst_obj, KPDS_LOCATION_BEGIN, kstdout);
	   kinfo(KSTANDARD, " <-- KPDS_LOCATION_BEGIN");
	   kpds_print_attribute(dst_obj, KPDS_LOCATION_END, kstdout);
	   kinfo(KSTANDARD, " <-- KPDS_LOCATION_END");
	}

	kpds_print_attribute(dst_obj, KPDS_POINT_SIZE, kstdout);
	kinfo(KSTANDARD, " <-- KPDS_POINT_SIZE");

	kpds_print_attribute(dst_obj, KPDS_SUBOBJECT_POSITION, kstdout);
	kinfo(KSTANDARD, " <-- KPDS_SUBOBJECT_POSITION");

	kcolor_print_attribute(dst_obj, KCOLOR_COLORSPACE, kstdout);
	kinfo(KSTANDARD, " <-- KCOLOR_COLORSPACE");

	kcolor_print_attribute(dst_obj, KCOLOR_HAS_ALPHA, kstdout);
	kinfo(KSTANDARD, " <-- KCOLOR_HAS_ALPHA");
*/

        /* add history to the output object */
        if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("ksetdattr", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }
 
	kpds_close_object(src_obj);
	kpds_close_object(dst_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ksetdattr_usage_additions
| 
|       Purpose: Prints usage additions in ksetdattr_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksetdattr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksetdattr_usage_additions(void)
{
	kfprintf(kstderr, "\tModify Data Object Attributes\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ksetdattr_free_args
| 
|       Purpose: Frees CLUI struct allocated in ksetdattr_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksetdattr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ksetdattr_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->maskpres_label);
	kfree(clui_info->cspace_label);
	kfree(clui_info->alpha_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
