 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ksegcmp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ksegcmp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compare Attributes & Data of Input 1 and Input 2
|
|       Purpose: main program for ksegcmp
|
|         Input:
|		char *clui_info->i1_file; {first input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {second input data object}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int clui_info->cast_flag; {TRUE if -cast specified}
|
|		double clui_info->tol_double; {tolerance for data comparison}
|		int    clui_info->tol_flag; {TRUE if -tol specified}
|
|		int clui_info->sat_logic; {compare segment level attributes}
|		int clui_info->sat_flag; {TRUE if -sat specified}
|
|		int clui_info->oat_logic; {compare object level attributes}
|		int clui_info->oat_flag; {TRUE if -oat specified}
|
|		int clui_info->s_flag; {TRUE if -s specified}
|
|		int clui_info->psum_logic; {print difference summary}
|		int clui_info->psum_flag; {TRUE if -psum specified}
|
|		int clui_info->pos_flag; {TRUE if -pos specified}
|
|		int clui_info->i1val_flag; {TRUE if -i1val specified}
|
|		int clui_info->i1type_flag; {TRUE if -i1type specified}
|
|		int clui_info->i2val_flag; {TRUE if -i2val specified}
|
|		int clui_info->i2type_flag; {TRUE if -i2type specified}
|
|		char *clui_info->o_file; {output ASCII file for summary}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->rt_logic; {return results as exit status}
|		int clui_info->rt_flag; {TRUE if -rt specified}
|
|		char *clui_info->var_string; {return results to Cantata }
|		int   clui_info->var_flag; {TRUE if -var specified}
|
|		Optional M.E. group:
|		    int clui_info->all_flag; {TRUE if -all specified}
|
|		    Loose group:
|			int clui_info->val_flag; {TRUE if -val specified}
|
|			int clui_info->mask_flag; {TRUE if -mask specified}
|
|			int clui_info->loc_flag; {TRUE if -loc specified}
|
|			int clui_info->time_flag; {TRUE if -time specified}
|
|			int clui_info->map_flag; {TRUE if -map specified}
|
|			char *clui_info->segment_string; {explicit segment name to compare}
|			int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
   	kobject  obj1 = NULL, obj2 = NULL;

	char    *summaries_name = NULL, *specifics_name = NULL;
        kfile   *summaries = NULL, *specifics = NULL;

	kfile   *outfile = NULL;

        char    *name1 = NULL, *name2 = NULL;
        int      status = TRUE;
        int      run_silent;

        int   c;
        char **segments;
        int    i, nsegments = 0;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(ksegcmp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "ksegcmp",
		ksegcmp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ksegcmp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* this flag tells us if we want to print anything or not */
        run_silent = clui_info->s_flag;

        /* compare all if they didn't specify what they wanted */
        if ( !clui_info->all_flag  &&
             !clui_info->val_flag  &&
             !clui_info->mask_flag &&
             !clui_info->loc_flag  &&
             !clui_info->time_flag &&
             !clui_info->map_flag  &&
             !clui_info->segment_flag)
           clui_info->all_flag = TRUE;

	  /*
	   *   Open the first input object and get its name
	   *  ............................................................
	   */

        if ( (obj1 = kdms_open(clui_info->i1_file, KOBJ_READ)) == NULL )
        {
            kerror(NULL, "ksegcmp", "Unable to open Input #1 \"%s\"\n", 
                   clui_info->i1_file);
            kexit(KEXIT_FAILURE);
        }

        if (!kdms_get_attributes(obj1, NULL, KDMS_NAME, &name1, NULL))
        {
            kerror(NULL, "ksegcmp", "Unable to get name of Input #1 \"%s\"\n", 
                   clui_info->i1_file);
            kexit(KEXIT_FAILURE);
        }

	  /*
	   *   Open the second input object and get its name
	   *  ............................................................
	   */

        if ( (obj2 = kdms_open(clui_info->i2_file, KOBJ_READ)) == NULL )
        {
            kerror(NULL, "ksegcmp", "Unable to open Input #2 \"%s\"\n", 
		   clui_info->i2_file);
            kdms_close(obj1);
            kexit(KEXIT_FAILURE);
        }

        if (!kdms_get_attributes(obj2, NULL, KDMS_NAME, &name2, NULL))
        {
            kerror(NULL, "ksegcmp", "Unable to get name of Input #2 \"%s\"\n", 
                   clui_info->i1_file);
            kexit(KEXIT_FAILURE);
        }


	  /*
	   *   Open a summary file to print the summary information
	   *  ............................................................
	   */

	if ((summaries_name = ktempnam(NULL,"ksegcmp")) == NULL)
        {
              kerror(NULL, "ksegcmp", "Unable to open temporary ASCII file"); 
              kdms_close(obj1);  
	      kdms_close(obj2);
              kexit(KEXIT_FAILURE);
        }

        if ( (summaries = kfopen(summaries_name, "w+")) == NULL )
        {
           kerror(NULL, "ksegcmp", "Unable to open temporary ASCII file");
           kdms_close(obj1);  
	   kdms_close(obj2);
           kexit(KEXIT_FAILURE);
        }

	  /*
	   *   Open a temporary file for printing specific differences
	   *  ............................................................
	   */

	if ((specifics_name = ktempnam(NULL,"ksegcmp")) == NULL)
        {
              kerror(NULL, "ksegcmp", "Unable to open temporary ASCII file"); 
              kdms_close(obj1);  
	      kdms_close(obj2);
              kexit(KEXIT_FAILURE);
        }

        if ( (specifics = kfopen(specifics_name, "w+")) == NULL )
        {
           kerror(NULL, "ksegcmp", "Unable to open temporary ASCII file");
           kdms_close(obj1);  
	   kdms_close(obj2);
           kexit(KEXIT_FAILURE);
        }
   
/* -main_before_lib_call_end */

/* -main_library_call */
	  /*
	   *   Compare the object level attributes
	   *  ............................................................
	   */

        if (clui_info->oat_logic)
           status &= lksegcmp_attributes(obj1, obj2, NULL, summaries,
                                         run_silent);

	  /*
	   *   Compare the segments and segment attributes
	   *  ............................................................
	   */

	if (clui_info->all_flag)
	{
           segments = kdms_get_segment_names(obj1,&nsegments);

	   /* need to add some smarts to handle obj1 or obj2 only cases */
           for (i = 0; i < nsegments; i++)
           {
              status &= lksegcmp( obj1, name1, obj2, name2,
                          segments[i], NULL,
	                  clui_info->cast_flag,  clui_info->tol_double,
                          run_silent,            clui_info->psum_logic, 
			  clui_info->sat_logic,  clui_info->pos_flag,
		          clui_info->i1val_flag, clui_info->i1type_flag,
 		          clui_info->i2val_flag, clui_info->i2type_flag,
 	   	          summaries, specifics);

	   }
           karray_free(segments,nsegments,NULL);
	}
	else
	{
	   /* Compare the value segment */
           if (clui_info->val_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     KDMS_SEGMENT_VALUE, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);

	   /* Compare the mask segment */
           if (clui_info->mask_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     KDMS_SEGMENT_MASK, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);

	   /* Compare the location segment */
           if (clui_info->loc_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     KDMS_SEGMENT_LOCATION, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);

	   /* Compare the time segment */
           if (clui_info->time_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     KDMS_SEGMENT_TIME, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);

	   /* Compare the map segment */
           if (clui_info->map_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     KDMS_SEGMENT_MAP, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);

	   /* Compare the explicitly named segment */
           if (clui_info->segment_flag)
              status &= lksegcmp( obj1, name1, obj2, name2, 
			     clui_info->segment_string, NULL, 
	                     clui_info->cast_flag,  clui_info->tol_double,
                             run_silent,            clui_info->psum_logic, 
	  		     clui_info->sat_logic,  clui_info->pos_flag,
		             clui_info->i1val_flag, clui_info->i1type_flag,
 		             clui_info->i2val_flag, clui_info->i2type_flag,
 	   	             summaries, specifics);
	}


          /*
           *   All the specific differences have been buffered into the
	   *   difference file.   If the user wanted to know the specifics, 
           *   then we will print those here.  
	   *  ............................................................
	   */

	if (!run_silent && (clui_info->pos_flag ||
	     clui_info->i1val_flag || clui_info->i1type_flag ||
             clui_info->i2val_flag || clui_info->i2type_flag))
	{

           /* print a header for the specifics */
           kfprintf(summaries,
            "\n# -- ======================================================= ");
           kfprintf(summaries,
            "\n# -- specific differences printed in the following format : ");

           if (clui_info->pos_flag)
              kfprintf(summaries,"\n# --     [POSITION]");

           if (clui_info->i1val_flag)
           {
              kfprintf(summaries,"\n# --     ");
              kfprintf(summaries,"< datum from '%s'", name1);
              if (clui_info->i1type_flag)
                 kfprintf(summaries," (type of '%s')", name1);
           }

           if (clui_info->i2val_flag)
           {      
              kfprintf(summaries,"\n# --     ");
              kfprintf(summaries,"> datum from '%s'", name2);
              if (clui_info->i2type_flag)
                 kfprintf(summaries," (type of '%s')", name2);
           }
           kfprintf(summaries,
           "\n# -- =======================================================\n");


           /* 'cat' the specifics file to the summaries */           
           (void) krewind(specifics);
	
	   while ( (c = kgetc(specifics)) != EOF) {
	      kputc(c, summaries); }
        }

	/* close the differences file and unlink it */
	kfclose(specifics);
        kunlink(specifics_name); 
/* -main_library_call_end */

/* -main_after_lib_call */
	  /*
	   *   Open the output file, if it is present, otherwise open kstdout 
           *   Transfer all ascii output to this file.
	   *  ............................................................
	   */
        if (clui_info->o_flag)
        {
           if ( (outfile = kfopen(clui_info->o_file, "w")) == NULL )
           {
              kerror(NULL, "ksegcmp", "Unable to open Output ASCII file %s", 
		     clui_info->o_file);
              kdms_close(obj1);  
	      kdms_close(obj2);
              kexit(KEXIT_FAILURE);
           }
        }
        else if (!run_silent) /* Write to kstdout if not silent */
           outfile = kstdout;


        if (!run_silent)
        {
	   /* print a one-line summary */
           if (status)
              kfprintf(outfile, "# INPUT FILES ARE IDENTICAL\n");
           else
              kfprintf(outfile, "# INPUT FILES ARE DIFFERENT\n");

           /* 'cat' the summary file to the output */           
           (void) krewind(summaries);
           while ( (c = kgetc(summaries)) != EOF) {
	      kputc(c, outfile); }
	   
	}
	
	/* close the differences file and unlink it */
	kfclose(summaries);
	kunlink(summaries_name); 


	/* Close the ASCII output file */
	if (outfile != NULL && outfile != kstdout)
           if ( kfclose(outfile) != 0 )
	   {
              kerror(NULL, "ksegcmp", "Unable to close file \"%s\"\n",
		   clui_info->o_file);
              kexit(KEXIT_FAILURE);
           }

	/* Close the first input data object */
	if (!kdms_close(obj1))
        {
            kerror(NULL, "ksegcmp", "Unable to close Input Object #1 \"%s\"\n",
		   clui_info->i1_file);
            kexit(KEXIT_FAILURE);
        }

	/* Close the first input data object */
	if (!kdms_close(obj2))
        {
            kerror(NULL, "ksegcmp", "Unable to close Input Object #2 \"%s\"\n",
		   clui_info->i2_file);
            kexit(KEXIT_FAILURE);
        }


	  /*
	   *    If requested to, then set the exit status according
           *    to the results of the comparison.
	   *  ............................................................
	   */

	if (clui_info->rt_flag)
           if (status)
               kexit(KEXIT_SUCCESS);
	   else
               kexit(KEXIT_FAILURE);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ksegcmp_usage_additions
| 
|       Purpose: Prints usage additions in ksegcmp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksegcmp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksegcmp_usage_additions(void)
{
	kfprintf(kstderr, "\tCompare Attributes & Data of Input 1 and Input 2\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ksegcmp_free_args
| 
|       Purpose: Frees CLUI struct allocated in ksegcmp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksegcmp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ksegcmp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
	kfree(clui_info->var_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
