 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kresample
   >>>> 
   >>>>    Written By: Donna Koechner, Scott Wilson, & Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kresample_h_
#define _kresample_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kresample/uis/kresample.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input Object (required infile)
 */
char	*i_file;	/* Input Object FILENAME */
int	 i_flag;	/* Input Object FLAG */

/*
 *  Resulting output object (required outfile)
 */
char	*o_file;	/* Resulting output object FILENAME */
int	 o_flag;	/* Resulting output object FLAG */

/*
 *  Magnification in the width dimension (optional double)
 */
double	 wmag_double;	/* Magnification in the width dimension DOUBLE */
int	 wmag_flag;   	/* Magnification in the width dimension FLAG */

/*
 *  Magnification in the height dimension (optional double)
 */
double	 hmag_double;	/* Magnification in the height dimension DOUBLE */
int	 hmag_flag;   	/* Magnification in the height dimension FLAG */

/*
 *  Magnification in the depth dimension (optional double)
 */
double	 dmag_double;	/* Magnification in the depth dimension DOUBLE */
int	 dmag_flag;   	/* Magnification in the depth dimension FLAG */

/*
 *  Magnification in the time dimension (optional double)
 */
double	 tmag_double;	/* Magnification in the time dimension DOUBLE */
int	 tmag_flag;   	/* Magnification in the time dimension FLAG */

/*
 *  Magnification in the elements dimension (optional double)
 */
double	 emag_double;	/* Magnification in the elements dimension DOUBLE */
int	 emag_flag;   	/* Magnification in the elements dimension FLAG */

/*
 *  Interpolation Type (Optional list)
 */
int	 inter_list;	/* Interpolation Type LIST INDEX */
char	 *inter_label;	/* Interpolation Type LIST LABEL */
int	 inter_flag;	/* Interpolation Type FLAG */

/*
 *  resize dimensions of object to the expanded/shrunk size (optional logical)
 */
int	 resize_logic;	/* resize dimensions of object to the expanded/shrunk size LOGIC */
int	 resize_flag;  	/* resize dimensions of object to the expanded/shrunk size FLAG */

/*
 *  center (optional flag)
 */
int	 center_flag;  	/* center FLAG */

/*
 *  Width coordinate for the center of action (optional integer)
 */
int	 wc_int; 	/* Width coordinate for the center of action INT */
int	 wc_flag;	/* Width coordinate for the center of action FLAG */

/*
 *  Height coordinate for the center of action (optional integer)
 */
int	 hc_int; 	/* Height coordinate for the center of action INT */
int	 hc_flag;	/* Height coordinate for the center of action FLAG */

/*
 *  Depth coordinate for the center of action (optional integer)
 */
int	 dc_int; 	/* Depth coordinate for the center of action INT */
int	 dc_flag;	/* Depth coordinate for the center of action FLAG */

/*
 *  Time coordinate for the center of action (optional integer)
 */
int	 tc_int; 	/* Time coordinate for the center of action INT */
int	 tc_flag;	/* Time coordinate for the center of action FLAG */

/*
 *  Elements coordinate for the center of action (optional integer)
 */
int	 ec_int; 	/* Elements coordinate for the center of action INT */
int	 ec_flag;	/* Elements coordinate for the center of action FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kresample_get_args PROTO((kform *));
void kresample_usage_additions PROTO((void));
void kresample_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
