 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kpad
   >>>> 
   >>>>    Written By: Donna Koechner & Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kpad_h_
#define _kpad_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kpad/uis/kpad.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data file (required infile)
 */
char	*i_file;	/* Input data file FILENAME */
int	 i_flag;	/* Input data file FLAG */

/*
 *  Resulting output file (required outfile)
 */
char	*o_file;	/* Resulting output file FILENAME */
int	 o_flag;	/* Resulting output file FLAG */

/*
 *  Size of width dimension after padding (optional integer)
 */
int	 wsize_int; 	/* Size of width dimension after padding INT */
int	 wsize_flag;	/* Size of width dimension after padding FLAG */

/*
 *  Size of height dimension after padding (optional integer)
 */
int	 hsize_int; 	/* Size of height dimension after padding INT */
int	 hsize_flag;	/* Size of height dimension after padding FLAG */

/*
 *  Size of depth dimension after padding (optional integer)
 */
int	 dsize_int; 	/* Size of depth dimension after padding INT */
int	 dsize_flag;	/* Size of depth dimension after padding FLAG */

/*
 *  Size of time dimension after padding (optional integer)
 */
int	 tsize_int; 	/* Size of time dimension after padding INT */
int	 tsize_flag;	/* Size of time dimension after padding FLAG */

/*
 *  Size of element dimension after padding (optional integer)
 */
int	 esize_int; 	/* Size of element dimension after padding INT */
int	 esize_flag;	/* Size of element dimension after padding FLAG */

/*
 *  Offset of original object in width dimension (optional integer)
 */
int	 woff_int; 	/* Offset of original object in width dimension INT */
int	 woff_flag;	/* Offset of original object in width dimension FLAG */

/*
 *  Offset of original object in height dimension (optional integer)
 */
int	 hoff_int; 	/* Offset of original object in height dimension INT */
int	 hoff_flag;	/* Offset of original object in height dimension FLAG */

/*
 *  Offset of original object in depth dimension (optional integer)
 */
int	 doff_int; 	/* Offset of original object in depth dimension INT */
int	 doff_flag;	/* Offset of original object in depth dimension FLAG */

/*
 *  Offset of original object in time dimension (optional integer)
 */
int	 toff_int; 	/* Offset of original object in time dimension INT */
int	 toff_flag;	/* Offset of original object in time dimension FLAG */

/*
 *  Offset of original object in elements dimension (optional integer)
 */
int	 eoff_int; 	/* Offset of original object in elements dimension INT */
int	 eoff_flag;	/* Offset of original object in elements dimension FLAG */

/*
 *  Real part of pad constant (optional double)
 */
double	 real_double;	/* Real part of pad constant DOUBLE */
int	 real_flag;   	/* Real part of pad constant FLAG */

/*
 *  Imaginary part of pad constant (optional double)
 */
double	 imag_double;	/* Imaginary part of pad constant DOUBLE */
int	 imag_flag;   	/* Imaginary part of pad constant FLAG */

/*
 *  Identify data added by kpad as valid/invalid in mask (optional logical)
 */
int	 valid_logic;	/* Identify data added by kpad as valid/invalid in mask LOGIC */
int	 valid_flag;  	/* Identify data added by kpad as valid/invalid in mask FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kpad_get_args PROTO((kform *));
void kpad_usage_additions PROTO((void));
void kpad_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
