 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for korient
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "korient.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Change Orientation of Data on Dimensions
|
|       Purpose: main program for korient
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->ww_flag; {TRUE if -ww specified}
|
|		    int clui_info->wh_flag; {TRUE if -wh specified}
|
|		    int clui_info->we_flag; {TRUE if -we specified}
|
|		    int clui_info->wd_flag; {TRUE if -wd specified}
|
|		    int clui_info->wt_flag; {TRUE if -wt specified}
|
|		Required M.E. group:
|		    int clui_info->hw_flag; {TRUE if -hw specified}
|
|		    int clui_info->hh_flag; {TRUE if -hh specified}
|
|		    int clui_info->he_flag; {TRUE if -he specified}
|
|		    int clui_info->hd_flag; {TRUE if -hd specified}
|
|		    int clui_info->ht_flag; {TRUE if -ht specified}
|
|		Required M.E. group:
|		    int clui_info->ew_flag; {TRUE if -ew specified}
|
|		    int clui_info->eh_flag; {TRUE if -eh specified}
|
|		    int clui_info->ee_flag; {TRUE if -ee specified}
|
|		    int clui_info->ed_flag; {TRUE if -ed specified}
|
|		    int clui_info->et_flag; {TRUE if -et specified}
|
|		Required M.E. group:
|		    int clui_info->dw_flag; {TRUE if -dw specified}
|
|		    int clui_info->dh_flag; {TRUE if -dh specified}
|
|		    int clui_info->de_flag; {TRUE if -de specified}
|
|		    int clui_info->dd_flag; {TRUE if -dd specified}
|
|		    int clui_info->dt_flag; {TRUE if -dt specified}
|
|		Required M.E. group:
|		    int clui_info->tw_flag; {TRUE if -tw specified}
|
|		    int clui_info->th_flag; {TRUE if -th specified}
|
|		    int clui_info->te_flag; {TRUE if -te specified}
|
|		    int clui_info->td_flag; {TRUE if -td specified}
|
|		    int clui_info->tt_flag; {TRUE if -tt specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner, Mark Young & Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        int    *old_dimens;
        kobject out_obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(korient_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "korient",
		korient_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	korient_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
	{
           kerror("korient","main", "Cannot open input object %s.",
                   clui_info->i_file);
           kexit(KEXIT_FAILURE);
	}
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID)
        {
           kerror("korient","main", "Cannot open output object %s.",
                   clui_info->o_file);
           kexit(KEXIT_FAILURE);
        }

        old_dimens = (int *) kmalloc(5 * sizeof(int));

        if (clui_info->ww_flag)
           old_dimens[0] = KORIENT_WIDTH;
        else if (clui_info->wh_flag)
           old_dimens[0] = KORIENT_HEIGHT;
        else if (clui_info->wd_flag)
           old_dimens[0] = KORIENT_DEPTH;
        else if (clui_info->wt_flag)
           old_dimens[0] = KORIENT_TIME;
        else if (clui_info->we_flag)
           old_dimens[0] = KORIENT_ELEMENTS;

        if (clui_info->hw_flag)
           old_dimens[1] = KORIENT_WIDTH;
        else if (clui_info->hh_flag)
           old_dimens[1] = KORIENT_HEIGHT;
        else if (clui_info->hd_flag)
           old_dimens[1] = KORIENT_DEPTH;
        else if (clui_info->ht_flag)
           old_dimens[1] = KORIENT_TIME;
        else if (clui_info->he_flag)
           old_dimens[1] = KORIENT_ELEMENTS;

        if (clui_info->dw_flag)
           old_dimens[2] = KORIENT_WIDTH;
        else if (clui_info->dh_flag)
           old_dimens[2] = KORIENT_HEIGHT;
        else if (clui_info->dd_flag)
           old_dimens[2] = KORIENT_DEPTH;
        else if (clui_info->dt_flag)
           old_dimens[2] = KORIENT_TIME;
        else if (clui_info->de_flag)
           old_dimens[2] = KORIENT_ELEMENTS;

        if (clui_info->tw_flag)
           old_dimens[3] = KORIENT_WIDTH;
        else if (clui_info->th_flag)
           old_dimens[3] = KORIENT_HEIGHT;
        else if (clui_info->td_flag)
           old_dimens[3] = KORIENT_DEPTH;
        else if (clui_info->tt_flag)
           old_dimens[3] = KORIENT_TIME;
        else if (clui_info->te_flag)
           old_dimens[3] = KORIENT_ELEMENTS;

        if (clui_info->ew_flag)
           old_dimens[4] = KORIENT_WIDTH;
        else if (clui_info->eh_flag)
           old_dimens[4] = KORIENT_HEIGHT;
        else if (clui_info->ed_flag)
           old_dimens[4] = KORIENT_DEPTH;
        else if (clui_info->et_flag)
           old_dimens[4] = KORIENT_TIME;
        else if (clui_info->ee_flag)
           old_dimens[4] = KORIENT_ELEMENTS;

        if (!kpds_copy_object_attr(in_obj, out_obj))
        {
           kerror("korient","main", 
		"Unable to copy attributes from input to output");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkorient(in_obj, old_dimens, out_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* copy rest of input object that was not affected by library */
        if (!kpds_copy_remaining_data(in_obj, out_obj))
        {
           kerror("korient", "main",
                  "Unable to copy remaining data from source to destination.");
           kexit(KEXIT_FAILURE);
        }
 
        /* add history to the output object */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("korient", "main",
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
	
        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: korient_usage_additions
| 
|       Purpose: Prints usage additions in korient_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname korient
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void korient_usage_additions(void)
{
	kfprintf(kstderr, "\tChange Orientation of Data on Dimensions\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: korient_free_args
| 
|       Purpose: Frees CLUI struct allocated in korient_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname korient
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
korient_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
