 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for knormal
   >>>> 
   >>>>    Written By: Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _knormal_h_
#define _knormal_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/knormal/uis/knormal.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  resulting data object (required outfile)
 */
char	*o_file;	/* resulting data object FILENAME */
int	 o_flag;	/* resulting data object FLAG */

/*
 *  Lower normalization value (optional double)
 */
double	 lval_double;	/* Lower normalization value DOUBLE */
int	 lval_flag;   	/* Lower normalization value FLAG */

/*
 *  Upper normalization value (optional double)
 */
double	 uval_double;	/* Upper normalization value DOUBLE */
int	 uval_flag;   	/* Upper normalization value FLAG */

/*
 *  Data type of Output (Optional list)
 */
int	 type_list;	/* Data type of Output LIST INDEX */
char	 *type_label;	/* Data type of Output LIST LABEL */
int	 type_flag;	/* Data type of Output FLAG */

/*----- optional ME group ----*/
/*
 *  normalize whole data set at one time (optional flag)
 */
int	 whole_flag;  	/* normalize whole data set at one time FLAG */

	/*---- nested optional   group ----*/
/*
 *  include width in normalization unit (optional flag)
 */
int	 w_flag;  	/* include width in normalization unit FLAG */

/*
 *  include height in normalization unit (optional flag)
 */
int	 h_flag;  	/* include height in normalization unit FLAG */

/*
 *  include depth in normalization unit (optional flag)
 */
int	 d_flag;  	/* include depth in normalization unit FLAG */

/*
 *  include time in normalization unit (optional flag)
 */
int	 t_flag;  	/* include time in normalization unit FLAG */

/*
 *  include elements in normalization unit (optional flag)
 */
int	 e_flag;  	/* include elements in normalization unit FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

/*----- optional MI group ----*/
/*
 *  If specified, this value used as data minimum (optional double)
 */
double	 dmin_double;	/* If specified, this value used as data minimum DOUBLE */
int	 dmin_flag;   	/* If specified, this value used as data minimum FLAG */

/*
 *  If specified, this value used as data maximum (optional double)
 */
double	 dmax_double;	/* If specified, this value used as data maximum DOUBLE */
int	 dmax_flag;   	/* If specified, this value used as data maximum FLAG */

/*-- optional MI group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void knormal_get_args PROTO((kform *));
void knormal_usage_additions PROTO((void));
void knormal_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
