 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for klogexp
   >>>> 
   >>>>    Written By: Donna Koechner, Mark Young, & Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _klogexp_h_
#define _klogexp_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/klogexp/uis/klogexp.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i_file;	/* input data object FILENAME */
int	 i_flag;	/* input data object FLAG */

/*
 *  resulting output data object (required outfile)
 */
char	*o_file;	/* resulting output data object FILENAME */
int	 o_flag;	/* resulting output data object FLAG */

/*----- required ME group ----*/
/*
 *  Compute using natural base 2.71828... (optional flag)
 */
int	 be_flag;  	/* Compute using natural base 2.71828... FLAG */

/*
 *  Compute using base 10 (optional flag)
 */
int	 b10_flag;  	/* Compute using base 10 FLAG */

/*
 *  Compute using base 2 (optional flag)
 */
int	 b2_flag;  	/* Compute using base 2 FLAG */

/*
 *  User Specified base (optional double)
 */
double	 base_double;	/* User Specified base DOUBLE */
int	 base_flag;   	/* User Specified base FLAG */

/*-- required ME group end ---*/

/*
 *  Compute inverse logarithm (optional flag)
 */
int	 inv_flag;  	/* Compute inverse logarithm FLAG */

/*
 *  Operate either on value [False] or value+1 for log and value -1 for antilog [True] (optional logical)
 */
int	 offset_logic;	/* Operate either on value [False] or value+1 for log and value -1 for antilog [True] LOGIC */
int	 offset_flag;  	/* Operate either on value [False] or value+1 for log and value -1 for antilog [True] FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void klogexp_get_args PROTO((kform *));
void klogexp_usage_additions PROTO((void));
void klogexp_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
