 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kkmeans
   >>>> 
   >>>>    Written By: Scott Wilson (stolen from the K1.5 vkmeans program, which was
written by Tom Sauer and Charlie Gage, with assistance from
Dr. Don Hush, UNM/EECE Dept.)
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 15, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kkmeans_h_
#define _kkmeans_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kkmeans/uis/kkmeans.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input data object (required infile)
 */
char	*i1_file;	/* input data object FILENAME */
int	 i1_flag;	/* input data object FLAG */

/*
 *  cluster number output object (required outfile)
 */
char	*o1_file;	/* cluster number output object FILENAME */
int	 o1_flag;	/* cluster number output object FLAG */

/*
 *  cluster center input object (optional infile)
 */
char	*i2_file;	/* cluster center input object FILENAME */
int	 i2_flag;	/* cluster center input object FLAG */

/*
 *  generate output map (optional flag)
 */
int	 map_flag;  	/* generate output map FLAG */

/*
 *  SPECTRUM compatable map segment (optional flag)
 */
int	 spectrum_flag;  	/* SPECTRUM compatable map segment FLAG */

/*
 *  max number of iterations (optional integer)
 */
int	 n_int; 	/* max number of iterations INT */
int	 n_flag;	/* max number of iterations FLAG */

/*
 *  number of clusters (optional integer)
 */
int	 k_int; 	/* number of clusters INT */
int	 k_flag;	/* number of clusters FLAG */

/*
 *  cluster center output object (optional outfile)
 */
char	*o2_file;	/* cluster center output object FILENAME */
int	 o2_flag;	/* cluster center output object FLAG */

/*
 *  cluster variance output object (optional outfile)
 */
char	*o3_file;	/* cluster variance output object FILENAME */
int	 o3_flag;	/* cluster variance output object FLAG */

/*
 *  Cluster membership count output (optional outfile)
 */
char	*o4_file;	/* Cluster membership count output FILENAME */
int	 o4_flag;	/* Cluster membership count output FLAG */

/*
 *  K-means statistics output (ASCII) (optional outfile)
 */
char	*o5_file;	/* K-means statistics output (ASCII) FILENAME */
int	 o5_flag;	/* K-means statistics output (ASCII) FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kkmeans_get_args PROTO((kform *));
void kkmeans_usage_additions PROTO((void));
void kkmeans_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
