 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kimportraw
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kimportraw.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Low Level Import of Raw Data
|
|       Purpose: main program for kimportraw
|
|         Input:
|		char *clui_info->i1_file; {raw (binary) input}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {output object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i2_file; {Object to add this data to}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int   clui_info->arch_list; {data source architecture}
|		char *clui_info->arch_label;
|		int   clui_info->arch_flag; {TRUE if -arch specified}
|
|		int   clui_info->type_list; {data type of raw data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		int clui_info->wsize_int; {Size of width dimension}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Size of height dimension}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Size of depth dimension}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Size of time dimension}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Size of elements dimension}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		int   clui_info->segment_list; {destination segment for incoming data }
|		char *clui_info->segment_label;
|		int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson, Jeremy Worley
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj=NULL,out_obj=NULL,add_obj=NULL;
	int type,arch,dtype,darch;
	int w,h,d,t,e;
	char *dseg;
	int type_list[] = { KNONE, KBIT, KBYTE, KUBYTE, KSHORT, KUSHORT, KINT, 
			    KUINT, KLONG, KULONG, KFLOAT, KDOUBLE, KCOMPLEX, 
			    KDCOMPLEX};
	char *seg_list[] = { "bogus", KDMS_SEGMENT_VALUE, KDMS_SEGMENT_MASK, 
			     KDMS_SEGMENT_MAP, KDMS_SEGMENT_LOCATION, 
			     KDMS_SEGMENT_TIME};
	int mach_list[] = { KMACH_UNKNOWN, KMACH_LOCAL, KMACH_I80x86, 
			    KMACH_SPARC, KMACH_MIPSEL, KMACH_IBMRT, 
			    KMACH_RS6000, KMACH_POWERPC, KMACH_MC680x0, 
			    KMACH_M88x00,KMACH_MIPSEB, KMACH_PARISC, 
			    KMACH_CONVEX, KMACH_APOLLO, KMACH_ALPHA, 
			    KMACH_CYBER, KMACH_CRAY, KMACH_VAX, KMACH_I860};
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kimportraw_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", 
			       "kimportraw", kimportraw_usage_additions);

	if (!(kclui_check_args()))
	   kexit(KEXIT_FAILURE);

	kimportraw_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /* 
	 * Note special way of opening object to make sure we can
         * directly access the raw data 
	 */
        if ((in_obj = kpds_open_object(clui_info->i1_file, KOBJ_READ|KOBJ_RAW))
	    == KOBJECT_INVALID)
        {
           kerror("kimportraw","main", "Cannot open raw input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
	    == KOBJECT_INVALID)
        {
           kerror("kimportraw","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->i2_flag)
	{
	   if ((add_obj = kpds_open_input_object(clui_info->i2_file))
	       == KOBJECT_INVALID)
	   {
	      kerror("kimportraw","main", "Cannot open add object i2.");
	      kexit(KEXIT_FAILURE);
	   }

	   if (!kpds_copy_object_attr(add_obj, out_obj))
	   {
	      kerror("kimportraw","main", 
		     "Unable to copy attributes from add to output object.");
	      kexit(KEXIT_FAILURE);
	   }
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkimportraw(in_obj, add_obj, mach_list[clui_info->arch_list],
			  type_list[clui_info->type_list], 
			  seg_list[clui_info->segment_list],
			  clui_info->wsize_int, clui_info->hsize_int,
			  clui_info->dsize_int, clui_info->tsize_int,
			  clui_info->esize_int, out_obj))
	   kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* 
	 * add history to the output object 
	 */
        if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kimportraw", "main",
                  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
        }

        if (clui_info->i2_flag)
          {
            if (!kpds_copy_remaining_data(add_obj, out_obj))
              {
               kerror("kimportraw","main",
                  "Unable to copy remaining data from add to output object.");
               kexit(KEXIT_FAILURE);
              }
          }

        if  (clui_info->i2_flag) 
	   kpds_close_object(add_obj);

        kpds_close_object(in_obj);

        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kimportraw_usage_additions
| 
|       Purpose: Prints usage additions in kimportraw_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportraw
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimportraw_usage_additions(void)
{
	kfprintf(kstderr, "\tLow Level Import of Raw Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kimportraw_free_args
| 
|       Purpose: Frees CLUI struct allocated in kimportraw_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportraw
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kimportraw_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->arch_label);
	kfree(clui_info->type_label);
	kfree(clui_info->segment_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
