 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kimportasc
   >>>> 
   >>>>    Written By: John M. Salas, Donna Koechner, Jeremy Worley & John Rasure
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kimportasc_h_
#define _kimportasc_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "ksegops/ksegops.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kimportasc/uis/kimportasc.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  ASCII input data file containing new data segment (required infile)
 */
char	*i1_file;	/* ASCII input data file containing new data segment FILENAME */
int	 i1_flag;	/* ASCII input data file containing new data segment FLAG */

/*
 *  This is a string containing the size of the segment in the index order specified , 40 32 32 1 1 will be a 5D segment that is 40x32x32x1x1 (required string)
 */
char	*size_string;	/* This is a string containing the size of the segment in the index order specified , 40 32 32 1 1 will be a 5D segment that is 40x32x32x1x1 STRING */
int	 size_flag;   	/* This is a string containing the size of the segment in the index order specified , 40 32 32 1 1 will be a 5D segment that is 40x32x32x1x1 FLAG */

/*
 *  output data object (required outfile)
 */
char	*o_file;	/* output data object FILENAME */
int	 o_flag;	/* output data object FLAG */

/*
 *  data object input to insert the new segment into (optional infile)
 */
char	*i2_file;	/* data object input to insert the new segment into FILENAME */
int	 i2_flag;	/* data object input to insert the new segment into FLAG */

/*
 *  starting point in ASCII input file to start importing at (optional integer)
 */
int	 so_int; 	/* starting point in ASCII input file to start importing at INT */
int	 so_flag;	/* starting point in ASCII input file to start importing at FLAG */

/*
 *  number of points in ASCII file to skip between reads (optional integer)
 */
int	 sf_int; 	/* number of points in ASCII file to skip between reads INT */
int	 sf_flag;	/* number of points in ASCII file to skip between reads FLAG */

/*
 *  the name of the segment to insert the ASCII data into (optional string)
 */
char	*segment_string;	/* the name of the segment to insert the ASCII data into STRING */
int	 segment_flag;   	/* the name of the segment to insert the ASCII data into FLAG */

/*
 *  dimension of the segment (optional integer)
 */
int	 dim_int; 	/* dimension of the segment INT */
int	 dim_flag;	/* dimension of the segment FLAG */

/*
 *  data type (Optional list)
 */
int	 type_list;	/* data type LIST INDEX */
char	 *type_label;	/* data type LIST LABEL */
int	 type_flag;	/* data type FLAG */

/*
 *  index order of the segment (optional string)
 */
char	*index_string;	/* index order of the segment STRING */
int	 index_flag;   	/* index order of the segment FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kimportasc_get_args PROTO((kform *));
void kimportasc_usage_additions PROTO((void));
void kimportasc_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
