 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for khistops
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "khistops.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Perform Histogram Equalization and Stretching
|
|       Purpose: main program for khistops
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->equalize_flag; {TRUE if -equalize specified}
|
|		    int clui_info->stretch_flag; {TRUE if -stretch specified}
|
|		Required M.E. group:
|		    int clui_info->whole_flag; {TRUE if -whole specified}
|
|		    Loose group:
|			int clui_info->w_flag; {TRUE if -w specified}
|
|			int clui_info->h_flag; {TRUE if -h specified}
|
|			int clui_info->d_flag; {TRUE if -d specified}
|
|			int clui_info->t_flag; {TRUE if -t specified}
|
|			int clui_info->e_flag; {TRUE if -e specified}
|
|		int clui_info->invert_flag; {TRUE if -invert specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in_obj = NULL;
	kobject out_obj = NULL;
	char *function = NULL;
        int w,h,d,t,e;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(khistops_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "khistops",
		khistops_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	khistops_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khistops","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

	if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID)
        {
           kerror("khistops","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object_attr(in_obj, out_obj))
	{
           kerror("khistops","main", 
		  "Unable to copy attributes from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	if (clui_info->equalize_flag) function = "equalize";
	else if (clui_info->stretch_flag) function = "stretch";
	else function = "equalize";

	w=h=d=t=e=0;
	if (clui_info->whole_flag)
        {
          w=h=d=t=e=1;
        }
        else
        {
          if (clui_info->w_flag) w=1;
	  if (clui_info->h_flag) h=1;
	  if (clui_info->d_flag) d=1;
	  if (clui_info->t_flag) t=1;
	  if (clui_info->e_flag) e=1;
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkhistops(in_obj,function,clui_info->invert_flag,
                       w,h,d,t,e,out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("khistops", "main", 
		  "Unable to set history on the destination object");
            kexit(KEXIT_FAILURE);
	}
	
        if (!kpds_copy_remaining_data(in_obj, out_obj))
	{
           kerror("khistops","main", 
		  "Unable to copy remaining data from input to output object.");
           kexit(KEXIT_FAILURE);
        }

	kpds_close_object(in_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: khistops_usage_additions
| 
|       Purpose: Prints usage additions in khistops_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khistops
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void khistops_usage_additions(void)
{
	kfprintf(kstderr, "\tPerform Histogram Equalization and Stretching\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: khistops_free_args
| 
|       Purpose: Frees CLUI struct allocated in khistops_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khistops
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
khistops_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
