 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgsin
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgsin_h_
#define _kgsin_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kgsin/uis/kgsin.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Output file containing sinusoidal value data (required outfile)
 */
char	*o_file;	/* Output file containing sinusoidal value data FILENAME */
int	 o_flag;	/* Output file containing sinusoidal value data FLAG */

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  Apply sine function to the sum of coordinates at a point (optional flag)
 */
int	 sin1_flag;  	/* Apply sine function to the sum of coordinates at a point FLAG */

/*
 *  Maximum level of output (optional double)
 */
double	 ampl_double;	/* Maximum level of output DOUBLE */
int	 ampl_flag;   	/* Maximum level of output FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Apply sine to each coordinate and sum up the result (optional flag)
 */
int	 sin5_flag;  	/* Apply sine to each coordinate and sum up the result FLAG */

/*
 *  Amplitude along the width direction (optional double)
 */
double	 wampl_double;	/* Amplitude along the width direction DOUBLE */
int	 wampl_flag;   	/* Amplitude along the width direction FLAG */

/*
 *  Amplitude along the height direction (optional double)
 */
double	 hampl_double;	/* Amplitude along the height direction DOUBLE */
int	 hampl_flag;   	/* Amplitude along the height direction FLAG */

/*
 *  Amplitude along the depth direction (optional double)
 */
double	 dampl_double;	/* Amplitude along the depth direction DOUBLE */
int	 dampl_flag;   	/* Amplitude along the depth direction FLAG */

/*
 *  Amplitude along the time direction (optional double)
 */
double	 tampl_double;	/* Amplitude along the time direction DOUBLE */
int	 tampl_flag;   	/* Amplitude along the time direction FLAG */

/*
 *  Amplitude along the element direction (optional double)
 */
double	 eampl_double;	/* Amplitude along the element direction DOUBLE */
int	 eampl_flag;   	/* Amplitude along the element direction FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

/*
 *  Width size of sinusoidal value data (optional integer)
 */
int	 wsize_int; 	/* Width size of sinusoidal value data INT */
int	 wsize_flag;	/* Width size of sinusoidal value data FLAG */

/*
 *  Height size of sinusoidal value data (optional integer)
 */
int	 hsize_int; 	/* Height size of sinusoidal value data INT */
int	 hsize_flag;	/* Height size of sinusoidal value data FLAG */

/*
 *  Depth size of sinusoidal value data (optional integer)
 */
int	 dsize_int; 	/* Depth size of sinusoidal value data INT */
int	 dsize_flag;	/* Depth size of sinusoidal value data FLAG */

/*
 *  Time size of sinusoidal value data (optional integer)
 */
int	 tsize_int; 	/* Time size of sinusoidal value data INT */
int	 tsize_flag;	/* Time size of sinusoidal value data FLAG */

/*
 *  Elements dimension size of sinusoidal value data (optional integer)
 */
int	 esize_int; 	/* Elements dimension size of sinusoidal value data INT */
int	 esize_flag;	/* Elements dimension size of sinusoidal value data FLAG */

/*
 *  Number of sine waves along width dimension (optional double)
 */
double	 wnum_double;	/* Number of sine waves along width dimension DOUBLE */
int	 wnum_flag;   	/* Number of sine waves along width dimension FLAG */

/*
 *  Phase offset along width dimension (optional double)
 */
double	 wp_double;	/* Phase offset along width dimension DOUBLE */
int	 wp_flag;   	/* Phase offset along width dimension FLAG */

/*
 *  Number of sine waves along height dimension (optional double)
 */
double	 hnum_double;	/* Number of sine waves along height dimension DOUBLE */
int	 hnum_flag;   	/* Number of sine waves along height dimension FLAG */

/*
 *  Phase offset along the height dimension (optional double)
 */
double	 hp_double;	/* Phase offset along the height dimension DOUBLE */
int	 hp_flag;   	/* Phase offset along the height dimension FLAG */

/*
 *  Number of sine waves along depth dimension (optional double)
 */
double	 dnum_double;	/* Number of sine waves along depth dimension DOUBLE */
int	 dnum_flag;   	/* Number of sine waves along depth dimension FLAG */

/*
 *  Phase offset along depth dimension (optional double)
 */
double	 dp_double;	/* Phase offset along depth dimension DOUBLE */
int	 dp_flag;   	/* Phase offset along depth dimension FLAG */

/*
 *  Number of sine waves along time dimension (optional double)
 */
double	 tnum_double;	/* Number of sine waves along time dimension DOUBLE */
int	 tnum_flag;   	/* Number of sine waves along time dimension FLAG */

/*
 *  Phase Offset for time dimension (optional double)
 */
double	 tp_double;	/* Phase Offset for time dimension DOUBLE */
int	 tp_flag;   	/* Phase Offset for time dimension FLAG */

/*
 *  Number of sine waves along Elements Dimension (optional double)
 */
double	 enum_double;	/* Number of sine waves along Elements Dimension DOUBLE */
int	 enum_flag;   	/* Number of sine waves along Elements Dimension FLAG */

/*
 *  Phase Offset in the elements dimension (optional double)
 */
double	 ep_double;	/* Phase Offset in the elements dimension DOUBLE */
int	 ep_flag;   	/* Phase Offset in the elements dimension FLAG */

/*
 *  Data type of sinusoidal value data (Optional list)
 */
int	 type_list;	/* Data type of sinusoidal value data LIST INDEX */
char	 *type_label;	/* Data type of sinusoidal value data LIST LABEL */
int	 type_flag;	/* Data type of sinusoidal value data FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgsin_get_args PROTO((kform *));
void kgsin_usage_additions PROTO((void));
void kgsin_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
