 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgeneric
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgeneric.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generic Routine Interface (glue)
|
|       Purpose: main program for kgeneric
|
|         Input:
|		int clui_info->di1_logic; {selects minus sign (TRUE) or blank (FALSE) for input name #1}
|		int clui_info->di1_flag; {TRUE if -di1 specified}
|
|		int clui_info->di2_logic; {selects minus sign (TRUE) or blank (FALSE) for input name #2}
|		int clui_info->di2_flag; {TRUE if -di2 specified}
|
|		int clui_info->di3_logic; {selects minus sign (TRUE) or blank (FALSE) for input name #3}
|		int clui_info->di3_flag; {TRUE if -di3 specified}
|
|		int clui_info->do1_logic; {selects minus sign (TRUE) or blank (FALSE) for output name #1}
|		int clui_info->do1_flag; {TRUE if -do1 specified}
|
|		int clui_info->do2_logic; {selects minus sign (TRUE) or blank (FALSE) for output name #2}
|		int clui_info->do2_flag; {TRUE if -do2 specified}
|
|		int clui_info->do3_logic; {selects minus sign (TRUE) or blank (FALSE) for output name #3}
|		int clui_info->do3_flag; {TRUE if -do3 specified}
|
|		int clui_info->dn1_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #1}
|		int clui_info->dn1_flag; {TRUE if -dn1 specified}
|
|		int clui_info->dn2_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #2}
|		int clui_info->dn2_flag; {TRUE if -dn2 specified}
|
|		int clui_info->dn3_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #3}
|		int clui_info->dn3_flag; {TRUE if -dn3 specified}
|
|		int clui_info->dn4_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #4}
|		int clui_info->dn4_flag; {TRUE if -dn4 specified}
|
|		int clui_info->dn5_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #5}
|		int clui_info->dn5_flag; {TRUE if -dn5 specified}
|
|		int clui_info->dn6_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #6}
|		int clui_info->dn6_flag; {TRUE if -dn6 specified}
|
|		int clui_info->dn7_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #7}
|		int clui_info->dn7_flag; {TRUE if -dn7 specified}
|
|		int clui_info->dn8_logic; {selects minus sign (TRUE) or blank (FALSE) for arg name #8}
|		int clui_info->dn8_flag; {TRUE if -dn8 specified}
|
|		char *clui_info->prefix_string; {prefix string}
|		int   clui_info->prefix_flag; {TRUE if -prefix specified}
|
|		char *clui_info->i_file; {input image}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output image or file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->iname1_string; {name of input argument #1}
|		int   clui_info->iname1_flag; {TRUE if -iname1 specified}
|
|		char *clui_info->i1_file; {input filename #1}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->iname2_string; {name of input argument #2}
|		int   clui_info->iname2_flag; {TRUE if -iname2 specified}
|
|		char *clui_info->i2_file; {input filename #2}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->iname3_string; {name of input argument #3}
|		int   clui_info->iname3_flag; {TRUE if -iname3 specified}
|
|		char *clui_info->i3_file; {input filename #3}
|		int   clui_info->i3_flag; {TRUE if -i3 specified}
|
|		char *clui_info->oname1_string; {name of output argument #1}
|		int   clui_info->oname1_flag; {TRUE if -oname1 specified}
|
|		char *clui_info->o1_file; {output filename #1}
|		int   clui_info->o1_flag; {TRUE if -o1 specified}
|
|		char *clui_info->oname2_string; {name of output argument #2}
|		int   clui_info->oname2_flag; {TRUE if -oname2 specified}
|
|		char *clui_info->o2_file; {output filename #2}
|		int   clui_info->o2_flag; {TRUE if -o2 specified}
|
|		char *clui_info->oname3_string; {name of output argument #3}
|		int   clui_info->oname3_flag; {TRUE if -oname3 specified}
|
|		char *clui_info->o3_file; {output filename #3}
|		int   clui_info->o3_flag; {TRUE if -o3 specified}
|
|		char *clui_info->name1_string; {Name of argument #1}
|		int   clui_info->name1_flag; {TRUE if -name1 specified}
|
|		char *clui_info->val1_string; {argument #1 value}
|		int   clui_info->val1_flag; {TRUE if -val1 specified}
|
|		char *clui_info->name2_string; {Name of argument #2}
|		int   clui_info->name2_flag; {TRUE if -name2 specified}
|
|		char *clui_info->val2_string; {argument #2 value}
|		int   clui_info->val2_flag; {TRUE if -val2 specified}
|
|		char *clui_info->name3_string; {Name of argument #3}
|		int   clui_info->name3_flag; {TRUE if -name3 specified}
|
|		char *clui_info->val3_string; {argument #3 value}
|		int   clui_info->val3_flag; {TRUE if -val3 specified}
|
|		char *clui_info->name4_string; {Name of argument #4}
|		int   clui_info->name4_flag; {TRUE if -name4 specified}
|
|		char *clui_info->val4_string; {argument #4 value}
|		int   clui_info->val4_flag; {TRUE if -val4 specified}
|
|		char *clui_info->name5_string; {Name of argument #5}
|		int   clui_info->name5_flag; {TRUE if -name5 specified}
|
|		char *clui_info->val5_string; {argument #5 value}
|		int   clui_info->val5_flag; {TRUE if -val5 specified}
|
|		char *clui_info->name6_string; {Name of argument #6}
|		int   clui_info->name6_flag; {TRUE if -name6 specified}
|
|		char *clui_info->val6_string; {argument #6 value}
|		int   clui_info->val6_flag; {TRUE if -val6 specified}
|
|		char *clui_info->name7_string; {Name of argument #7}
|		int   clui_info->name7_flag; {TRUE if -name7 specified}
|
|		char *clui_info->val7_string; {argument #7 value}
|		int   clui_info->val7_flag; {TRUE if -val7 specified}
|
|		char *clui_info->name8_string; {Name of argument #8}
|		int   clui_info->name8_flag; {TRUE if -name8 specified}
|
|		char *clui_info->val8_string; {argument #8 value}
|		int   clui_info->val8_flag; {TRUE if -val8 specified}
|
|		char *clui_info->trailer_string; {trailer string}
|		int   clui_info->trailer_flag; {TRUE if -trailer specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
char s[8192];
char t[1024];
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgeneric_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgeneric",
		kgeneric_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgeneric_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /* Start with the prefix if it is declared */
        if (clui_info->prefix_flag)
          {
            ksprintf(t,"%s ",clui_info->prefix_string);
            kstrcat(s,t);
          }

        /* Next do the input file items */
        if (clui_info->di1_logic) kstrcat(s,"-");
        if (clui_info->iname1_flag)
          {
            ksprintf(t,"%s ",clui_info->iname1_string);
            kstrcat(s,t);
          }
        if (clui_info->i1_flag)
          {
            ksprintf(t,"%s ",clui_info->i1_file);
            kstrcat(s,t);
          }
        if (clui_info->di2_logic) kstrcat(s,"-");
        if (clui_info->iname2_flag)
          {
            ksprintf(t,"%s ",clui_info->iname2_string);
            kstrcat(s,t);
          }
        if (clui_info->i2_flag)
          {
            ksprintf(t,"%s ",clui_info->i2_file);
            kstrcat(s,t);
          }
        if (clui_info->di3_logic) kstrcat(s,"-");
        if (clui_info->iname3_flag)
          {
            ksprintf(t,"%s ",clui_info->iname3_string);
            kstrcat(s,t);
          }
        if (clui_info->i3_flag)
          {
            ksprintf(t,"%s ",clui_info->i3_file);
            kstrcat(s,t);
          }
 
        /* Now do the output file items */
        if (clui_info->do1_logic) kstrcat(s,"-");
        if (clui_info->oname1_flag)
          {
            ksprintf(t,"%s ",clui_info->oname1_string);
            kstrcat(s,t);
          }
        if (clui_info->o1_flag)
          {
            ksprintf(t,"%s ",clui_info->o1_file);
            kstrcat(s,t);
          }
        if (clui_info->do2_logic) kstrcat(s,"-");
        if (clui_info->oname2_flag)
          {
            ksprintf(t,"%s ",clui_info->oname2_string);
            kstrcat(s,t);
          }
        if (clui_info->o2_flag)
          {
            ksprintf(t,"%s ",clui_info->o2_file);
            kstrcat(s,t);
          }
        if (clui_info->do3_logic) kstrcat(s,"-");
        if (clui_info->oname3_flag)
          {
            ksprintf(t,"%s ",clui_info->oname3_string);
            kstrcat(s,t);
          }
        if (clui_info->o3_flag)
          {
            ksprintf(t,"%s ",clui_info->o3_file);
            kstrcat(s,t);
          }
 
        /* Now do the general argument items */
        if (clui_info->dn1_logic) kstrcat(s,"-");
        if (clui_info->name1_flag)
          {
            ksprintf(t,"%s ",clui_info->name1_string);
            kstrcat(s,t);
          }
        if (clui_info->val1_flag)
          {
            ksprintf(t,"%s ",clui_info->val1_string);
            kstrcat(s,t);
          }
        if (clui_info->dn2_logic) kstrcat(s,"-");
        if (clui_info->name2_flag)
          {
            ksprintf(t,"%s ",clui_info->name2_string);
            kstrcat(s,t);
          }
        if (clui_info->val2_flag)
          {
            ksprintf(t,"%s ",clui_info->val2_string);
            kstrcat(s,t);
          }
        if (clui_info->dn3_logic) kstrcat(s,"-");
        if (clui_info->name3_flag)
          {
            ksprintf(t,"%s ",clui_info->name3_string);
            kstrcat(s,t);
          }
        if (clui_info->val3_flag)
          {
            ksprintf(t,"%s ",clui_info->val3_string);
            kstrcat(s,t);
          }
        if (clui_info->dn4_logic) kstrcat(s,"-");
        if (clui_info->name4_flag)
          {
            ksprintf(t,"%s ",clui_info->name4_string);
            kstrcat(s,t);
          }
        if (clui_info->val4_flag)
          {
            ksprintf(t,"%s ",clui_info->val4_string);
            kstrcat(s,t);
          }
        if (clui_info->dn5_logic) kstrcat(s,"-");
        if (clui_info->name5_flag)
          {
            ksprintf(t,"%s ",clui_info->name5_string);
            kstrcat(s,t);
          }
        if (clui_info->val5_flag)
          {
            ksprintf(t,"%s ",clui_info->val5_string);
            kstrcat(s,t);
          }
        if (clui_info->dn6_logic) kstrcat(s,"-");
        if (clui_info->name6_flag)
          {
            ksprintf(t,"%s ",clui_info->name6_string);
            kstrcat(s,t);
          }
        if (clui_info->val6_flag)
          {
            ksprintf(t,"%s ",clui_info->val6_string);
            kstrcat(s,t);
          }
        if (clui_info->dn7_logic) kstrcat(s,"-");
        if (clui_info->name7_flag)
          {
            ksprintf(t,"%s ",clui_info->name7_string);
            kstrcat(s,t);
          }
        if (clui_info->val7_flag)
          {
            ksprintf(t,"%s ",clui_info->val7_string);
            kstrcat(s,t);
          }
        if (clui_info->dn8_logic) kstrcat(s,"-");
        if (clui_info->name8_flag)
          {
            ksprintf(t,"%s ",clui_info->name8_string);
            kstrcat(s,t);
          }
        if (clui_info->val8_flag)
          {
            ksprintf(t,"%s ",clui_info->val8_string);
            kstrcat(s,t);
          }
 
        /* Put on the trailer */
        if (clui_info->trailer_flag)
 
          {
            ksprintf(t,"%s ",clui_info->trailer_string);
            kstrcat(s,t);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        ksystem(s);
/* -main_library_call_end */

/* -main_after_lib_call */
        if (clui_info->o_flag && clui_info->i_flag)
          kcopyfile(clui_info->i_file,clui_info->o_file);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgeneric_usage_additions
| 
|       Purpose: Prints usage additions in kgeneric_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgeneric
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgeneric_usage_additions(void)
{
	kfprintf(kstderr, "\tGeneric Routine Interface (glue)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgeneric_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgeneric_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgeneric
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgeneric_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->prefix_string);
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->iname1_string);
	kfree(clui_info->i1_file);
	kfree(clui_info->iname2_string);
	kfree(clui_info->i2_file);
	kfree(clui_info->iname3_string);
	kfree(clui_info->i3_file);
	kfree(clui_info->oname1_string);
	kfree(clui_info->o1_file);
	kfree(clui_info->oname2_string);
	kfree(clui_info->o2_file);
	kfree(clui_info->oname3_string);
	kfree(clui_info->o3_file);
	kfree(clui_info->name1_string);
	kfree(clui_info->val1_string);
	kfree(clui_info->name2_string);
	kfree(clui_info->val2_string);
	kfree(clui_info->name3_string);
	kfree(clui_info->val3_string);
	kfree(clui_info->name4_string);
	kfree(clui_info->val4_string);
	kfree(clui_info->name5_string);
	kfree(clui_info->val5_string);
	kfree(clui_info->name6_string);
	kfree(clui_info->val6_string);
	kfree(clui_info->name7_string);
	kfree(clui_info->val7_string);
	kfree(clui_info->name8_string);
	kfree(clui_info->val8_string);
	kfree(clui_info->trailer_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
