 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgate
   >>>> 
   >>>>    Written By: Donna Koechner & Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgate_h_
#define _kgate_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kgate/uis/kgate.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  First input data object (required infile)
 */
char	*i1_file;	/* First input data object FILENAME */
int	 i1_flag;	/* First input data object FLAG */

/*
 *  Second input file object (required infile)
 */
char	*i2_file;	/* Second input file object FILENAME */
int	 i2_flag;	/* Second input file object FLAG */

/*
 *  Gating input data object (required infile)
 */
char	*igate_file;	/* Gating input data object FILENAME */
int	 igate_flag;	/* Gating input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  Gating logic: if gate data = gval, (0) use i1, (1) use i2 (optional logical)
 */
int	 logic_logic;	/* Gating logic: if gate data = gval, (0) use i1, (1) use i2 LOGIC */
int	 logic_flag;  	/* Gating logic: if gate data = gval, (0) use i1, (1) use i2 FLAG */

/*
 *  Value on which to gate (optional double)
 */
double	 gval_double;	/* Value on which to gate DOUBLE */
int	 gval_flag;   	/* Value on which to gate FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgate_get_args PROTO((kform *));
void kgate_usage_additions PROTO((void));
void kgate_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
