 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kformats
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kformats.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Conversion Between the Formats Supported in Khoros 2
|
|       Purpose: main program for kformats
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->ascii_flag; {TRUE if -ascii specified}
|
|		    int clui_info->viff_flag; {TRUE if -viff specified}
|
|		    int clui_info->avs_flag; {TRUE if -avs specified}
|
|		    int clui_info->xbm_flag; {TRUE if -xbm specified}
|
|		    int clui_info->arf_flag; {TRUE if -arf specified}
|
|		    int clui_info->xvimage_flag; {TRUE if -xvimage specified}
|
|		    int clui_info->pnm_flag; {TRUE if -pnm specified}
|
|		    int clui_info->xwd_flag; {TRUE if -xwd specified}
|
|		    int clui_info->raw_flag; {TRUE if -raw specified}
|
|		    int clui_info->xpm_flag; {TRUE if -xpm specified}
|
|		    int clui_info->rast_flag; {TRUE if -rast specified}
|
|		    char *clui_info->format_string; {Supported format not available via the format flags}
|		    int   clui_info->format_flag; {TRUE if -format specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 15, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject src_obj;
	kobject dst_obj;
	char	*format = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kformats_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kformats",
		kformats_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kformats_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (clui_info->ascii_flag)
              format = KASCII;
	else if (clui_info->arf_flag)
              format = KARF;
	else if (clui_info->avs_flag)
              format = KAVS;
/*
	else if (clui_info->eps_flag)
              format = KEPS;
*/
	else if (clui_info->pnm_flag)
              format = KPNM;
	else if (clui_info->rast_flag)
              format = KRASTER;
	else if (clui_info->raw_flag)
              format = KRAW;
	else if (clui_info->viff_flag)
              format = KVIFF;
	else if (clui_info->xbm_flag)
              format = KXBM;
	else if (clui_info->xpm_flag)
              format = KXPM;
	else if (clui_info->xvimage_flag)
              format = KXVIMAGE;
	else if (clui_info->xwd_flag)
              format = KXWD;
	else if (clui_info->format_flag)
	      format = clui_info->format_string;
	else
	{
	   kerror("kformats","main","Unsupported Conversion Format Specified");
           kexit(KEXIT_FAILURE);
	}

        /*
         * Open objects.
         */
        if ((src_obj = kpds_open_input_object(clui_info->i_file)) 
		== KOBJECT_INVALID)
	{
           kerror("kfomats", "main", "Failed to open input object");
	   kfree(format);
           kexit(KEXIT_FAILURE);
	}
	
	if ((dst_obj=kpds_open_output_object(clui_info->o_file)) 
		== KOBJECT_INVALID) 
	{
           kerror("kformats", "main", "Failed to open output object");
	   kfree(format);
           kexit(KEXIT_FAILURE);
        }

	kpds_copy_object(src_obj, dst_obj);
	if (!kpds_set_attribute(dst_obj, KPDS_FORMAT, format))
	{
           kerror("kformats", "main", 
		  "Unable to set format (%s) on destination object", format);
	   kfree(format);
           kexit(KEXIT_FAILURE);
        }

	/* add history to the output object */
	if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kformats", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	kpds_close_object(src_obj);
	kpds_close_object(dst_obj);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kformats_usage_additions
| 
|       Purpose: Prints usage additions in kformats_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kformats
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kformats_usage_additions(void)
{
	kfprintf(kstderr, "\tConversion Between the Formats Supported in Khoros 2\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kformats_free_args
| 
|       Purpose: Frees CLUI struct allocated in kformats_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kformats
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kformats_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
