 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kconvert
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kconvert.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Convert Data Storage Type  (Optional Scale & Offset)
|
|       Purpose: main program for kconvert
|
|         Input:
|		char *clui_info->i_file; {input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->loc_flag; {TRUE if -loc specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    char *clui_info->segment_string; {Perform operation on user specified segment}
|		    int   clui_info->segment_flag; {TRUE if -segment specified}
|
|		int   clui_info->type_list; {Convert to specified data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		double clui_info->scale_double; {Real scale factor}
|		int    clui_info->scale_flag; {TRUE if -scale specified}
|
|		double clui_info->roff_double; {Real offset value}
|		int    clui_info->roff_flag; {TRUE if -roff specified}
|
|		double clui_info->ioff_double; {Imaginary offset value}
|		int    clui_info->ioff_flag; {TRUE if -ioff specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas & Donna Koechner
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	char    *segment_name = NULL;
        kobject source_object, destination_object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kconvert_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kconvert",
		kconvert_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kconvert_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /* -- want to use some of the kpds presentation functionality -- */ 
        kpds_init();

        /*
         * Open objects.
         */
        if ((source_object = kdms_open(clui_info->i_file, KOBJ_READ)) == NULL)
	{
           kerror("kconvert", "main", "Failed to open input object");
           kexit(KEXIT_FAILURE);
        }

        if ((destination_object = kdms_open(clui_info->o_file,
                                            KOBJ_WRITE)) == NULL)
	{
           kerror("kconvert", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        if ( clui_info->segment_flag ) {
	   segment_name = kstrdup(clui_info->segment_string);
	}
	else if ( clui_info->val_flag ) {
	   segment_name = kstrdup(KDMS_SEGMENT_VALUE);
	}
	else if ( clui_info->mask_flag ) {
	   segment_name = kstrdup(KDMS_SEGMENT_MASK);
	}
	else if ( clui_info->map_flag ) {
	   segment_name = kstrdup(KDMS_SEGMENT_MAP);
	}
	else if ( clui_info->loc_flag ) {
	   segment_name = kstrdup(KDMS_SEGMENT_LOCATION);
	}
	else if ( clui_info->time_flag ) {
	   segment_name = kstrdup(KDMS_SEGMENT_TIME);
	}

        if ( !lkconvert(source_object, segment_name, clui_info->type_label,
			clui_info->scale_double, clui_info->roff_double,
			clui_info->ioff_double, destination_object) ) {
	   kfree(segment_name);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	kfree(segment_name);

        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kconvert", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kconvert_usage_additions
| 
|       Purpose: Prints usage additions in kconvert_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kconvert
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kconvert_usage_additions(void)
{
	kfprintf(kstderr, "\tConvert Data Storage Type  (Optional Scale & Offset)\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kconvert_free_args
| 
|       Purpose: Frees CLUI struct allocated in kconvert_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kconvert
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kconvert_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
