 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcompare
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcompare.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Comparison Operators
|
|       Purpose: main program for kcompare
|
|         Input:
|		char *clui_info->i1_file; {first input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    char *clui_info->i2_file; {second input data object}
|		    int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		    double clui_info->real_double; {constant value}
|		    int    clui_info->real_flag; {TRUE if -real specified}
|
|		Required M.E. group:
|		    int clui_info->eq_flag; {TRUE if -eq specified}
|
|		    int clui_info->ne_flag; {TRUE if -ne specified}
|
|		    int clui_info->gt_flag; {TRUE if -gt specified}
|
|		    int clui_info->ge_flag; {TRUE if -ge specified}
|
|		    int clui_info->lt_flag; {TRUE if -lt specified}
|
|		    int clui_info->le_flag; {TRUE if -le specified}
|
|		double clui_info->tol_double; {Tolerance}
|		int    clui_info->tol_flag; {TRUE if -tol specified}
|
|		double clui_info->tval_double; {Value assigned to output if evaluation is TRUE}
|		int    clui_info->tval_flag; {TRUE if -tval specified}
|
|		double clui_info->fval_double; {Value assigned to output if evaluation is FALSE}
|		int    clui_info->fval_flag; {TRUE if -fval specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner & Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj1;
        kobject in_obj2;
        kobject out_obj;
        char    *function=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcompare_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcompare",
		kcompare_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcompare_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        in_obj1 = kpds_open_input_object(clui_info->i1_file);
        if (clui_info->i2_flag)
           in_obj2 = kpds_open_input_object(clui_info->i2_file);
        else
           in_obj2 = NULL;
        out_obj = kpds_open_output_object(clui_info->o_file);

        if (clui_info->eq_flag)
           function = "eq";
        else if (clui_info->ne_flag)
           function = "ne";
        else if (clui_info->gt_flag)
           function = "gt";
        else if (clui_info->ge_flag)
           function = "ge";
        else if (clui_info->lt_flag)
           function = "lt";
        else if (clui_info->le_flag)
           function = "le";
	else
	{
	   kerror("kcompare","main","comparison function not specified");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_object_attr(in_obj1,out_obj))
	{
	   kerror("kcompare","main",
		  "Unable to copy attributes from input1 to output");
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkcompare(in_obj1, in_obj2, clui_info->real_double,
	               function, clui_info->tval_double,
	       	       clui_info->fval_double,
		       clui_info->tol_double, out_obj))
	{
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kcompare", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        if (!kpds_copy_remaining_data(in_obj1,out_obj))
	{
	   kerror("kcompare","main",
		  "Unable to copy remaining data from input1 to output");
	   kexit(KEXIT_FAILURE);
	}

	kpds_close_object(in_obj1);
	if (clui_info->i2_flag)  kpds_close_object(in_obj2);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcompare_usage_additions
| 
|       Purpose: Prints usage additions in kcompare_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcompare
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcompare_usage_additions(void)
{
	kfprintf(kstderr, "\tComparison Operators\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcompare_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcompare_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcompare
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcompare_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
