 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kblend
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kblend.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Output = (Input 1 * Constant) + (Input 2 (1 - Constant))
|
|       Purpose: main program for kblend
|
|         Input:
|		char *clui_info->i1_file; {first input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {second input file object}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    double clui_info->ratio_double; {Ratio of blending the two objects}
|		    int    clui_info->ratio_flag; {TRUE if -ratio specified}
|
|		    char *clui_info->iratio_file; {Input object for providing blending ratios}
|		    int   clui_info->iratio_flag; {TRUE if -iratio specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj1 = NULL, in_obj2 = NULL, out_obj = NULL;
        kobject ratio_obj = NULL;
        double  ratio=0.5;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kblend_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kblend",
		kblend_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kblend_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj1  = kpds_open_input_object(clui_info->i1_file)) == NULL)
        {
           kerror("kblend","main","Cannot open input object 1.");
           kexit(KEXIT_FAILURE);
        }

        if ((in_obj2  = kpds_open_input_object(clui_info->i2_file)) == NULL)
        {
           kerror("kblend","main","Cannot open input object 2.");
           kexit(KEXIT_FAILURE);
        }
        
        if ((out_obj  = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("kblend","main","Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (clui_info->iratio_flag)
        {
           if ((ratio_obj=kpds_open_input_object(
                          clui_info->iratio_file))== NULL)
           {
              kerror("kblend","main","Cannot open ratio object.");
              kexit(KEXIT_FAILURE);
           }
        }
        else 
        if (clui_info->ratio_flag)
        {
           ratio = clui_info->ratio_double;
        }
 
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkblend(in_obj1,in_obj2,NULL,ratio_obj,
                     ratio,out_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kblend", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}
	
	kpds_close_object(in_obj1);
	kpds_close_object(in_obj2);
	kpds_close_object(ratio_obj);
	kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kblend_usage_additions
| 
|       Purpose: Prints usage additions in kblend_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kblend
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kblend_usage_additions(void)
{
	kfprintf(kstderr, "\tOutput = (Input 1 * Constant) + (Input 2 (1 - Constant))\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kblend_free_args
| 
|       Purpose: Frees CLUI struct allocated in kblend_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kblend
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kblend_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
